/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.util.ArrayList;
import java.util.List;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.remote.PointCollectionStreamRemote;
import ucar.nc2.ft.point.remote.StationCollectionStream;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class PointDatasetRemote
extends PointDatasetImpl {
    public PointDatasetRemote(FeatureType wantFeatureType, String uri, CalendarDateUnit timeUnit, String altUnits, List<VariableSimpleIF> vars, LatLonRect bb, CalendarDateRange dr) {
        super(wantFeatureType);
        this.setBoundingBox(bb);
        this.setDateRange(dr);
        this.setLocationURI("cdmrFeature:" + uri);
        this.dataVariables = new ArrayList<VariableSimpleIF>(vars);
        this.collectionList = new ArrayList(1);
        switch (wantFeatureType) {
            case POINT: {
                this.collectionList.add(new PointCollectionStreamRemote(uri, timeUnit, altUnits, null));
                break;
            }
            case STATION: {
                this.collectionList.add(new StationCollectionStream(uri, timeUnit, altUnits));
                break;
            }
            default: {
                throw new UnsupportedOperationException("No implementation for " + (Object)((Object)wantFeatureType));
            }
        }
    }

    static String makeQuery(String station, LatLonRect boundingBox, CalendarDateRange dateRange) {
        StringBuilder query = new StringBuilder();
        boolean needamp = false;
        if (station != null) {
            query.append(station);
            needamp = true;
        }
        if (boundingBox != null) {
            if (needamp) {
                query.append("&");
            }
            query.append("west=");
            query.append(boundingBox.getLonMin());
            query.append("&east=");
            query.append(boundingBox.getLonMax());
            query.append("&south=");
            query.append(boundingBox.getLatMin());
            query.append("&north=");
            query.append(boundingBox.getLatMax());
            needamp = true;
        }
        if (dateRange != null) {
            if (needamp) {
                query.append("&");
            }
            query.append("time_start=");
            query.append(dateRange.getStart());
            query.append("&time_end=");
            query.append(dateRange.getEnd());
        }
        if (!needamp) {
            query.append("all");
        }
        return query.toString();
    }
}

