/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.conv.CoardsConventions;
import ucar.nc2.util.CancelTask;

class CSMConvention
extends CoardsConventions {
    private static final String CONVENTION_NAME = "NCAR-CSM";

    CSMConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        for (Variable.Builder<?> vb : this.rootGroup.vbuilders) {
            VariableDS.Builder vds = (VariableDS.Builder)vb;
            String unit = vds.getUnits();
            if (unit == null || !unit.equalsIgnoreCase("hybrid_sigma_pressure") && !unit.equalsIgnoreCase("sigma_level")) continue;
            vds.addAttribute(new Attribute("_CoordinateAxisType", AxisType.GeoZ.toString()));
            vds.addAttribute(new Attribute("_CoordinateTransformType", TransformType.Vertical.toString()));
            vds.addAttribute(new Attribute("_CoordinateAxes", vds.getFullName()));
        }
    }

    @Override
    protected void identifyCoordinateAxes() {
        for (CoordSystemBuilder.VarProcess vp : this.varList) {
            String coordsString;
            if (vp.coordinateAxes != null || (coordsString = vp.vb.getAttributeContainer().findAttributeString("coordinates", null)) == null) continue;
            vp.coordinates = coordsString;
        }
        super.identifyCoordinateAxes();
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return CSMConvention.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new CSMConvention(datasetBuilder);
        }
    }
}

