/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in.LeicaMicrosystemsMetadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.in.APNGReader;
import loci.formats.in.BMPReader;
import loci.formats.in.JPEGReader;
import loci.formats.in.LOFReader;
import loci.formats.in.LeicaMicrosystemsMetadata.Dimension;
import loci.formats.in.LeicaMicrosystemsMetadata.LMSFileReader;
import loci.formats.in.LeicaMicrosystemsMetadata.MetadataTempBuffer;
import loci.formats.in.LeicaMicrosystemsMetadata.XlifDocument;
import loci.formats.in.TiffDelegateReader;

public class MultipleImagesReader
extends LMSFileReader {
    private List<FormatReader> readers = new ArrayList<FormatReader>();
    private LMSFileReader.ImageFormat imageFormat;
    private int tileCount;
    private boolean dimensionsSwapped = false;
    private int series = 0;
    private int imageIndex;

    public MultipleImagesReader(XlifDocument xlif, int imageIndex) throws FormatException, IOException {
        super("Multiple images", ".*");
        this.imageFormat = xlif.getImageFormat();
        this.tileCount = xlif.getTileCount();
        this.associatedXmlDoc = xlif;
        this.initReaders(xlif.getImagePaths());
        this.imageIndex = imageIndex;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.tileCount > 1) {
            no += this.series * this.readers.size() / this.tileCount;
        }
        FormatReader reader = this.readers.get(no);
        buf = reader.openBytes(0, buf, x, y, w, h);
        return buf;
    }

    public void setSeries(int no) {
        this.series = no;
    }

    public int getRGBChannelCount() {
        return this.readers.get(0).getRGBChannelCount();
    }

    public int getBitsPerPixel() {
        return this.readers.get(0).getBitsPerPixel();
    }

    public int getPixelType() {
        return this.readers.get(0).getPixelType();
    }

    public int getSizeC() {
        return this.readers.get(0).getSizeC();
    }

    public boolean isRGB() {
        return this.readers.get(0).isRGB();
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.imageFormat = null;
            this.tileCount = 0;
            this.dimensionsSwapped = false;
            this.series = 0;
            this.imageIndex = 0;
            for (FormatReader reader : this.readers) {
                reader.close(fileOnly);
            }
            this.readers.clear();
        }
    }

    private void initReaders(List<String> ids) throws FormatException, IOException {
        block7: for (String id : ids) {
            if (!LMSFileReader.fileExists(id)) {
                throw new IOException("Project is not valid because referenced image file does not exist: " + id);
            }
            switch (this.imageFormat) {
                case LOF: {
                    LOFReader reader = new LOFReader();
                    reader.setId(id);
                    this.readers.add(reader);
                    continue block7;
                }
                case TIF: {
                    LOFReader reader = new TiffDelegateReader();
                    reader.setId(id);
                    this.readers.add(reader);
                    continue block7;
                }
                case BMP: {
                    LOFReader reader = new BMPReader();
                    reader.setId(id);
                    this.readers.add(reader);
                    continue block7;
                }
                case JPEG: {
                    LOFReader reader = new JPEGReader();
                    reader.setId(id);
                    this.readers.add(reader);
                    continue block7;
                }
                case PNG: {
                    LOFReader reader = new APNGReader();
                    reader.setId(id);
                    this.readers.add(reader);
                    continue block7;
                }
            }
            LOGGER.error("Unknown image format: " + id);
        }
    }

    @Override
    public LMSFileReader.ImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public void setMetadataTempBuffer(MetadataTempBuffer metaTemp) {
        this.metaTemp = metaTemp;
    }

    public void setCoreMetadata(CoreMetadata cmd) {
        if (this.core == null) {
            this.core = new ArrayList();
        }
        this.core.add(cmd);
    }

    public void swapDimensions() throws FormatException {
        CoreMetadata cmd = (CoreMetadata)this.core.get(0);
        if (!this.dimensionsSwapped) {
            int sizeZ = cmd.sizeZ;
            int sizeT = cmd.sizeT;
            int sizeS = this.tileCount;
            ArrayList<FormatReader> newOrder = new ArrayList<FormatReader>();
            ArrayList<Dimension> dimensions = this.metaTemp.getDimensions(this.imageIndex);
            Dimension dimZ = this.metaTemp.getDimension(this.imageIndex, Dimension.DimensionKey.Z);
            Dimension dimC = this.metaTemp.getDimension(this.imageIndex, Dimension.DimensionKey.C);
            Dimension dimT = this.metaTemp.getDimension(this.imageIndex, Dimension.DimensionKey.T);
            Dimension dimS = this.metaTemp.getDimension(this.imageIndex, Dimension.DimensionKey.S);
            for (int indexDim5 = 0; indexDim5 < ((Dimension)dimensions.get((int)5)).size; ++indexDim5) {
                ((Dimension)dimensions.get((int)5)).frameIndex = indexDim5;
                for (int indexDim4 = 0; indexDim4 < ((Dimension)dimensions.get((int)4)).size; ++indexDim4) {
                    ((Dimension)dimensions.get((int)4)).frameIndex = indexDim4;
                    for (int indexDim3 = 0; indexDim3 < ((Dimension)dimensions.get((int)3)).size; ++indexDim3) {
                        ((Dimension)dimensions.get((int)3)).frameIndex = indexDim3;
                        int indexDim2 = 0;
                        while (indexDim2 < ((Dimension)dimensions.get((int)2)).size) {
                            ((Dimension)dimensions.get((int)2)).frameIndex = indexDim2++;
                            int index = dimZ.frameIndex + sizeZ * dimS.frameIndex + sizeZ * sizeS * dimT.frameIndex + sizeZ * sizeS * sizeT * dimC.frameIndex;
                            newOrder.add(this.readers.get(index));
                        }
                    }
                }
            }
            this.readers = newOrder;
            this.dimensionsSwapped = true;
        }
    }

    public void reopenFile() throws IOException {
        for (FormatReader reader : this.readers) {
            reader.reopenFile();
        }
    }
}

