/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataStore;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.unit.Unit;

public class ReadPhysicalSize {
    public static void readPhysicalSize(String inputFile) throws FormatException, IOException {
        ImageReader reader = new ImageReader();
        IMetadata omeMeta = MetadataTools.createOMEXMLMetadata();
        reader.setMetadataStore((MetadataStore)omeMeta);
        reader.setId(inputFile);
        Unit targetUnit = UNITS.MICROMETER;
        for (int image = 0; image < omeMeta.getImageCount(); ++image) {
            Length physSizeX = omeMeta.getPixelsPhysicalSizeX(image);
            Length physSizeY = omeMeta.getPixelsPhysicalSizeY(image);
            Length physSizeZ = omeMeta.getPixelsPhysicalSizeZ(image);
            System.out.println("Physical calibration - Image: " + image);
            if (physSizeX != null) {
                Length convertedSizeX = new Length(physSizeX.value(targetUnit), targetUnit);
                System.out.println("\tX = " + physSizeX.value() + " " + physSizeX.unit().getSymbol() + " = " + convertedSizeX.value() + " " + convertedSizeX.unit().getSymbol());
            }
            if (physSizeY != null) {
                Length convertedSizeY = new Length(physSizeY.value(targetUnit), targetUnit);
                System.out.println("\tY = " + physSizeY.value() + " " + physSizeY.unit().getSymbol() + " = " + convertedSizeY.value() + " " + convertedSizeY.unit().getSymbol());
            }
            if (physSizeZ == null) continue;
            Length convertedSizeZ = new Length(physSizeZ.value(targetUnit), targetUnit);
            System.out.println("\tZ = " + physSizeZ.value() + " " + physSizeZ.unit().getSymbol() + " = " + convertedSizeZ.value() + " " + convertedSizeZ.unit().getSymbol());
        }
        reader.close();
    }

    public static void main(String[] args) throws Exception {
        ReadPhysicalSize.readPhysicalSize(args[0]);
    }
}

