/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.ImageWriter;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;

public class ReadWriteInMemory {
    public static void main(String[] args) throws DependencyException, FormatException, IOException, ServiceException {
        if (args.length < 1) {
            System.out.println("Please specify a (small) image file.");
            System.exit(1);
        }
        String path = args[0];
        System.out.println("Reading file into memory from disk...");
        File inputFile = new File(path);
        int fileSize = (int)inputFile.length();
        DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
        byte[] inBytes = new byte[fileSize];
        in.readFully(inBytes);
        System.out.println(fileSize + " bytes read.");
        String fileName = inputFile.getName();
        int dot = fileName.lastIndexOf(".");
        String suffix = dot < 0 ? "" : fileName.substring(dot);
        String inId = "inBytes" + suffix;
        Location.mapFile((String)inId, (IRandomAccess)new ByteArrayHandle(inBytes));
        System.out.println();
        System.out.println("Reading image data from memory...");
        ServiceFactory factory = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
        OMEXMLMetadata omeMeta = service.createOMEXMLMetadata();
        ImageReader reader = new ImageReader();
        reader.setMetadataStore((MetadataStore)omeMeta);
        reader.setId(inId);
        int seriesCount = reader.getSeriesCount();
        int imageCount = reader.getImageCount();
        int sizeX = reader.getSizeX();
        int sizeY = reader.getSizeY();
        int sizeZ = reader.getSizeZ();
        int sizeC = reader.getSizeC();
        int sizeT = reader.getSizeT();
        System.out.println("Series count: " + seriesCount);
        System.out.println("First series:");
        System.out.println("\tImage count = " + imageCount);
        System.out.println("\tSizeX = " + sizeX);
        System.out.println("\tSizeY = " + sizeY);
        System.out.println("\tSizeZ = " + sizeZ);
        System.out.println("\tSizeC = " + sizeC);
        System.out.println("\tSizeT = " + sizeT);
        String outId = fileName + ".ome.tif";
        ByteArrayHandle outputFile = new ByteArrayHandle();
        Location.mapFile((String)outId, (IRandomAccess)outputFile);
        System.out.println();
        System.out.print("Writing planes to destination in memory: ");
        ImageWriter writer = new ImageWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)omeMeta);
        writer.setId(outId);
        byte[] plane = null;
        for (int i = 0; i < imageCount; ++i) {
            if (plane == null) {
                plane = reader.openBytes(i);
            } else {
                reader.openBytes(i, plane);
            }
            writer.saveBytes(i, plane);
            System.out.print(".");
        }
        reader.close();
        writer.close();
        System.out.println();
        byte[] outBytes = outputFile.getBytes();
        outputFile.close();
        System.out.println();
        System.out.println("Flushing image data to disk...");
        File outFile = new File(fileName + ".ome.tif");
        DataOutputStream out = new DataOutputStream(new FileOutputStream(outFile));
        out.write(outBytes);
        out.close();
    }
}

