/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.tools;

import java.io.File;
import java.io.IOException;
import loci.common.DataTools;
import loci.formats.Memoizer;
import loci.formats.tools.CommandLineTools;

public class GenerateCache {
    private static void generateMemo(Memoizer reader, String path) {
        boolean success = false;
        try {
            success = reader.generateMemo(path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!success) {
            System.out.println("Memo file not saved for " + path);
        }
    }

    private static void processDirectory(Memoizer reader, File dir) {
        String[] list;
        for (String f : list = dir.list()) {
            File file = new File(dir, f);
            if (file.isDirectory()) {
                GenerateCache.processDirectory(reader, file);
                continue;
            }
            GenerateCache.generateMemo(reader, file.getAbsolutePath());
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage:");
            System.out.println("cachegen [-list] fileOrDir cacheFileDir");
            System.out.println();
            System.out.println("If '-list' is specified, then 'fileOrDir' is a text file with one file per line.");
            return;
        }
        CommandLineTools.runUpgradeCheck(args);
        boolean fileList = args.length >= 3 && args[0].equals("-list");
        String input = args[args.length - 2];
        String outputDir = args[args.length - 1];
        Memoizer reader = new Memoizer(0L, new File(outputDir));
        File inputFile = new File(input);
        if (!inputFile.isDirectory()) {
            if (fileList) {
                String[] files = null;
                try {
                    files = DataTools.readFile((String)inputFile.getAbsolutePath()).split("\n");
                }
                catch (IOException e) {
                    System.out.println("Could not read file list from " + inputFile);
                    e.printStackTrace();
                }
                if (files != null) {
                    for (String f : files) {
                        GenerateCache.generateMemo(reader, f);
                    }
                }
            } else {
                GenerateCache.generateMemo(reader, inputFile.getAbsolutePath());
            }
        } else {
            GenerateCache.processDirectory(reader, inputFile);
        }
    }
}

