/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5ArrayBlockParams;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataSet;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5ShortReader;
import ch.systemsx.cisd.hdf5.IndexMap;
import ch.systemsx.cisd.hdf5.MatrixUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.exceptions.HDF5SpaceRankMismatch;
import hdf.hdf5lib.HDF5Constants;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import hdf.hdf5lib.exceptions.HDF5LibraryException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

class HDF5UnsignedShortReader
implements IHDF5ShortReader {
    private final HDF5BaseReader baseReader;

    HDF5UnsignedShortReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    HDF5BaseReader getBaseReader() {
        return this.baseReader;
    }

    @Override
    public short getAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Short> getAttributeRunnable = new ICallableWithCleanUp<Short>(){

            @Override
            public Short call(ICleanUpRegistry registry) {
                long objectId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openObject(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                long attributeId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                short[] data = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readAttributeAsShortArray(attributeId, HDF5Constants.H5T_NATIVE_UINT16, 1);
                return data[0];
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public short[] getArrayAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<short[]> getAttributeRunnable = new ICallableWithCleanUp<short[]>(){

            @Override
            public short[] call(ICleanUpRegistry registry) {
                long objectId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openObject(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                return HDF5UnsignedShortReader.this.getShortArrayAttribute(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public MDShortArray getMDArrayAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDShortArray> getAttributeRunnable = new ICallableWithCleanUp<MDShortArray>(){

            @Override
            public MDShortArray call(ICleanUpRegistry registry) {
                long objectId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openObject(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                return HDF5UnsignedShortReader.this.getShortMDArrayAttribute(objectId, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public short[][] getMatrixAttr(String objectPath, String attributeName) throws HDF5JavaException {
        MDShortArray array = this.getMDArrayAttr(objectPath, attributeName);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public short read(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<Short> readCallable = new ICallableWithCleanUp<Short>(){

            @Override
            public Short call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openDataSet(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                short[] data = new short[1];
                ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, data);
                return data[0];
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public short[] readArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<short[]> readCallable = new ICallableWithCleanUp<short[]>(){

            @Override
            public short[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openDataSet(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                return HDF5UnsignedShortReader.this.readShortArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private short[] readShortArray(long dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            short[] data = new short[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return data;
        }
        catch (HDF5LibraryException ex) {
            long dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readShortArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private short[] readShortArrayFromArrayType(long dataSetId, long dataTypeId, ICleanUpRegistry registry) {
        long spaceId = this.baseReader.h5.createScalarDataSpace();
        int[] dimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        short[] data = new short[HDF5Utils.getOneDimensionalArraySize(dimensions)];
        long memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT16, data.length, registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
        return data;
    }

    @Override
    public int[] readToMDArrayWithOffset(final String objectPath, final MDShortArray array, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openDataSet(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5UnsignedShortReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), registry);
                long nativeDataTypeId = HDF5UnsignedShortReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, registry);
                ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayWithOffset(final HDF5DataSet dataSet, final MDShortArray array, final int[] memoryOffset) {
        assert (dataSet != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                long dataSetId = dataSet.getDataSetId();
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5UnsignedShortReader.this.baseReader.getBlockSpaceParameters(dataSet, memoryOffset, array.dimensions());
                long nativeDataTypeId = HDF5UnsignedShortReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, registry);
                ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayBlockWithOffset(final String objectPath, final MDShortArray array, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openDataSet(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5UnsignedShortReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), offset, blockDimensions, registry);
                long nativeDataTypeId = HDF5UnsignedShortReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, registry);
                ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayBlockWithOffset(final HDF5DataSet dataSet, final MDShortArray array, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (dataSet != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                long dataSetId = dataSet.getDataSetId();
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5UnsignedShortReader.this.baseReader.getBlockSpaceParameters(dataSet, memoryOffset, array.dimensions(), offset, blockDimensions);
                long nativeDataTypeId = HDF5UnsignedShortReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, registry);
                ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                return MDArray.toInt(spaceParams.dimensions);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public short[] readArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public short[] readArrayBlock(HDF5DataSet dataSet, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(dataSet, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public short[] readArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<short[]> readCallable = new ICallableWithCleanUp<short[]>(){

            @Override
            public short[] call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openDataSet(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5UnsignedShortReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                short[] data = new short[spaceParams.blockSize];
                ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public short[] readArrayBlockWithOffset(final HDF5DataSet dataSet, final int blockSize, final long offset) {
        assert (dataSet != null);
        this.baseReader.checkOpen();
        this.baseReader.h5.checkRank(1, dataSet.getRank());
        ICallableWithCleanUp<short[]> readCallable = new ICallableWithCleanUp<short[]>(){

            @Override
            public short[] call(ICleanUpRegistry registry) {
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5UnsignedShortReader.this.baseReader.getSpaceParameters(dataSet, offset, blockSize);
                short[] data = new short[spaceParams.blockSize];
                ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSet.getDataSetId(), HDF5Constants.H5T_NATIVE_UINT16, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return data;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public short[][] readMatrix(String objectPath) throws HDF5JavaException {
        MDShortArray array = this.readMDArray(objectPath);
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public short[][] readMatrixBlock(String objectPath, int blockSizeX, int blockSizeY, long blockNumberX, long blockNumberY) throws HDF5JavaException {
        MDShortArray array = this.readMDArrayBlock(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{blockNumberX, blockNumberY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public short[][] readMatrixBlockWithOffset(String objectPath, int blockSizeX, int blockSizeY, long offsetX, long offsetY) throws HDF5JavaException {
        MDShortArray array = this.readMDArrayBlockWithOffset(objectPath, new int[]{blockSizeX, blockSizeY}, new long[]{offsetX, offsetY});
        if (array.rank() != 2) {
            throw new HDF5JavaException("Array is supposed to be of rank 2, but is of rank " + array.rank());
        }
        return array.toMatrix();
    }

    @Override
    public MDShortArray readMDArraySlice(String objectPath, IndexMap boundIndices) {
        this.baseReader.checkOpen();
        long[] fullDimensions = this.baseReader.getDimensions(objectPath);
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        int cardBoundIndices = MatrixUtils.cardinalityBoundIndices(boundIndices);
        MatrixUtils.checkBoundIndices(objectPath, fullDimensions, cardBoundIndices);
        int[] effectiveBlockDimensions = new int[fullBlockDimensions.length - cardBoundIndices];
        Arrays.fill(effectiveBlockDimensions, -1);
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, null, (Map<Integer, Long>)boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDShortArray result = this.readMDArrayBlockWithOffset(objectPath, fullBlockDimensions, fullOffset);
        if (fullBlockDimensions.length == cardBoundIndices) {
            return new MDShortArray(result.getAsFlatArray(), new int[]{1});
        }
        return new MDShortArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDShortArray readMDArraySlice(HDF5DataSet dataSet, IndexMap boundIndices) {
        this.baseReader.checkOpen();
        long[] fullDimensions = dataSet.getDimensions();
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        int cardBoundIndices = MatrixUtils.cardinalityBoundIndices(boundIndices);
        MatrixUtils.checkBoundIndices(dataSet.getDataSetPath(), fullDimensions, cardBoundIndices);
        int[] effectiveBlockDimensions = new int[fullBlockDimensions.length - cardBoundIndices];
        Arrays.fill(effectiveBlockDimensions, -1);
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, null, (Map<Integer, Long>)boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDShortArray result = this.readMDArrayBlockWithOffset(dataSet, fullBlockDimensions, fullOffset);
        if (fullBlockDimensions.length == cardBoundIndices) {
            return new MDShortArray(result.getAsFlatArray(), new int[]{1});
        }
        return new MDShortArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDShortArray readMDArraySlice(String objectPath, long[] boundIndices) {
        this.baseReader.checkOpen();
        long[] fullDimensions = this.baseReader.getDimensions(objectPath);
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        int cardBoundIndices = MatrixUtils.cardinalityBoundIndices(boundIndices);
        MatrixUtils.checkBoundIndices(objectPath, fullDimensions, boundIndices);
        int[] effectiveBlockDimensions = new int[fullBlockDimensions.length - cardBoundIndices];
        Arrays.fill(effectiveBlockDimensions, -1);
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, null, boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDShortArray result = this.readMDArrayBlockWithOffset(objectPath, fullBlockDimensions, fullOffset);
        if (fullBlockDimensions.length == cardBoundIndices) {
            return new MDShortArray(result.getAsFlatArray(), new int[]{1});
        }
        return new MDShortArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDShortArray readMDArraySlice(HDF5DataSet dataSet, long[] boundIndices) {
        this.baseReader.checkOpen();
        long[] fullDimensions = dataSet.getDimensions();
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        int cardBoundIndices = MatrixUtils.cardinalityBoundIndices(boundIndices);
        MatrixUtils.checkBoundIndices(dataSet.getDataSetPath(), fullDimensions, boundIndices);
        int[] effectiveBlockDimensions = new int[fullBlockDimensions.length - cardBoundIndices];
        Arrays.fill(effectiveBlockDimensions, -1);
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, null, boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDShortArray result = this.readMDArrayBlockWithOffset(dataSet, fullBlockDimensions, fullOffset);
        if (fullBlockDimensions.length == cardBoundIndices) {
            return new MDShortArray(result.getAsFlatArray(), new int[]{1});
        }
        return new MDShortArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDShortArray readMDArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDShortArray> readCallable = new ICallableWithCleanUp<MDShortArray>(){

            @Override
            public MDShortArray call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openDataSet(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                return HDF5UnsignedShortReader.this.readShortMDArray(dataSetId, registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    MDShortArray readMDArray(final HDF5DataSet dataSet) {
        assert (dataSet != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDShortArray> readCallable = new ICallableWithCleanUp<MDShortArray>(){

            @Override
            public MDShortArray call(ICleanUpRegistry registry) {
                return HDF5UnsignedShortReader.this.readShortMDArray(dataSet.getDataSetId(), registry);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    MDShortArray readShortMDArray(long dataSetId, ICleanUpRegistry registry) {
        try {
            HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
            short[] data = new short[spaceParams.blockSize];
            this.baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
            return new MDShortArray(data, spaceParams.dimensions);
        }
        catch (HDF5LibraryException ex) {
            long dataTypeId;
            if (ex.getMajorErrorNumber() == HDF5Constants.H5E_DATATYPE && ex.getMinorErrorNumber() == HDF5Constants.H5E_CANTINIT && this.baseReader.h5.getClassType(dataTypeId = this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry)) == HDF5Constants.H5T_ARRAY) {
                return this.readShortMDArrayFromArrayType(dataSetId, dataTypeId, registry);
            }
            throw ex;
        }
    }

    private MDShortArray readShortMDArrayFromArrayType(long dataSetId, long dataTypeId, ICleanUpRegistry registry) {
        int[] arrayDimensions = this.baseReader.h5.getArrayDimensions(dataTypeId);
        long memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT16, arrayDimensions, registry);
        HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, registry);
        if (spaceParams.blockSize == 0) {
            long spaceId = this.baseReader.h5.createScalarDataSpace();
            short[] data = new short[MDArray.getLength(arrayDimensions)];
            this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceId, spaceId, data);
            return new MDShortArray(data, arrayDimensions);
        }
        short[] data = new short[MDArray.getLength(arrayDimensions) * spaceParams.blockSize];
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
        return new MDShortArray(data, MatrixUtils.concat(MDArray.toInt(spaceParams.dimensions), arrayDimensions));
    }

    @Override
    public MDShortArray readMDArray(String objectPath, HDF5ArrayBlockParams params) {
        this.baseReader.checkOpen();
        Throwable throwable = null;
        Object var4_5 = null;
        try (HDF5DataSet dataSet = this.baseReader.openDataSet(objectPath);){
            return this.readMDArray(dataSet, params);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public MDShortArray readMDArray(HDF5DataSet dataSet, HDF5ArrayBlockParams params) {
        if (params.hasBlock()) {
            if (params.hasSlice()) {
                if (params.getBoundIndexArray() != null) {
                    return this.readSlicedMDArrayBlockWithOffset(dataSet, params.getBlockDimensions(), params.getOffset(), params.getBoundIndexArray());
                }
                return this.readSlicedMDArrayBlockWithOffset(dataSet, params.getBlockDimensions(), params.getOffset(), params.getBoundIndexMap());
            }
            return this.readMDArrayBlockWithOffset(dataSet, params.getBlockDimensions(), params.getOffset());
        }
        if (params.hasSlice()) {
            if (params.getBoundIndexArray() != null) {
                return this.readMDArraySlice(dataSet, params.getBoundIndexArray());
            }
            return this.readMDArraySlice(dataSet, params.getBoundIndexMap());
        }
        return this.readMDArray(dataSet);
    }

    @Override
    public MDShortArray readSlicedMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber, IndexMap boundIndices) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readSlicedMDArrayBlockWithOffset(objectPath, blockDimensions, offset, boundIndices);
    }

    @Override
    public MDShortArray readSlicedMDArrayBlock(HDF5DataSet dataSet, int[] blockDimensions, long[] blockNumber, IndexMap boundIndices) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readSlicedMDArrayBlockWithOffset(dataSet, blockDimensions, offset, boundIndices);
    }

    @Override
    public MDShortArray readSlicedMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber, long[] boundIndices) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readSlicedMDArrayBlockWithOffset(objectPath, blockDimensions, offset, boundIndices);
    }

    @Override
    public MDShortArray readSlicedMDArrayBlock(HDF5DataSet dataSet, int[] blockDimensions, long[] blockNumber, long[] boundIndices) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readSlicedMDArrayBlockWithOffset(dataSet, blockDimensions, offset, boundIndices);
    }

    @Override
    public MDShortArray readMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public MDShortArray readSlicedMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset, IndexMap boundIndices) {
        this.baseReader.checkOpen();
        int[] effectiveBlockDimensions = (int[])blockDimensions.clone();
        long[] fullDimensions = this.baseReader.getDimensions(objectPath);
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        MatrixUtils.checkBoundIndices(objectPath, fullDimensions, blockDimensions, MatrixUtils.cardinalityBoundIndices(boundIndices));
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, offset, (Map<Integer, Long>)boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDShortArray result = this.readMDArrayBlockWithOffset(objectPath, fullBlockDimensions, fullOffset);
        return new MDShortArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDShortArray readSlicedMDArrayBlockWithOffset(HDF5DataSet dataSet, int[] blockDimensions, long[] offset, IndexMap boundIndices) {
        this.baseReader.checkOpen();
        int[] effectiveBlockDimensions = (int[])blockDimensions.clone();
        long[] fullDimensions = dataSet.getDimensions();
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        MatrixUtils.checkBoundIndices(dataSet.getDataSetPath(), fullDimensions, blockDimensions, MatrixUtils.cardinalityBoundIndices(boundIndices));
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, offset, (Map<Integer, Long>)boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDShortArray result = this.readMDArrayBlockWithOffset(dataSet, fullBlockDimensions, fullOffset);
        return new MDShortArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDShortArray readSlicedMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset, long[] boundIndices) {
        this.baseReader.checkOpen();
        int[] effectiveBlockDimensions = (int[])blockDimensions.clone();
        long[] fullDimensions = this.baseReader.getDimensions(objectPath);
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        MatrixUtils.checkBoundIndices(objectPath, fullDimensions, blockDimensions, MatrixUtils.cardinalityBoundIndices(boundIndices));
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, offset, boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDShortArray result = this.readMDArrayBlockWithOffset(objectPath, fullBlockDimensions, fullOffset);
        return new MDShortArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDShortArray readSlicedMDArrayBlockWithOffset(HDF5DataSet dataSet, int[] blockDimensions, long[] offset, long[] boundIndices) {
        this.baseReader.checkOpen();
        int[] effectiveBlockDimensions = (int[])blockDimensions.clone();
        long[] fullDimensions = dataSet.getDimensions();
        int[] fullBlockDimensions = new int[fullDimensions.length];
        long[] fullOffset = new long[fullDimensions.length];
        MatrixUtils.checkBoundIndices(dataSet.getDataSetPath(), fullDimensions, blockDimensions, MatrixUtils.cardinalityBoundIndices(boundIndices));
        MatrixUtils.createFullBlockDimensionsAndOffset(effectiveBlockDimensions, offset, boundIndices, fullDimensions, fullBlockDimensions, fullOffset);
        MDShortArray result = this.readMDArrayBlockWithOffset(dataSet, fullBlockDimensions, fullOffset);
        return new MDShortArray(result.getAsFlatArray(), effectiveBlockDimensions);
    }

    @Override
    public MDShortArray readMDArrayBlock(HDF5DataSet dataSet, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(dataSet, blockDimensions, offset);
    }

    @Override
    public MDShortArray readMDArrayBlockWithOffset(final HDF5DataSet dataSet, final int[] blockDimensions, final long[] offset) {
        assert (dataSet != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        this.baseReader.h5.checkRank(blockDimensions.length, offset.length);
        this.baseReader.h5.checkRank(blockDimensions.length, dataSet.getRank());
        ICallableWithCleanUp<MDShortArray> readCallable = new ICallableWithCleanUp<MDShortArray>(){

            @Override
            public MDShortArray call(ICleanUpRegistry registry) {
                long dataSetId = dataSet.getDataSetId();
                try {
                    HDF5BaseReader.DataSpaceParameters spaceParams = HDF5UnsignedShortReader.this.baseReader.getSpaceParameters(dataSet, offset, blockDimensions);
                    short[] dataBlock = new short[spaceParams.blockSize];
                    ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                    return new MDShortArray(dataBlock, spaceParams.dimensions);
                }
                catch (HDF5SpaceRankMismatch ex) {
                    HDF5DataSetInformation info = HDF5UnsignedShortReader.this.baseReader.getDataSetInformation(dataSet.getDataSetPath(), HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL, false);
                    if (ex.getSpaceRankExpected() - ex.getSpaceRankFound() == info.getTypeInformation().getRank()) {
                        return HDF5UnsignedShortReader.this.readMDArrayBlockOfArrays(dataSetId, blockDimensions, offset, info, ex.getSpaceRankFound(), registry);
                    }
                    throw ex;
                }
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public MDShortArray readMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset) {
        assert (objectPath != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<MDShortArray> readCallable = new ICallableWithCleanUp<MDShortArray>(){

            @Override
            public MDShortArray call(ICleanUpRegistry registry) {
                long dataSetId = ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.openDataSet(((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.fileId, objectPath, registry);
                try {
                    HDF5BaseReader.DataSpaceParameters spaceParams = HDF5UnsignedShortReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                    short[] dataBlock = new short[spaceParams.blockSize];
                    ((HDF5UnsignedShortReader)HDF5UnsignedShortReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_UINT16, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                    return new MDShortArray(dataBlock, spaceParams.dimensions);
                }
                catch (HDF5SpaceRankMismatch ex) {
                    HDF5DataSetInformation info = HDF5UnsignedShortReader.this.baseReader.getDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL, false);
                    if (ex.getSpaceRankExpected() - ex.getSpaceRankFound() == info.getTypeInformation().getRank()) {
                        return HDF5UnsignedShortReader.this.readMDArrayBlockOfArrays(dataSetId, blockDimensions, offset, info, ex.getSpaceRankFound(), registry);
                    }
                    throw ex;
                }
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    private MDShortArray readMDArrayBlockOfArrays(long dataSetId, int[] blockDimensions, long[] offset, HDF5DataSetInformation info, int spaceRank, ICleanUpRegistry registry) {
        int[] arrayDimensions = info.getTypeInformation().getDimensions();
        int[] effectiveBlockDimensions = blockDimensions;
        int i = 0;
        while (i < arrayDimensions.length) {
            int j = spaceRank + i;
            if (effectiveBlockDimensions[j] < 0) {
                if (effectiveBlockDimensions == blockDimensions) {
                    effectiveBlockDimensions = (int[])blockDimensions.clone();
                }
                effectiveBlockDimensions[j] = arrayDimensions[i];
            }
            if (effectiveBlockDimensions[j] != arrayDimensions[i]) {
                throw new HDF5JavaException("Block-wise reading of array type data sets is not supported.");
            }
            ++i;
        }
        int[] spaceBlockDimensions = Arrays.copyOfRange(effectiveBlockDimensions, 0, spaceRank);
        long[] spaceOfs = Arrays.copyOfRange(offset, 0, spaceRank);
        HDF5BaseReader.DataSpaceParameters spaceParams = this.baseReader.getSpaceParameters(dataSetId, spaceOfs, spaceBlockDimensions, registry);
        short[] dataBlock = new short[spaceParams.blockSize * info.getTypeInformation().getNumberOfElements()];
        long memoryDataTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT16, info.getTypeInformation().getDimensions(), registry);
        this.baseReader.h5.readDataSet(dataSetId, memoryDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
        return new MDShortArray(dataBlock, effectiveBlockDimensions);
    }

    @Override
    public Iterable<HDF5DataBlock<short[]>> getArrayNaturalBlocks(final String dataSetPath) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5DataBlock<short[]>>(){

            @Override
            public Iterator<HDF5DataBlock<short[]>> iterator() {
                return new Iterator<HDF5DataBlock<short[]>>(dataSetPath, params){
                    final HDF5DataSet dataSet;
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.dataSet = HDF5UnsignedShortReader.this.baseReader.openDataSet(string);
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<short[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        short[] block = HDF5UnsignedShortReader.this.readArrayBlockWithOffset(this.dataSet, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<short[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<MDShortArray>> getMDArrayNaturalBlocks(final String dataSetPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<MDShortArray>>(){

            @Override
            public Iterator<HDF5MDDataBlock<MDShortArray>> iterator() {
                return new Iterator<HDF5MDDataBlock<MDShortArray>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<MDShortArray> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        MDShortArray data = HDF5UnsignedShortReader.this.readMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<MDShortArray>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    short[] getShortArrayAttribute(long objectId, String attributeName, ICleanUpRegistry registry) {
        long memoryTypeId;
        int len;
        Object[] arrayDimensions;
        long attributeId = this.baseReader.h5.openAttribute(objectId, attributeName, registry);
        long attributeTypeId = this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
        if (this.baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
            arrayDimensions = this.baseReader.h5.getArrayDimensions(attributeTypeId);
            if (arrayDimensions.length != 1) {
                throw new HDF5JavaException("Array needs to be of rank 1, but is of rank " + arrayDimensions.length);
            }
            len = arrayDimensions[0];
            memoryTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT16, len, registry);
        } else {
            arrayDimensions = this.baseReader.h5.getDataDimensionsForAttribute(attributeId, registry);
            memoryTypeId = HDF5Constants.H5T_NATIVE_UINT16;
            len = HDF5Utils.getOneDimensionalArraySize((long[])arrayDimensions);
        }
        short[] data = this.baseReader.h5.readAttributeAsShortArray(attributeId, memoryTypeId, len);
        return data;
    }

    MDShortArray getShortMDArrayAttribute(long objectId, String attributeName, ICleanUpRegistry registry) {
        try {
            long memoryTypeId;
            int[] arrayDimensions;
            long attributeId = this.baseReader.h5.openAttribute(objectId, attributeName, registry);
            long attributeTypeId = this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
            if (this.baseReader.h5.getClassType(attributeTypeId) == HDF5Constants.H5T_ARRAY) {
                arrayDimensions = this.baseReader.h5.getArrayDimensions(attributeTypeId);
                memoryTypeId = this.baseReader.h5.createArrayType(HDF5Constants.H5T_NATIVE_UINT16, arrayDimensions, registry);
            } else {
                arrayDimensions = MDArray.toInt(this.baseReader.h5.getDataDimensionsForAttribute(attributeId, registry));
                memoryTypeId = HDF5Constants.H5T_NATIVE_UINT16;
            }
            int len = MDArray.getLength(arrayDimensions);
            short[] data = this.baseReader.h5.readAttributeAsShortArray(attributeId, memoryTypeId, len);
            return new MDShortArray(data, arrayDimensions);
        }
        catch (IllegalArgumentException ex) {
            throw new HDF5JavaException(ex.getMessage());
        }
    }
}

