/*
 * Decompiled with CFR 0.152.
 */
package loci.common.services;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import loci.common.services.DependencyException;
import loci.common.services.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceFactory.class);
    private static final String DEFAULT_PROPERTIES_FILE = "services.properties";
    private static Map<Class<? extends Service>, Constructor<? extends Service>> constructorCache = new HashMap<Class<? extends Service>, Constructor<? extends Service>>();
    private transient Map<Class<? extends Service>, Class<? extends Service>> services = null;
    private String path;
    private static ServiceFactory defaultFactory;

    public ServiceFactory() throws DependencyException {
        this.path = null;
        if (defaultFactory == null) {
            defaultFactory = new ServiceFactory(DEFAULT_PROPERTIES_FILE);
        }
        this.services();
    }

    public ServiceFactory(String path) throws DependencyException {
        this.path = path;
        this.services();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(String path, Map<Class<? extends Service>, Class<? extends Service>> services) throws DependencyException {
        if (path == null) {
            ServiceFactory serviceFactory = defaultFactory;
            synchronized (serviceFactory) {
                services.putAll(ServiceFactory.defaultFactory.services);
            }
            return;
        }
        InputStream stream = ServiceFactory.class.getResourceAsStream(path);
        Properties properties = new Properties();
        if (stream == null) {
            throw new DependencyException(path + " not found on CLASSPATH");
        }
        try {
            properties.load(stream);
            LOGGER.debug("Loaded properties from: {}", (Object)path);
        }
        catch (Throwable t2) {
            throw new DependencyException(t2);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOGGER.warn("Error closing properties file stream.", e);
            }
        }
        Set<Map.Entry<Object, Object>> entries = properties.entrySet();
        for (Map.Entry<Object, Object> entry : entries) {
            String interfaceName = (String)entry.getKey();
            String implementationName = (String)entry.getValue();
            Class<?> interfaceClass = null;
            Class<?> implementationClass = null;
            ClassLoader loader = ServiceFactory.class.getClassLoader();
            try {
                interfaceClass = Class.forName(interfaceName, false, loader);
            }
            catch (Throwable t3) {
                LOGGER.debug("CLASSPATH missing interface: {}", (Object)interfaceName, (Object)t3);
                continue;
            }
            try {
                implementationClass = Class.forName(implementationName, false, loader);
            }
            catch (Throwable t4) {
                LOGGER.debug("CLASSPATH missing implementation or implementation dependency: {}", (Object)implementationName, (Object)t4);
            }
            services.put(interfaceClass, implementationClass);
            LOGGER.debug("Added interface {} and implementation {}", (Object)interfaceClass, (Object)implementationClass);
        }
    }

    public <T extends Service> T getInstance(Class<T> type) throws DependencyException {
        Class<? extends Service> impl = this.services().get(type);
        if (impl == null && this.services().containsKey(type)) {
            throw new DependencyException("Unable to instantiate service. Missing implementation or implementation dependency", type);
        }
        if (impl == null) {
            throw new DependencyException("Unknown service type: " + type);
        }
        Constructor<? extends Service> constructor = this.getConstructor(impl);
        try {
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (Throwable t2) {
            throw new DependencyException("Unable to instantiate service", type, t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends Service> Constructor<T> getConstructor(Class<T> klass) throws DependencyException {
        Map<Class<? extends Service>, Constructor<? extends Service>> map = constructorCache;
        synchronized (map) {
            Constructor<Service> constructor = constructorCache.get(klass);
            if (constructor == null) {
                try {
                    Class<?> concreteClass = Class.forName(klass.getName());
                    constructor = concreteClass.getDeclaredConstructor(new Class[0]);
                    constructorCache.put(klass, constructor);
                }
                catch (Throwable t2) {
                    throw new DependencyException("Unable to retrieve constructor", klass, t2);
                }
            }
            return constructor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Class<? extends Service>, Class<? extends Service>> services() throws DependencyException {
        Map<Class<? extends Service>, Class<? extends Service>> copy = this.services;
        if (null == copy) {
            ServiceFactory serviceFactory = this;
            synchronized (serviceFactory) {
                copy = this.services;
                if (copy == null) {
                    copy = new HashMap<Class<? extends Service>, Class<? extends Service>>();
                    ServiceFactory.init(this.path, copy);
                    this.services = copy;
                }
            }
        }
        return copy;
    }
}

