/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.hdf5.HDF5CompoundDataMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceFactory;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import loci.formats.services.JHDFService;
import loci.formats.services.JHDFServiceImpl;
import ome.xml.model.primitives.Color;
import ome.xml.model.primitives.NonNegativeInteger;

public class CellH5Reader
extends FormatReader {
    public static final String HDF_MAGIC_STRING = "HDF";
    private transient JHDFService jhdf;
    private MetadataStore store;
    private int lastChannel = 0;
    private List<CellH5Coordinate> CellH5PositionList = new ArrayList<CellH5Coordinate>();
    private List<String> CellH5PathsToImageData = new ArrayList<String>();
    private List<String> cellObjectNames = new ArrayList<String>();
    private final int[][] COLORS = new int[][]{{255, 0, 0}, {0, 255, 0}, {0, 0, 255}, {255, 255, 0}, {0, 255, 255}, {255, 0, 255}, {255, 255, 255}, {255, 0, 128}, {0, 255, 128}, {0, 128, 256}, {128, 0, 128}, {255, 128, 0}, {64, 128, 0}, {0, 64, 128}, {128, 0, 64}};
    private HDF5CompoundDataMap[] classes = null;

    public CellH5Reader() {
        super("CellH5 (HDF)", "ch5");
        this.suffixSufficient = true;
        this.domains = new String[]{"Unknown"};
    }

    @Override
    public int getOptimalTileHeight() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.getSizeY();
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        String[] tokens = name.split("\\.(?=[^\\.]+$)");
        return tokens.length > 1 && tokens[1].equals("ch5");
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 8;
        if (!FormatTools.validStream(stream, 8, false)) {
            return false;
        }
        return stream.readString(8).contains(HDF_MAGIC_STRING);
    }

    @Override
    public byte[][] get8BitLookupTable() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.getPixelType() != 1 || !this.isIndexed()) {
            return null;
        }
        if (this.lastChannel < 0) {
            return null;
        }
        byte[][] lut = new byte[3][256];
        block8: for (int i = 0; i < 256; ++i) {
            switch (this.lastChannel) {
                case 0: {
                    lut[0][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 1: {
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 2: {
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 3: {
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 4: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                case 5: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    continue block8;
                }
                default: {
                    lut[0][i] = (byte)(i & 0xFF);
                    lut[1][i] = (byte)(i & 0xFF);
                    lut[2][i] = (byte)(i & 0xFF);
                }
            }
        }
        return lut;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.lastChannel = this.getZCTCoords(no)[1];
        Object image = this.getImageData(no, y, h2);
        boolean little = this.isLittleEndian();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        for (int row = 0; row < h2; ++row) {
            int i;
            byte[] rowData;
            Object data;
            int base = row * w * bpp;
            if (image instanceof byte[][]) {
                data = (byte[][])image;
                rowData = data[row];
                System.arraycopy(rowData, x, buf, row * w, w);
                continue;
            }
            if (image instanceof short[][]) {
                data = (short[][])image;
                rowData = data[row];
                for (i = 0; i < w; ++i) {
                    DataTools.unpackBytes(rowData[i + x], buf, base + 2 * i, 2, little);
                }
                continue;
            }
            if (image instanceof int[][]) {
                data = (int[][])image;
                rowData = data[row];
                for (i = 0; i < w; ++i) {
                    DataTools.unpackBytes(rowData[i + x], buf, base + i * 4, 4, little);
                }
                continue;
            }
            if (image instanceof float[][]) {
                data = (float[][])image;
                rowData = data[row];
                for (i = 0; i < w; ++i) {
                    int v = Float.floatToIntBits(rowData[i + x]);
                    DataTools.unpackBytes(v, buf, base + i * 4, 4, little);
                }
                continue;
            }
            if (!(image instanceof double[][])) continue;
            data = (double[][])image;
            rowData = data[row];
            for (i = 0; i < w; ++i) {
                long v = Double.doubleToLongBits(rowData[i + x]);
                DataTools.unpackBytes(v, buf, base + i * 8, 8, little);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.CellH5PositionList.clear();
            this.CellH5PathsToImageData.clear();
            this.cellObjectNames.clear();
            if (this.jhdf != null) {
                this.jhdf.close();
            }
            this.jhdf = null;
            this.lastChannel = 0;
            this.store = null;
            this.classes = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.initializeJHDFService(id);
        this.parseStructure();
        if (this.getSeriesCount() <= 2 && this.getMetadataOptions().getMetadataLevel() == MetadataLevel.ALL) {
            this.parseROIs(0);
        }
    }

    @Override
    public void reopenFile() throws IOException {
        try {
            this.initializeJHDFService(this.currentId);
        }
        catch (MissingLibraryException e) {
            throw new IOException(e);
        }
    }

    private void initializeJHDFService(String id) throws IOException, MissingLibraryException {
        try {
            ServiceFactory factory = new ServiceFactory();
            this.jhdf = factory.getInstance(JHDFService.class);
            this.jhdf.setFile(id);
        }
        catch (DependencyException e) {
            throw new MissingLibraryException(JHDFServiceImpl.NO_JHDF_MSG, e);
        }
    }

    private Object getImageData(int no, int y, int height) throws FormatException {
        int[] zct = this.getZCTCoords(no);
        int zslice = zct[0];
        int channel = zct[1];
        int time = zct[2];
        int width = this.getSizeX();
        int elementSize = this.jhdf.getElementSize(this.CellH5PathsToImageData.get(this.series));
        int[] arrayOrigin = new int[]{channel, time, zslice, y, 0};
        int[] arrayDimension = new int[]{1, 1, 1, height, width};
        MDIntArray test = this.jhdf.readIntBlockArray(this.CellH5PathsToImageData.get(this.series), arrayOrigin, arrayDimension);
        if (elementSize == 1) {
            byte[][] image = new byte[height][width];
            for (int yy = 0; yy < height; ++yy) {
                for (int xx = 0; xx < width; ++xx) {
                    image[yy][xx] = (byte)test.get(0, 0, 0, yy, xx);
                }
            }
            return image;
        }
        if (elementSize == 2) {
            short[][] image = new short[height][width];
            for (int yy = 0; yy < height; ++yy) {
                for (int xx = 0; xx < width; ++xx) {
                    image[yy][xx] = (short)test.get(0, 0, 0, yy, xx);
                }
            }
            return image;
        }
        int[][] image = new int[height][width];
        for (int yy = 0; yy < height; ++yy) {
            for (int xx = 0; xx < width; ++xx) {
                image[yy][xx] = test.get(0, 0, 0, yy, xx);
            }
        }
        return image;
    }

    /*
     * WARNING - void declaration
     */
    private void parseStructure() throws FormatException {
        void var6_10;
        int bpp;
        int[] ctzyx;
        this.core.clear();
        String path_to_plate = "/sample/0/plate/";
        LOGGER.info("Plate :" + path_to_plate);
        for (String plate : this.jhdf.getMember(path_to_plate)) {
            String path_to_well = path_to_plate + plate + "/experiment/";
            LOGGER.info("Well :" + path_to_well);
            for (String string : this.jhdf.getMember(path_to_well)) {
                String path_to_site = path_to_well + string + "/position/";
                LOGGER.info("Site :" + path_to_site);
                for (String site : this.jhdf.getMember(path_to_site)) {
                    this.CellH5PositionList.add(new CellH5Coordinate(plate, string, site));
                }
            }
        }
        if (this.CellH5PositionList.size() == 0) {
            throw new FormatException("No series found in file...");
        }
        ArrayList<String> seriesNames = new ArrayList<String>();
        ArrayList<String> seriesPlate = new ArrayList<String>();
        ArrayList<String> seriesWell = new ArrayList<String>();
        ArrayList<String> seriesSite = new ArrayList<String>();
        for (CellH5Coordinate coord : this.CellH5PositionList) {
            String imageData = coord.getPathToImageData();
            if (!this.jhdf.exists(imageData)) continue;
            CoreMetadata m4 = new CoreMetadata();
            this.core.add(m4);
            this.setSeries(this.getSeriesCount() - 1);
            LOGGER.debug(imageData);
            ctzyx = this.jhdf.getShape(imageData);
            m4.sizeC = ctzyx[0];
            m4.sizeT = ctzyx[1];
            m4.sizeZ = ctzyx[2];
            m4.sizeY = ctzyx[3];
            m4.sizeX = ctzyx[4];
            m4.resolutionCount = 1;
            m4.thumbnail = false;
            m4.imageCount = this.getSizeC() * this.getSizeT() * this.getSizeZ();
            m4.dimensionOrder = "XYZTC";
            m4.rgb = false;
            m4.thumbSizeX = 128;
            m4.thumbSizeY = 128;
            m4.orderCertain = false;
            m4.littleEndian = true;
            m4.interleaved = false;
            m4.indexed = true;
            bpp = this.jhdf.getElementSize(imageData);
            if (bpp == 1) {
                m4.pixelType = 1;
            } else if (bpp == 2) {
                m4.pixelType = 3;
            } else if (bpp == 4) {
                m4.pixelType = 4;
            } else {
                throw new FormatException("Pixel type not understood. Only 8, 16 and 32 bit images supported");
            }
            seriesNames.add(String.format("P_%s, W_%s_%s", coord.plate, coord.well, coord.site));
            seriesPlate.add(coord.plate);
            seriesWell.add(coord.well);
            seriesSite.add(coord.site);
            this.CellH5PathsToImageData.add(imageData);
        }
        for (CellH5Coordinate coord : this.CellH5PositionList) {
            String segData = coord.getPathToSegmentationData();
            if (!this.jhdf.exists(segData)) continue;
            CoreMetadata m4 = new CoreMetadata();
            this.core.add(m4);
            this.setSeries(this.getSeriesCount() - 1);
            LOGGER.debug(segData);
            ctzyx = this.jhdf.getShape(segData);
            m4.sizeC = ctzyx[0];
            m4.sizeT = ctzyx[1];
            m4.sizeZ = ctzyx[2];
            m4.sizeY = ctzyx[3];
            m4.sizeX = ctzyx[4];
            m4.resolutionCount = 1;
            m4.thumbnail = false;
            m4.imageCount = this.getSizeC() * this.getSizeT() * this.getSizeZ();
            m4.dimensionOrder = "XYZTC";
            m4.rgb = false;
            m4.thumbSizeX = 128;
            m4.thumbSizeY = 128;
            m4.orderCertain = false;
            m4.littleEndian = true;
            m4.interleaved = false;
            m4.indexed = true;
            bpp = this.jhdf.getElementSize(segData);
            if (bpp == 1) {
                m4.pixelType = 1;
            } else if (bpp == 2) {
                m4.pixelType = 3;
            } else if (bpp == 4) {
                m4.pixelType = 4;
            } else {
                throw new FormatException("Pixel type not understood. Only 8, 16 and 32 bit images supported");
            }
            seriesNames.add(String.format("P_%s, W_%s_%s label image", coord.plate, coord.well, coord.site));
            seriesPlate.add(coord.plate);
            seriesWell.add(coord.well);
            seriesSite.add(coord.site);
            this.CellH5PathsToImageData.add(segData);
        }
        if (this.getSeriesCount() == 0) {
            throw new FormatException("No image data found...");
        }
        this.store = this.makeFilterMetadata();
        MetadataTools.populatePixels(this.store, this);
        boolean bl = false;
        while (var6_10 < seriesNames.size()) {
            String image_id = MetadataTools.createLSID("Image", new int[]{var6_10});
            this.store.setImageName((String)seriesNames.get((int)var6_10), (int)var6_10);
            String plate_id = MetadataTools.createLSID("Plate", 0);
            this.store.setPlateID(plate_id, 0);
            this.store.setPlateName((String)seriesPlate.get((int)var6_10), 0);
            String well_id = MetadataTools.createLSID("Well", 0);
            this.store.setWellID(well_id, 0, 0);
            String cellh5WellCoord = (String)seriesWell.get((int)var6_10);
            String wellRowLetter = cellh5WellCoord.substring(0, 1);
            String wellColNumber = cellh5WellCoord.substring(1);
            int wellRowLetterIndex = "ABCDEFGHIJKLMNOP".indexOf(wellRowLetter);
            int wellColNumberIndex = -1;
            try {
                wellColNumberIndex = Integer.parseInt(wellColNumber);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (wellRowLetterIndex > -1 && wellColNumberIndex > 0) {
                this.store.setWellRow(new NonNegativeInteger(wellRowLetterIndex), 0, 0);
                this.store.setWellColumn(new NonNegativeInteger(wellColNumberIndex - 1), 0, 0);
            } else {
                this.store.setWellRow(new NonNegativeInteger(0), 0, 0);
                this.store.setWellColumn(new NonNegativeInteger(0), 0, 0);
            }
            this.store.setWellExternalIdentifier(cellh5WellCoord, 0, 0);
            String site_id = MetadataTools.createLSID("WellSample", 0);
            this.store.setWellSampleID(site_id, 0, 0, 0);
            this.store.setWellSampleIndex(NonNegativeInteger.valueOf((String)seriesSite.get((int)var6_10)), 0, 0, 0);
            this.store.setWellSampleImageRef(image_id, 0, 0, 0);
            ++var6_10;
        }
        this.setSeries(0);
        this.parseCellObjects();
    }

    private void parseCellObjects() {
        String rootObject = "/definition/object/";
        List<String> allObjects = this.jhdf.getMember(rootObject);
        for (String objectName : allObjects) {
            String objectType = (String)this.jhdf.readCompoundArrayDataMap(rootObject + objectName)[0].get("type");
            if (!objectType.equals("region")) continue;
            this.cellObjectNames.add(objectName);
            LOGGER.debug("CellH5Reader: Found cell object {}", (Object)objectName);
        }
    }

    private int getChannelIndexOfCellObjectName(String cellObjectName) {
        HDF5CompoundDataMap[] allImageRegions = this.jhdf.readCompoundArrayDataMap("/definition/image/region/");
        for (int regionIdx = 0; regionIdx < allImageRegions.length; ++regionIdx) {
            String regionName = (String)allImageRegions[regionIdx].get("region_name");
            Integer channelIdx = (Integer)allImageRegions[regionIdx].get("channel_idx");
            if (!regionName.endsWith(cellObjectName)) continue;
            return channelIdx;
        }
        return -1;
    }

    private static Color hex2Rgb(String colorStr) {
        int red = Integer.parseInt(colorStr.substring(1, 3), 16);
        int green = Integer.parseInt(colorStr.substring(3, 5), 16);
        int blue = Integer.parseInt(colorStr.substring(5, 7), 16);
        return new Color(red, green, blue, 255);
    }

    private void parseROIs(int s2) {
        int objectIdx = 0;
        ArrayList<Color> classColors = new ArrayList<Color>();
        int roiIndexOffset = 0;
        CellH5Coordinate coord = this.CellH5PositionList.get(0);
        for (String cellObjectName : this.cellObjectNames) {
            LOGGER.info("Parse segmentation ROIs for cell object {} : {}", (Object)cellObjectName, (Object)objectIdx);
            String featureName = "feature/" + cellObjectName + "/";
            String pathToBoundingBox = coord.pathToPosition + featureName + "bounding_box/";
            String pathToClassDefinition = "/definition/" + featureName + "object_classification/class_labels/";
            boolean hasClassification = false;
            if (this.jhdf.exists(pathToClassDefinition)) {
                HDF5CompoundDataMap[] classDef = this.jhdf.readCompoundArrayDataMap(pathToClassDefinition);
                for (int cls = 0; cls < classDef.length; ++cls) {
                    String classColorHexString = (String)classDef[cls].get("color");
                    classColors.add(CellH5Reader.hex2Rgb(classColorHexString));
                }
                if (classDef.length > 0) {
                    hasClassification = true;
                    this.classes = this.jhdf.readCompoundArrayDataMap(coord.pathToPosition + featureName + "object_classification/prediction");
                }
            }
            if (this.jhdf.exists(pathToBoundingBox)) {
                HDF5CompoundDataMap[] bbox = this.jhdf.readCompoundArrayDataMap(pathToBoundingBox);
                HDF5CompoundDataMap[] times = this.jhdf.readCompoundArrayDataMap(coord.pathToPosition + "object/" + cellObjectName);
                int roiChannel = this.getChannelIndexOfCellObjectName(cellObjectName);
                int roiZSlice = 0;
                for (int roiIndex = 0; roiIndex < bbox.length; ++roiIndex) {
                    Color strokeColor;
                    int roiManagerRoiIndex = roiIndex + roiIndexOffset;
                    int roiTime = (Integer)times[roiIndex].get("time_idx");
                    int objectLabelId = (Integer)times[roiIndex].get("obj_label_id");
                    int left = (Integer)bbox[roiIndex].get("left");
                    int right = (Integer)bbox[roiIndex].get("right");
                    int top = (Integer)bbox[roiIndex].get("top");
                    int bottom = (Integer)bbox[roiIndex].get("bottom");
                    int width = right - left;
                    int height = bottom - top;
                    String roiID = MetadataTools.createLSID("ROI", roiManagerRoiIndex);
                    this.store.setROIID(roiID, roiManagerRoiIndex);
                    this.store.setImageROIRef(roiID, s2, roiManagerRoiIndex);
                    this.store.setROIName(cellObjectName + " " + objectLabelId, roiManagerRoiIndex);
                    String shapeID = MetadataTools.createLSID("Shape", roiManagerRoiIndex, 0);
                    this.store.setRectangleID(shapeID, roiManagerRoiIndex, 0);
                    this.store.setRectangleX(Double.valueOf(left), roiManagerRoiIndex, 0);
                    this.store.setRectangleY(Double.valueOf(top), roiManagerRoiIndex, 0);
                    this.store.setRectangleWidth(Double.valueOf(width), roiManagerRoiIndex, 0);
                    this.store.setRectangleHeight(Double.valueOf(height), roiManagerRoiIndex, 0);
                    this.store.setRectangleText(cellObjectName, roiManagerRoiIndex, 0);
                    this.store.setRectangleTheT(new NonNegativeInteger(roiTime), roiManagerRoiIndex, 0);
                    this.store.setRectangleTheC(new NonNegativeInteger(roiChannel), roiManagerRoiIndex, 0);
                    this.store.setRectangleTheZ(new NonNegativeInteger(roiZSlice), roiManagerRoiIndex, 0);
                    if (hasClassification) {
                        int classLabelIDx = (Integer)this.classes[roiIndex].get("label_idx");
                        strokeColor = (Color)classColors.get(classLabelIDx);
                    } else {
                        strokeColor = new Color(this.COLORS[objectIdx][0], this.COLORS[objectIdx][1], this.COLORS[objectIdx][2], 255);
                    }
                    this.store.setRectangleStrokeColor(strokeColor, roiManagerRoiIndex, 0);
                }
                ++objectIdx;
                roiIndexOffset += bbox.length;
                continue;
            }
            LOGGER.info("No Segmentation data found...");
            break;
        }
    }

    public class CellH5Constants {
        public static final String PREFIX_PATH = "/sample/0/";
        public static final String IMAGE_PATH = "image/channel/";
        public static final String SEGMENTATION_PATH = "image/region/";
        public static final String PLATE = "plate/";
        public static final String WELL = "/experiment/";
        public static final String SITE = "/position/";
        public static final String DEFINITION = "/definition/";
        public static final String OBJECT = "object/";
        public static final String FEATURE = "feature/";
        public static final String IMAGE = "image/";
        public static final String BBOX = "bounding_box/";
        public static final String CLASS_LABELS = "object_classification/class_labels/";
        public static final String PREDICTED_CLASS_LABELS = "object_classification/prediction";
    }

    public class CellH5Coordinate {
        public String plate;
        public String well;
        public String site;
        protected String pathToPosition;

        CellH5Coordinate(String plate, String well, String site) {
            this.plate = plate;
            this.well = well;
            this.site = site;
            this.pathToPosition = "/sample/0/plate/" + this.plate + "/experiment/" + this.well + "/position/" + this.site + "/";
            LOGGER.trace(this.getPathToImageData());
        }

        public String toString() {
            return String.format("%s %s_%s", this.plate, this.well, this.site);
        }

        public String getPathToImageData() {
            return this.pathToPosition + "image/channel/";
        }

        public String getPathToSegmentationData() {
            return this.pathToPosition + "image/region/";
        }
    }
}

