/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.zip.ZipInputStream;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.SDTInfo;
import loci.formats.meta.MetadataStore;

public class SDTReader
extends FormatReader {
    protected SDTInfo info;
    protected int timeBins;
    protected int channels;
    protected boolean intensity = false;
    protected boolean preLoad = true;
    protected int storedChannel = -1;
    protected int storedSeries = -1;
    protected byte[] dataStore = null;
    protected int currentBlock;
    protected int blockLength;

    public SDTReader() {
        super("SPCImage Data", "sdt");
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
    }

    public void setIntensity(boolean intensity) {
        FormatTools.assertId(this.currentId, false, 1);
        this.intensity = intensity;
    }

    public void setPreLoad(boolean preLoad) {
        this.preLoad = preLoad;
    }

    public boolean isIntensity() {
        return this.intensity;
    }

    public int getTimeBinCount() {
        return this.timeBins;
    }

    public int getChannelCount() {
        return this.channels;
    }

    public SDTInfo getInfo() {
        return this.info;
    }

    @Override
    public boolean isInterleaved(int subC) {
        FormatTools.assertId(this.currentId, true, 1);
        return !this.intensity && subC == 0;
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        int row;
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        int sizeX = this.getSizeX();
        int sizeY = this.getSizeY();
        int bpp = FormatTools.getBytesPerPixel(this.getPixelType());
        boolean little = this.isLittleEndian();
        long blockSize = this.info.allBlockLengths[this.getSeries()];
        int paddedWidth = sizeX + (4 - sizeX % 4) % 4;
        int times = this.timeBins;
        if (this.info.mcstaPoints == this.getSizeT()) {
            times = this.getSizeT();
        }
        long planeSize = (long)paddedWidth * (long)sizeY * (long)times * (long)bpp;
        if (paddedWidth > sizeX && planeSize * (long)this.getSizeC() > blockSize && planeSize / (long)paddedWidth * (long)sizeX * (long)this.getSizeC() <= blockSize) {
            paddedWidth = sizeX;
            planeSize = sizeX * sizeY * times * bpp;
        }
        if (this.preLoad && !this.intensity) {
            int channel = no / times;
            int timeBin = no % times;
            byte[] rowBuf = new byte[bpp * times * paddedWidth];
            int binSize = paddedWidth * sizeY * bpp;
            int preBlockSize = binSize * this.blockLength;
            if (this.dataStore == null || this.storedSeries != this.getSeries()) {
                this.dataStore = new byte[preBlockSize];
                this.currentBlock = -1;
            }
            if (timeBin / this.blockLength != this.currentBlock || this.storedChannel != channel) {
                this.currentBlock = timeBin / this.blockLength;
                this.in.seek(this.info.allBlockOffsets[this.getSeries()]);
                ZipInputStream codec = null;
                String check = this.in.readString(2);
                this.in.seek(this.in.getFilePointer() - 2L);
                if (check.equals("PK")) {
                    codec = new ZipInputStream(this.in);
                    codec.getNextEntry();
                    codec.skip((long)channel * planeSize);
                } else {
                    this.in.skipBytes((long)channel * planeSize);
                }
                int endOfBlock = (this.currentBlock + 1) * this.blockLength;
                int storeLength = endOfBlock > times ? times - this.currentBlock * this.blockLength : this.blockLength;
                for (int row2 = 0; row2 < sizeY; ++row2) {
                    this.readPixels(rowBuf, this.in, codec, 0L);
                    for (int col = 0; col < paddedWidth; ++col) {
                        int output = (row2 * paddedWidth + col) * bpp;
                        int input = (col * times + this.currentBlock * this.blockLength) * bpp;
                        for (int t2 = 0; t2 < storeLength; ++t2) {
                            for (int bb = 0; bb < bpp; ++bb) {
                                this.dataStore[output + bb] = rowBuf[input + bb];
                            }
                            output += binSize;
                            input += bpp;
                        }
                    }
                }
            }
            this.storedChannel = channel;
            this.storedSeries = this.getSeries();
            int iLineSize = paddedWidth * bpp;
            int oLineSize = w * bpp;
            int binInStore = timeBin - this.currentBlock * this.blockLength;
            int input = binSize * binInStore + y * iLineSize + x * bpp;
            int output = 0;
            for (int row3 = 0; row3 < h2; ++row3) {
                System.arraycopy(this.dataStore, input, buf, output, oLineSize);
                input += iLineSize;
                output += oLineSize;
            }
            if (this.info.incr > 1) {
                short incr = this.info.incr;
                ByteBuffer bb = ByteBuffer.wrap(buf);
                bb.order(ByteOrder.LITTLE_ENDIAN);
                for (int i = 0; i < buf.length; i += 2) {
                    short s2 = bb.getShort(i);
                    if (s2 > 0) {
                        bb.putShort(i, (short)(s2 / incr));
                        continue;
                    }
                    int ii = s2 & 0xFFFF;
                    bb.putShort(i, (short)(ii / incr));
                }
            }
            return buf;
        }
        int channel = this.intensity ? no : no / times;
        int timeBin = this.intensity ? 0 : no % times;
        byte[] b = !this.intensity ? buf : new byte[sizeY * sizeX * times * bpp];
        byte[] rowBuf = new byte[bpp * times * w];
        this.in.seek(this.info.allBlockOffsets[this.getSeries()]);
        ZipInputStream codec = null;
        String check = this.in.readString(2);
        this.in.seek(this.in.getFilePointer() - 2L);
        if (check.equals("PK")) {
            codec = new ZipInputStream(this.in);
            codec.getNextEntry();
            codec.skip((long)channel * planeSize + (long)(y * paddedWidth * bpp * times));
        } else {
            this.in.skipBytes((long)channel * planeSize + (long)y * (long)paddedWidth * (long)bpp * (long)times);
        }
        for (row = 0; row < h2; ++row) {
            this.readPixels(rowBuf, this.in, codec, (long)x * (long)bpp * (long)times);
            if (this.intensity) {
                System.arraycopy(rowBuf, 0, b, row * bpp * times * w, b.length);
            } else {
                for (int col = 0; col < w; ++col) {
                    int output = (row * w + col) * bpp;
                    int input = (col * times + timeBin) * bpp;
                    for (int bb = 0; bb < bpp; ++bb) {
                        b[output + bb] = rowBuf[input + bb];
                    }
                }
            }
            if (codec == null) {
                this.in.skipBytes((long)bpp * (long)times * (long)(paddedWidth - x - w));
                continue;
            }
            codec.skip(bpp * times * (paddedWidth - x - w));
        }
        if (!this.intensity) {
            return buf;
        }
        for (row = 0; row < h2; ++row) {
            int yi = (y + row) * sizeX * times * bpp;
            int ri = row * w * bpp;
            for (int col = 0; col < w; ++col) {
                int xi = yi + (x + col) * times * bpp;
                int ci = ri + col * bpp;
                int sum = 0;
                for (int t3 = 0; t3 < times; ++t3) {
                    sum = (short)(sum + DataTools.bytesToShort(b, xi + t3 * bpp, little));
                }
                DataTools.unpackBytes(sum, buf, ci, 2, little);
            }
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.preLoad = true;
            this.dataStore = null;
            this.storedChannel = -1;
            this.storedSeries = -1;
            this.channels = 0;
            this.timeBins = 0;
            this.currentBlock = -1;
            this.info = null;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        LOGGER.info("Reading header");
        this.info = new SDTInfo(this.in, this.metadata);
        this.timeBins = this.info.timeBins;
        this.channels = this.info.channels;
        this.addGlobalMeta("time bins", this.timeBins);
        this.addGlobalMeta("channels", this.channels);
        double timeBase = 1.0E9 * (double)this.info.tacR / (double)this.info.tacG;
        this.addGlobalMeta("time base", timeBase);
        LOGGER.info("Populating metadata");
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        int timepoints = this.info.timepoints;
        if (timepoints == 0) {
            timepoints = 1;
        }
        m4.sizeX = this.info.width;
        m4.sizeY = this.info.height;
        m4.sizeZ = 1;
        m4.sizeT = this.intensity ? timepoints : this.timeBins * timepoints;
        m4.sizeC = this.channels;
        m4.dimensionOrder = "XYZTC";
        m4.pixelType = 3;
        m4.rgb = false;
        m4.littleEndian = true;
        m4.imageCount = m4.sizeZ * m4.sizeC * m4.sizeT;
        m4.indexed = false;
        m4.falseColor = false;
        m4.metadataComplete = true;
        if (this.intensity) {
            m4.moduloT.parentType = "Spectra";
        } else {
            m4.moduloT.type = "Lifetime";
            m4.moduloT.parentType = "Spectra";
            m4.moduloT.typeDescription = "TCSPC";
            m4.moduloT.start = 0.0;
            m4.moduloT.step = (timeBase *= 1000.0) / (double)this.timeBins;
            m4.moduloT.end = m4.moduloT.step * (double)(m4.sizeT - 1);
            m4.moduloT.unit = "ps";
        }
        for (int i = 1; i < this.info.allBlockOffsets.length; ++i) {
            CoreMetadata p = new CoreMetadata(m4);
            this.core.add(p);
            int planeSize = m4.sizeX * m4.sizeY * FormatTools.getBytesPerPixel(m4.pixelType);
            if (this.info.allBlockLengths[i] == (long)(planeSize * m4.imageCount) || (long)(this.info.mcstaPoints * planeSize) != this.info.allBlockLengths[i]) continue;
            p.sizeT = this.info.mcstaPoints;
            p.moduloT.end = p.moduloT.step * (double)(p.sizeT - 1);
            p.imageCount = p.sizeZ * p.sizeC * p.sizeT;
        }
        int sizeThreshold = 0x8000000;
        this.blockLength = 2048;
        while (this.blockLength * m4.sizeX * m4.sizeY > sizeThreshold) {
            this.blockLength /= 2;
        }
        if (this.blockLength > this.timeBins) {
            this.blockLength = this.timeBins;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }

    private void readPixels(byte[] rowBuf, RandomAccessInputStream in, ZipInputStream codec, long skip) throws IOException {
        if (codec == null) {
            in.skipBytes(skip);
            in.read(rowBuf);
        } else {
            int n;
            codec.skip(skip);
            for (int nread = 0; nread < rowBuf.length; nread += n) {
                n = codec.read(rowBuf, nread, rowBuf.length - nread);
                if (n > 0) continue;
                break;
            }
        }
    }
}

