/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.JPEG2000CodecOptions;
import ome.codecs.MissingLibraryException;
import ome.codecs.gui.AWTImageTools;
import ome.codecs.gui.UnsignedIntBuffer;
import ome.codecs.services.JAIIIOService;

public class JPEG2000Codec
extends BaseCodec {
    private JAIIIOService service;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        byte[] byArray;
        int q;
        Object s2;
        DataBuffer buffer;
        int c;
        if (data == null || data.length == 0) {
            return data;
        }
        this.initialize();
        JPEG2000CodecOptions j2kOptions = options instanceof JPEG2000CodecOptions ? (JPEG2000CodecOptions)options : JPEG2000CodecOptions.getDefaultOptions(options);
        ByteArrayHandle handle = new ByteArrayHandle();
        RandomAccessOutputStream out = new RandomAccessOutputStream(handle);
        BufferedImage img = null;
        int next = 0;
        int plane = j2kOptions.width * j2kOptions.height;
        if (j2kOptions.bitsPerSample == 8) {
            byte[][] b = new byte[j2kOptions.channels][plane];
            if (j2kOptions.interleaved) {
                for (int q2 = 0; q2 < plane; ++q2) {
                    for (c = 0; c < j2kOptions.channels && next < data.length; ++c) {
                        b[c][q2] = data[next++];
                    }
                }
            } else {
                for (int c2 = 0; c2 < j2kOptions.channels; ++c2) {
                    System.arraycopy(data, c2 * plane, b[c2], 0, plane);
                }
            }
            buffer = new DataBufferByte(b, plane);
            img = AWTImageTools.constructImage(b.length, 0, j2kOptions.width, j2kOptions.height, false, true, buffer, j2kOptions.colorModel);
        } else if (j2kOptions.bitsPerSample == 16) {
            s2 = new short[j2kOptions.channels][plane];
            if (j2kOptions.interleaved) {
                for (int q3 = 0; q3 < plane; ++q3) {
                    for (c = 0; c < j2kOptions.channels; ++c) {
                        s2[c][q3] = DataTools.bytesToShort(data, next, 2, j2kOptions.littleEndian);
                        next += 2;
                    }
                }
            } else {
                for (int c3 = 0; c3 < j2kOptions.channels; ++c3) {
                    for (q = 0; q < plane; ++q) {
                        s2[c3][q] = DataTools.bytesToShort(data, next, 2, j2kOptions.littleEndian);
                        next += 2;
                    }
                }
            }
            buffer = new DataBufferUShort((short[][])s2, plane);
            img = AWTImageTools.constructImage(((short[][])s2).length, 1, j2kOptions.width, j2kOptions.height, false, true, buffer, j2kOptions.colorModel);
        } else if (j2kOptions.bitsPerSample == 32) {
            s2 = new int[j2kOptions.channels][plane];
            if (j2kOptions.interleaved) {
                for (int q4 = 0; q4 < plane; ++q4) {
                    for (c = 0; c < j2kOptions.channels; ++c) {
                        s2[c][q4] = DataTools.bytesToInt(data, next, 4, j2kOptions.littleEndian);
                        next += 4;
                    }
                }
            } else {
                for (int c4 = 0; c4 < j2kOptions.channels; ++c4) {
                    for (q = 0; q < plane; ++q) {
                        s2[c4][q] = DataTools.bytesToInt(data, next, 4, j2kOptions.littleEndian);
                        next += 4;
                    }
                }
            }
            buffer = new UnsignedIntBuffer((int[][])s2, plane);
            img = AWTImageTools.constructImage(((short[][])s2).length, 3, j2kOptions.width, j2kOptions.height, false, true, buffer, j2kOptions.colorModel);
        }
        try {
            this.service.writeImage(out, img, j2kOptions);
        }
        catch (IOException e) {
            throw new CodecException("Could not compress JPEG-2000 data.", e);
        }
        catch (ServiceException e) {
            throw new CodecException("Could not compress JPEG-2000 data.", e);
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                throw new CodecException("Failed to close RandomAccessOutputStream.", e);
            }
        }
        RandomAccessInputStream is = new RandomAccessInputStream(handle);
        try {
            is.seek(0L);
            if (!j2kOptions.writeBox) {
                while (is.getFilePointer() < is.length()) {
                    while ((is.readShort() & 0xFFFF) != 65359) {
                        is.seek(is.getFilePointer() - 1L);
                    }
                    if ((is.readShort() & 0xFFFF) == 65361) break;
                    is.seek(is.getFilePointer() - 2L);
                }
                is.seek(is.getFilePointer() - 4L);
            }
            byte[] buf = new byte[(int)(is.length() - is.getFilePointer())];
            is.readFully(buf);
            byArray = buf;
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (IOException iOException) {
                return null;
            }
        }
        is.close();
        return byArray;
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        if (options == null || !(options instanceof JPEG2000CodecOptions)) {
            options = JPEG2000CodecOptions.getDefaultOptions(options);
        }
        byte[] buf = null;
        long fp = in.getFilePointer();
        buf = options.maxBytes == 0 ? new byte[(int)(in.length() - fp)] : new byte[(int)((long)options.maxBytes - fp)];
        in.read(buf);
        return this.decompress(buf, options);
    }

    @Override
    public byte[] decompress(byte[] buf, CodecOptions options) throws CodecException {
        this.initialize();
        options = options == null || !(options instanceof JPEG2000CodecOptions) ? JPEG2000CodecOptions.getDefaultOptions(options) : new JPEG2000CodecOptions(options);
        byte[][] single = null;
        WritableRaster b = null;
        int bpp = options.bitsPerSample / 8;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(buf);
            b = (WritableRaster)this.service.readRaster(bis, (JPEG2000CodecOptions)options);
            single = AWTImageTools.getPixelBytes(b, options.littleEndian);
            bpp = single[0].length / (b.getWidth() * b.getHeight());
            bis.close();
            b = null;
        }
        catch (IOException e) {
            throw new CodecException("Could not decompress JPEG2000 image. Please make sure that jai_imageio.jar is installed.", e);
        }
        catch (ServiceException e) {
            throw new CodecException("Could not decompress JPEG2000 image. Please make sure that jai_imageio.jar is installed.", e);
        }
        if (single.length == 1) {
            return single[0];
        }
        byte[] rtn = new byte[single.length * single[0].length];
        if (options.interleaved) {
            int next = 0;
            for (int i = 0; i < single[0].length / bpp; ++i) {
                for (int j = 0; j < single.length; ++j) {
                    for (int bb = 0; bb < bpp; ++bb) {
                        rtn[next++] = single[j][i * bpp + bb];
                    }
                }
            }
        } else {
            for (int i = 0; i < single.length; ++i) {
                System.arraycopy(single[i], 0, rtn, i * single[0].length, single[i].length);
            }
        }
        single = null;
        return rtn;
    }

    private void initialize() throws CodecException {
        if (this.service != null) {
            return;
        }
        try {
            ServiceFactory factory = new ServiceFactory();
            this.service = factory.getInstance(JAIIIOService.class);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException("The JAI Image I/O Tools are required to read JPEG-2000 files. Please obtain jai_imageio.jar from http://www.openmicroscopy.org/site/support/bio-formats/developers/java-library.html", de);
        }
    }
}

