/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.fraction;

import java.math.BigInteger;
import org.apache.commons.math.fraction.FractionConversionException;
import org.apache.commons.math.util.MathUtils;

public class Fraction
extends Number
implements Comparable {
    public static final Fraction ONE = new Fraction(1, 1);
    public static final Fraction ZERO = new Fraction(0, 1);
    private static final long serialVersionUID = -8958519416450949235L;
    private final int denominator;
    private final int numerator;

    public Fraction(double value) throws FractionConversionException {
        this(value, 1.0E-5, 100);
    }

    public Fraction(double value, double epsilon, int maxIterations) throws FractionConversionException {
        this(value, epsilon, Integer.MAX_VALUE, maxIterations);
    }

    public Fraction(double value, int maxDenominator) throws FractionConversionException {
        this(value, 0.0, maxDenominator, 100);
    }

    private Fraction(double value, double epsilon, int maxDenominator, int maxIterations) throws FractionConversionException {
        long overflow = Integer.MAX_VALUE;
        double r0 = value;
        long a0 = (long)Math.floor(r0);
        if (a0 > overflow) {
            throw new FractionConversionException(value, a0, 1L);
        }
        if (Math.abs((double)a0 - value) < epsilon) {
            this.numerator = (int)a0;
            this.denominator = 1;
            return;
        }
        long p0 = 1L;
        long q0 = 0L;
        long p1 = a0;
        long q1 = 1L;
        long p2 = 0L;
        long q2 = 1L;
        int n = 0;
        boolean stop = false;
        do {
            ++n;
            double r1 = 1.0 / (r0 - (double)a0);
            long a1 = (long)Math.floor(r1);
            p2 = a1 * p1 + p0;
            q2 = a1 * q1 + q0;
            if (p2 > overflow || q2 > overflow) {
                throw new FractionConversionException(value, p2, q2);
            }
            double convergent = (double)p2 / (double)q2;
            if (n < maxIterations && Math.abs(convergent - value) > epsilon && q2 < (long)maxDenominator) {
                p0 = p1;
                p1 = p2;
                q0 = q1;
                q1 = q2;
                a0 = a1;
                r0 = r1;
                continue;
            }
            stop = true;
        } while (!stop);
        if (n >= maxIterations) {
            throw new FractionConversionException(value, maxIterations);
        }
        if (q2 < (long)maxDenominator) {
            this.numerator = (int)p2;
            this.denominator = (int)q2;
        } else {
            this.numerator = (int)p1;
            this.denominator = (int)q1;
        }
    }

    public Fraction(int num, int den) {
        int d;
        if (den == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (den < 0) {
            if (num == Integer.MIN_VALUE || den == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            num = -num;
            den = -den;
        }
        if ((d = MathUtils.gcd(num, den)) > 1) {
            num /= d;
            den /= d;
        }
        if (den < 0) {
            num *= -1;
            den *= -1;
        }
        this.numerator = num;
        this.denominator = den;
    }

    public Fraction abs() {
        Fraction ret = this.numerator >= 0 ? this : this.negate();
        return ret;
    }

    public int compareTo(Object object) {
        int ret = 0;
        if (this != object) {
            double second;
            Fraction other = (Fraction)object;
            double first = this.doubleValue();
            if (first < (second = other.doubleValue())) {
                ret = -1;
            } else if (first > second) {
                ret = 1;
            }
        }
        return ret;
    }

    public double doubleValue() {
        return (double)this.numerator / (double)this.denominator;
    }

    public boolean equals(Object other) {
        boolean ret;
        if (this == other) {
            ret = true;
        } else if (other == null) {
            ret = false;
        } else {
            try {
                Fraction rhs = (Fraction)other;
                ret = this.numerator == rhs.numerator && this.denominator == rhs.denominator;
            }
            catch (ClassCastException ex) {
                ret = false;
            }
        }
        return ret;
    }

    public float floatValue() {
        return (float)this.doubleValue();
    }

    public int getDenominator() {
        return this.denominator;
    }

    public int getNumerator() {
        return this.numerator;
    }

    public int hashCode() {
        return 37 * (629 + this.getNumerator()) + this.getDenominator();
    }

    public int intValue() {
        return (int)this.doubleValue();
    }

    public long longValue() {
        return (long)this.doubleValue();
    }

    public Fraction negate() {
        if (this.numerator == Integer.MIN_VALUE) {
            throw new ArithmeticException("overflow: too large to negate");
        }
        return new Fraction(-this.numerator, this.denominator);
    }

    public Fraction reciprocal() {
        return new Fraction(this.denominator, this.numerator);
    }

    public Fraction add(Fraction fraction) {
        return this.addSub(fraction, true);
    }

    public Fraction subtract(Fraction fraction) {
        return this.addSub(fraction, false);
    }

    private Fraction addSub(Fraction fraction, boolean isAdd) {
        int tmodd1;
        int d2;
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0) {
            return isAdd ? fraction : fraction.negate();
        }
        if (fraction.numerator == 0) {
            return this;
        }
        int d1 = MathUtils.gcd(this.denominator, fraction.denominator);
        if (d1 == 1) {
            int uvp = MathUtils.mulAndCheck(this.numerator, fraction.denominator);
            int upv = MathUtils.mulAndCheck(fraction.numerator, this.denominator);
            return new Fraction(isAdd ? MathUtils.addAndCheck(uvp, upv) : MathUtils.subAndCheck(uvp, upv), MathUtils.mulAndCheck(this.denominator, fraction.denominator));
        }
        BigInteger uvp = BigInteger.valueOf(this.numerator).multiply(BigInteger.valueOf(fraction.denominator / d1));
        BigInteger upv = BigInteger.valueOf(fraction.numerator).multiply(BigInteger.valueOf(this.denominator / d1));
        BigInteger t2 = isAdd ? uvp.add(upv) : uvp.subtract(upv);
        BigInteger w = t2.divide(BigInteger.valueOf(d2 = (tmodd1 = t2.mod(BigInteger.valueOf(d1)).intValue()) == 0 ? d1 : MathUtils.gcd(tmodd1, d1)));
        if (w.bitLength() > 31) {
            throw new ArithmeticException("overflow: numerator too large after multiply");
        }
        return new Fraction(w.intValue(), MathUtils.mulAndCheck(this.denominator / d1, fraction.denominator / d2));
    }

    public Fraction multiply(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (this.numerator == 0 || fraction.numerator == 0) {
            return ZERO;
        }
        int d1 = MathUtils.gcd(this.numerator, fraction.denominator);
        int d2 = MathUtils.gcd(fraction.numerator, this.denominator);
        return Fraction.getReducedFraction(MathUtils.mulAndCheck(this.numerator / d1, fraction.numerator / d2), MathUtils.mulAndCheck(this.denominator / d2, fraction.denominator / d1));
    }

    public Fraction divide(Fraction fraction) {
        if (fraction == null) {
            throw new IllegalArgumentException("The fraction must not be null");
        }
        if (fraction.numerator == 0) {
            throw new ArithmeticException("The fraction to divide by must not be zero");
        }
        return this.multiply(fraction.reciprocal());
    }

    public static Fraction getReducedFraction(int numerator, int denominator) {
        if (denominator == 0) {
            throw new ArithmeticException("The denominator must not be zero");
        }
        if (numerator == 0) {
            return ZERO;
        }
        if (denominator == Integer.MIN_VALUE && (numerator & 1) == 0) {
            numerator /= 2;
            denominator /= 2;
        }
        if (denominator < 0) {
            if (numerator == Integer.MIN_VALUE || denominator == Integer.MIN_VALUE) {
                throw new ArithmeticException("overflow: can't negate");
            }
            numerator = -numerator;
            denominator = -denominator;
        }
        int gcd = MathUtils.gcd(numerator, denominator);
        return new Fraction(numerator /= gcd, denominator /= gcd);
    }
}

