/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.tools;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import javax.annotation.Nonnull;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Property;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.builder.CatalogBuilder;
import ucar.nc2.Attribute;
import ucar.nc2.constants.DataFormatType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.remote.CdmrFeatureDataset;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.Optional;
import ucar.unidata.util.StringUtil2;

public class DataFactory {
    public static final String PROTOCOL = "thredds";
    public static final String SCHEME = "thredds:";
    private static ServiceType[] preferAccess;
    private static boolean debugOpen;
    private static boolean debugTypeOpen;

    public static void setPreferCdm(boolean prefer) {
        ServiceType[] serviceTypeArray;
        if (prefer) {
            ServiceType[] serviceTypeArray2 = new ServiceType[1];
            serviceTypeArray = serviceTypeArray2;
            serviceTypeArray2[0] = ServiceType.CdmRemote;
        } else {
            serviceTypeArray = null;
        }
        preferAccess = serviceTypeArray;
    }

    public static void setPreferAccess(ServiceType ... prefer) {
        preferAccess = prefer;
    }

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugOpen = debugFlag.isSet("thredds/debugOpen");
        debugTypeOpen = debugFlag.isSet("thredds/openDatatype");
    }

    public Result openFeatureDataset(String urlString, CancelTask task) throws IOException {
        Result result = new Result();
        Dataset dataset = this.openCatalogFromLocation(urlString, task, result);
        if (result.fatalError || dataset == null) {
            return result;
        }
        return this.openFeatureDataset(null, dataset, task, result);
    }

    public Result openFeatureDataset(FeatureType wantFeatureType, String urlString, CancelTask task) throws IOException {
        Result result = new Result();
        Dataset ds = this.openCatalogFromLocation(urlString, task, result);
        if (result.fatalError || ds == null) {
            return result;
        }
        return this.openFeatureDataset(wantFeatureType, ds, task, result);
    }

    private Dataset openCatalogFromLocation(String location, CancelTask task, Result result) {
        int pos;
        location = location.trim();
        if ((location = StringUtil2.replace(location, '\\', "/")).startsWith(SCHEME)) {
            location = location.substring(8);
        }
        if (location.startsWith("resolve:")) {
            location = location.substring(8);
            return this.openResolver(location, task, result);
        }
        if (!location.startsWith("http:") && !location.startsWith("file:")) {
            location = "http:" + location;
        }
        if ((pos = location.indexOf(35)) < 0) {
            result.fatalError = true;
            result.errLog.format("Must have the form catalog.xml#datasetId%n", new Object[0]);
            return null;
        }
        CatalogBuilder catFactory = new CatalogBuilder();
        String catalogLocation = location.substring(0, pos);
        Catalog catalog = catFactory.buildFromLocation(catalogLocation, null);
        if (catalog == null) {
            result.errLog.format("Invalid catalog from Resolver <%s>%n%s%n", catalogLocation, catFactory.getErrorMessage());
            result.fatalError = true;
            return null;
        }
        String datasetId = location.substring(pos + 1);
        Dataset ds = catalog.findDatasetByID(datasetId);
        if (ds == null) {
            result.fatalError = true;
            result.errLog.format("Could not find dataset %s in %s %n", datasetId, catalogLocation);
            return null;
        }
        return ds;
    }

    @Nonnull
    public Result openFeatureDataset(Dataset Dataset2, CancelTask task) throws IOException {
        return this.openFeatureDataset(null, Dataset2, task, new Result());
    }

    @Nonnull
    public Result openFeatureDataset(FeatureType wantFeatureType, Dataset ds, CancelTask task, Result result) throws IOException {
        Dataset rds;
        Access resolverAccess = this.findAccessByServiceType(ds.getAccess(), ServiceType.Resolver);
        if (resolverAccess != null && (rds = this.openResolver(resolverAccess.getStandardUrlName(), task, result)) != null) {
            ds = rds;
        }
        try {
            Access access;
            result.featureType = ds.getFeatureType();
            if (result.featureType == null) {
                result.featureType = wantFeatureType;
            }
            if ((access = this.findAccessByServiceType(ds.getAccess(), ServiceType.CdmrFeature)) != null) {
                return this.openFeatureDataset(result.featureType, access, task, result);
            }
            if (result.featureType == FeatureType.IMAGE) {
                access = this.getImageAccess(ds, task, result);
                if (access != null) {
                    return this.openFeatureDataset(result.featureType, access, task, result);
                }
                result.fatalError = true;
                return result;
            }
            NetcdfDataset ncd = this.openDataset(ds, true, task, result);
            if (null != ncd) {
                result.featureDataset = FeatureDatasetFactoryManager.wrap(result.featureType, ncd, task, result.errLog);
            }
            if (null == result.featureDataset) {
                result.fatalError = true;
            } else {
                result.location = result.featureDataset.getLocation();
                if (result.featureType == null) {
                    result.featureType = result.featureDataset.getFeatureType();
                }
            }
            return result;
        }
        catch (Throwable t2) {
            result.close();
            if (t2 instanceof IOException) {
                throw (IOException)t2;
            }
            throw new RuntimeException(t2);
        }
    }

    public Result openFeatureDataset(Access access, CancelTask task) throws IOException {
        Dataset ds = access.getDataset();
        Result result = new Result();
        if (ds.getFeatureType() == null) {
            result.errLog.format("InvDatasert must specify a FeatureType%n", new Object[0]);
            result.fatalError = true;
            return result;
        }
        return this.openFeatureDataset(ds.getFeatureType(), access, task, result);
    }

    private Result openFeatureDataset(FeatureType wantFeatureType, Access access, CancelTask task, Result result) throws IOException {
        result.featureType = wantFeatureType;
        result.accessUsed = access;
        if (result.featureType == FeatureType.IMAGE) {
            result.location = result.imageURL = access.getStandardUrlName();
            return result;
        }
        if (access.getService().getType() == ServiceType.CdmrFeature) {
            Optional<FeatureDataset> opt = CdmrFeatureDataset.factory(wantFeatureType, access.getStandardUrlName());
            if (opt.isPresent()) {
                result.featureDataset = opt.get();
            } else {
                result.errLog.format("%s", opt.getErrorMessage());
            }
        } else {
            NetcdfDataset ncd = this.openDataset(access, true, task, result);
            if (null != ncd) {
                result.featureDataset = FeatureDatasetFactoryManager.wrap(result.featureType, ncd, task, result.errLog);
            }
        }
        if (null == result.featureDataset) {
            result.fatalError = true;
        } else {
            result.location = result.featureDataset.getLocation();
            result.featureType = result.featureDataset.getFeatureType();
        }
        return result;
    }

    public NetcdfDataset openDataset(String location, boolean acquire, CancelTask task, Formatter log) throws IOException {
        Result result = new Result();
        Dataset dataset = this.openCatalogFromLocation(location, task, result);
        if (result.fatalError || dataset == null) {
            if (log != null) {
                log.format("%s", result.errLog);
            }
            result.close();
            return null;
        }
        return this.openDataset(dataset, acquire, task, result);
    }

    public NetcdfDataset openDataset(Dataset Dataset2, boolean acquire, CancelTask task, Formatter log) throws IOException {
        Result result = new Result();
        NetcdfDataset ncd = this.openDataset(Dataset2, acquire, task, result);
        if (log != null) {
            log.format("%s", result.errLog);
        }
        if (result.fatalError) {
            result.close();
            if (ncd != null) {
                ncd.close();
            }
        }
        return result.fatalError ? null : ncd;
    }

    private NetcdfDataset openDataset(Dataset dataset, boolean acquire, CancelTask task, Result result) throws IOException {
        IOException saveException = null;
        ArrayList<Access> accessList = new ArrayList<Access>(dataset.getAccess());
        while (!accessList.isEmpty()) {
            NetcdfDataset ds;
            Access access = this.chooseDatasetAccess(accessList);
            if (access == null) {
                result.errLog.format("No access that could be used in dataset %s %n", dataset);
                if (saveException != null) {
                    throw saveException;
                }
                return null;
            }
            String datasetLocation = access.getStandardUrlName();
            ServiceType serviceType = access.getService().getType();
            if (debugOpen) {
                System.out.println("ThreddsDataset.openDataset try " + datasetLocation + " " + (Object)((Object)serviceType));
            }
            if (serviceType == ServiceType.Resolver) {
                Dataset rds = this.openResolver(datasetLocation, task, result);
                if (rds == null) {
                    return null;
                }
                accessList = new ArrayList<Access>(rds.getAccess());
                continue;
            }
            try {
                ds = this.openDataset(access, acquire, task, result);
            }
            catch (IOException e) {
                String mess;
                result.errLog.format("Cant open %s %n err=%s%n", datasetLocation, e.getMessage());
                if (debugOpen) {
                    System.out.println("Cant open= " + datasetLocation + " " + (Object)((Object)serviceType));
                    e.printStackTrace();
                }
                if ((mess = e.getMessage()) != null && mess.contains("Unauthorized")) break;
                accessList.remove(access);
                saveException = e;
                continue;
            }
            result.accessUsed = access;
            return ds;
        }
        return null;
    }

    public NetcdfDataset openDataset(Access access, boolean acquire, CancelTask task, Formatter log) throws IOException {
        try (Result result = new Result();){
            NetcdfDataset ncd = this.openDataset(access, acquire, task, result);
            if (log != null) {
                log.format("%s", result.errLog);
            }
            if (result.fatalError && ncd != null) {
                ncd.close();
            }
            NetcdfDataset netcdfDataset = result.fatalError ? null : ncd;
            return netcdfDataset;
        }
    }

    private NetcdfDataset openDataset(Access access, boolean acquire, CancelTask task, Result result) throws IOException {
        Dataset ds = access.getDataset();
        String datasetId = ds.getId();
        String title = ds.getName();
        String datasetLocation = access.getStandardUrlName();
        ServiceType serviceType = access.getService().getType();
        if (debugOpen) {
            System.out.println("ThreddsDataset.openDataset= " + datasetLocation);
        }
        if (serviceType == ServiceType.Resolver) {
            Dataset rds = this.openResolver(datasetLocation, task, result);
            if (rds == null) {
                return null;
            }
            return this.openDataset(rds, acquire, task, result);
        }
        DatasetUrl durl = DatasetUrl.create(serviceType, datasetLocation);
        NetcdfDataset ncd = acquire ? NetcdfDatasets.acquireDataset(durl, true, task) : NetcdfDatasets.openDataset(durl, null, -1, task, null);
        result.accessUsed = access;
        ncd.setId(datasetId);
        ncd.setTitle(title);
        DataFactory.annotate(ds, ncd);
        return ncd;
    }

    public Access chooseDatasetAccess(List<Access> accessList) {
        if (accessList.isEmpty()) {
            return null;
        }
        Access access = null;
        if (preferAccess != null) {
            ServiceType type;
            ServiceType[] serviceTypeArray = preferAccess;
            int n = serviceTypeArray.length;
            for (int i = 0; i < n && (access = this.findAccessByServiceType(accessList, type = serviceTypeArray[i])) == null; ++i) {
            }
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.CdmRemote);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.DODS);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.OPENDAP);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.DAP4);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.File);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.HTTPServer);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.ADDE);
        }
        if (access == null) {
            access = this.findAccessByServiceType(accessList, ServiceType.Resolver);
        }
        return access;
    }

    private Dataset openResolver(String urlString, CancelTask task, Result result) {
        CatalogBuilder catFactory = new CatalogBuilder();
        Catalog catalog = catFactory.buildFromLocation(urlString, null);
        if (catalog == null) {
            result.errLog.format("Couldnt open Resolver %s err=%s%n ", urlString, catFactory.getErrorMessage());
            return null;
        }
        for (Dataset ds : catalog.getDatasetsLocal()) {
            if (ds.hasAccess()) {
                return ds;
            }
            for (Dataset nested : ds.getDatasetsLocal()) {
                if (!nested.hasAccess()) continue;
                return nested;
            }
        }
        return null;
    }

    public static void annotate(Dataset ds, NetcdfDataset ncDataset) {
        ncDataset.setTitle(ds.getName());
        ncDataset.setId(ds.getId());
        for (Property p : ds.getProperties()) {
            String name = p.getName();
            if (null != ncDataset.findGlobalAttribute(name)) continue;
            ncDataset.addAttribute(null, new Attribute(name, p.getValue()));
        }
        ncDataset.finish();
    }

    private Access getImageAccess(Dataset ds, CancelTask task, Result result) {
        ArrayList<Access> accessList = new ArrayList<Access>(ds.getAccess());
        while (!accessList.isEmpty()) {
            Access access = this.chooseImageAccess(accessList);
            if (access == null) {
                result.errLog.format("No access that could be used for Image Type %s %n", ds);
                return null;
            }
            String datasetLocation = access.getStandardUrlName();
            Dataset rds = this.openResolver(datasetLocation, task, result);
            if (rds == null) {
                return null;
            }
            accessList = new ArrayList<Access>(ds.getAccess());
        }
        return null;
    }

    private Access chooseImageAccess(List<Access> accessList) {
        String datasetLocation;
        Access access = this.findAccessByDataFormatType(accessList, DataFormatType.JPEG);
        if (access != null) {
            return access;
        }
        access = this.findAccessByDataFormatType(accessList, DataFormatType.GIF);
        if (access != null) {
            return access;
        }
        access = this.findAccessByDataFormatType(accessList, DataFormatType.TIFF);
        if (access != null) {
            return access;
        }
        access = this.findAccessByServiceType(accessList, ServiceType.ADDE);
        if (access != null && (datasetLocation = access.getStandardUrlName()).indexOf("image") > 0) {
            return access;
        }
        return access;
    }

    private Access findAccessByServiceType(List<Access> accessList, ServiceType type) {
        for (Access a : accessList) {
            ServiceType stype = a.getService().getType();
            if (stype == null || !stype.toString().equalsIgnoreCase(type.toString())) continue;
            return a;
        }
        return null;
    }

    private Access findAccessByDataFormatType(List<Access> accessList, DataFormatType type) {
        for (Access a : accessList) {
            DataFormatType has = a.getDataFormatType();
            if (has == null || !type.toString().equalsIgnoreCase(has.toString())) continue;
            return a;
        }
        return null;
    }

    public static class Result
    implements Closeable {
        public boolean fatalError;
        public Formatter errLog = new Formatter();
        public FeatureType featureType;
        public FeatureDataset featureDataset;
        public String imageURL;
        public String location;
        public Access accessUsed;

        public String toString() {
            String sb = "Result{fatalError=" + this.fatalError + ", errLog=" + this.errLog + ", featureType=" + (Object)((Object)this.featureType) + ", featureDataset=" + this.featureDataset + ", imageURL='" + this.imageURL + '\'' + ", location='" + this.location + '\'' + ", accessUsed=" + this.accessUsed + '}';
            return sb;
        }

        @Override
        public void close() throws IOException {
            if (this.featureDataset != null) {
                this.featureDataset.close();
            }
        }
    }
}

