/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import thredds.inventory.MFile;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

@ThreadSafe
public class MFileOS
implements MFile {
    private final File file;
    private final long lastModified;
    private Object auxInfo;

    @Nullable
    public static MFileOS getExistingFile(String filename) {
        if (filename == null) {
            return null;
        }
        File file2 = new File(filename);
        if (file2.exists()) {
            return new MFileOS(file2);
        }
        return null;
    }

    public MFileOS(File file2) {
        this.file = file2;
        this.lastModified = file2.lastModified();
    }

    public MFileOS(String filename) {
        this.file = new File(filename.replaceFirst("^file:", ""));
        this.lastModified = this.file.lastModified();
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    @Override
    public long getLength() {
        return this.file.length();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isReadable() {
        return Files.isReadable(this.file.toPath());
    }

    @Override
    public String getPath() {
        return StringUtil2.replace(this.file.getPath(), '\\', "/");
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    @Nullable
    public MFile getParent() {
        File parent = this.file.getParentFile();
        return parent == null ? null : new MFileOS(parent);
    }

    @Override
    public int compareTo(MFile o) {
        return this.getPath().compareTo(o.getPath());
    }

    @Override
    public Object getAuxInfo() {
        return this.auxInfo;
    }

    @Override
    public void setAuxInfo(Object auxInfo) {
        this.auxInfo = auxInfo;
    }

    public String toString() {
        String sb = "MFileOS{file=" + this.file.getPath() + ", lastModified=" + this.lastModified + '}';
        return sb;
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public FileInputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.file);
    }

    @Override
    public void writeToStream(OutputStream outputStream) throws IOException {
        IO.copyFile(this.file, outputStream);
    }

    @Override
    public void writeToStream(OutputStream outputStream, long offset, long maxBytes) throws IOException {
        try (RandomAccessFile randomAccessFile = RandomAccessFile.acquire(this.file.getPath());){
            IO.copyRafB(randomAccessFile, offset, maxBytes, outputStream);
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public MFileOS getChild(String newFilename) {
        return new MFileOS(new File(this.file, newFilename));
    }
}

