/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import javax.annotation.concurrent.Immutable;
import thredds.inventory.MFile;
import thredds.inventory.MFileFilter;

@Immutable
public class CollectionConfig {
    private final String name;
    private final String dirName;
    private final boolean wantSubdirs;
    private final MFileFilter ff;
    private final Object auxInfo;

    public CollectionConfig(String name, String dirName, boolean wantSubdirs, MFileFilter ff, Object auxInfo) {
        this.name = name;
        this.dirName = dirName;
        this.wantSubdirs = wantSubdirs;
        this.ff = ff;
        this.auxInfo = auxInfo;
    }

    public CollectionConfig subdir(MFile child) {
        return new CollectionConfig(this.name + "/" + child.getName(), this.dirName + "/" + child.getName(), this.wantSubdirs, this.ff, child.getAuxInfo());
    }

    public String getName() {
        return this.name;
    }

    public String getDirectoryName() {
        return this.dirName;
    }

    public boolean wantSubdirs() {
        return this.wantSubdirs;
    }

    public MFileFilter getFileFilter() {
        return this.ff;
    }

    public boolean accept(MFile file2) {
        return this.ff == null || this.ff.accept(file2);
    }

    public String toString() {
        return "MCollection{name='" + this.name + '\'' + ", dirName='" + this.dirName + '\'' + ", wantSubdirs=" + this.wantSubdirs + ", filter=" + this.ff + '}';
    }

    public Object getAuxInfo() {
        return this.auxInfo;
    }
}

