/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.util.ArrayList;
import java.util.List;
import loci.formats.CoreMetadata;
import loci.formats.CoreMetadataList;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.testng.internal.junit.ArrayAsserts;

public class CoreMetadataListTest {
    @DataProvider(name="corelist")
    public Object[][] createList() {
        int[] expected0 = new int[]{};
        ArrayList list0 = new ArrayList();
        int[] expected1 = new int[]{1};
        ArrayList<CoreMetadata> list1 = new ArrayList<CoreMetadata>();
        list1.add(new CoreMetadata());
        int[] expected2 = new int[]{1, 1, 1, 1};
        ArrayList<CoreMetadata> list2 = new ArrayList<CoreMetadata>();
        list2.add(new CoreMetadata());
        list2.add(new CoreMetadata());
        list2.add(new CoreMetadata());
        list2.add(new CoreMetadata());
        int[] expected3 = new int[]{5};
        ArrayList<CoreMetadata> list3 = new ArrayList<CoreMetadata>();
        list3.add(new CoreMetadata());
        list3.add(new CoreMetadata());
        list3.add(new CoreMetadata());
        list3.add(new CoreMetadata());
        list3.add(new CoreMetadata());
        ((CoreMetadata)list3.get((int)0)).resolutionCount = 5;
        ((CoreMetadata)list3.get((int)0)).sizeX = 4096;
        ((CoreMetadata)list3.get((int)0)).sizeY = 4096;
        ((CoreMetadata)list3.get((int)0)).sizeZ = 1024;
        ((CoreMetadata)list3.get((int)1)).sizeX = 8192;
        ((CoreMetadata)list3.get((int)1)).sizeY = 8192;
        ((CoreMetadata)list3.get((int)1)).sizeZ = 1024;
        ((CoreMetadata)list3.get((int)0)).sizeX = 0;
        ((CoreMetadata)list3.get((int)0)).sizeY = 0;
        ((CoreMetadata)list3.get((int)0)).sizeZ = 0;
        ((CoreMetadata)list3.get((int)3)).sizeX = 2048;
        ((CoreMetadata)list3.get((int)3)).sizeY = 2048;
        ((CoreMetadata)list3.get((int)3)).sizeZ = 512;
        ((CoreMetadata)list3.get((int)4)).sizeX = 1024;
        ((CoreMetadata)list3.get((int)4)).sizeY = 1024;
        ((CoreMetadata)list3.get((int)4)).sizeZ = 256;
        int[] expected4 = new int[]{1, 4, 2, 1, 1, 1};
        ArrayList<CoreMetadata> list4 = new ArrayList<CoreMetadata>();
        for (int i = 0; i < 10; ++i) {
            list4.add(new CoreMetadata());
        }
        int pos = 0;
        int[] nArray = expected4;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int v;
            ((CoreMetadata)list4.get((int)pos)).resolutionCount = v = nArray[i];
            pos += v;
        }
        return new Object[][]{{list0, expected0}, {list1, expected1}, {list2, expected2}, {list3, expected3}, {list4, expected4}};
    }

    @Test(dataProvider="corelist")
    public void testResolutionCounts(List<CoreMetadata> data, int[] expected) {
        CoreMetadataList list = new CoreMetadataList();
        list.setFlattenedList(data);
        ArrayAsserts.assertArrayEquals((int[])expected, (int[])list.sizes());
        for (int i = 0; i < expected.length; ++i) {
            AssertJUnit.assertEquals((int)expected[i], (int)((CoreMetadata)list.get((int)i, (int)0)).resolutionCount);
        }
    }

    @Test(dataProvider="corelist")
    public void testFlattenedList(List<CoreMetadata> data, int[] expected) {
        CoreMetadataList list = new CoreMetadataList();
        list.setFlattenedList(data);
        List flat = list.getFlattenedList();
        for (int i = 0; i < data.size(); ++i) {
            CoreMetadata cdata = data.get(i);
            CoreMetadata cflat = (CoreMetadata)flat.get(i);
            CoreMetadataListTest.compareCoreMetadata(cflat, cdata, true);
        }
    }

    @Test(dataProvider="corelist")
    public void testFlattenedSize(List<CoreMetadata> data, int[] expected) {
        CoreMetadataList list = new CoreMetadataList();
        list.setFlattenedList(data);
        int ncore = 0;
        for (int v : list.sizes()) {
            ncore += v;
        }
        AssertJUnit.assertEquals((int)ncore, (int)list.flattenedSize());
    }

    @Test(dataProvider="corelist")
    public void testCopy(List<CoreMetadata> data, int[] expected) {
        CoreMetadataList list = new CoreMetadataList();
        list.setFlattenedList(data);
        CoreMetadataList list2 = new CoreMetadataList(list);
        List flat = list2.getFlattenedList();
        AssertJUnit.assertEquals((int)data.size(), (int)flat.size());
        for (int i = 0; i < data.size(); ++i) {
            CoreMetadata cdata = data.get(i);
            CoreMetadata cflat = (CoreMetadata)flat.get(i);
            CoreMetadataListTest.compareCoreMetadata(cflat, cdata, true);
        }
    }

    @Test(dataProvider="corelist")
    public void testSeriesCopy(List<CoreMetadata> data, int[] expected) {
        CoreMetadataList list = new CoreMetadataList();
        list.setFlattenedList(data);
        CoreMetadataList list2 = new CoreMetadataList(list);
        List flat = list2.getSeriesList();
        AssertJUnit.assertEquals((int)list.size(), (int)flat.size());
        for (int i = 0; i < list.size(); ++i) {
            CoreMetadata clist = (CoreMetadata)list.get(i, 0);
            CoreMetadata cflat = (CoreMetadata)flat.get(i);
            CoreMetadataListTest.compareCoreMetadata(cflat, clist, false);
        }
    }

    @Test(dataProvider="corelist")
    public void testFlattenedIndex(List<CoreMetadata> data, int[] expected) {
        CoreMetadataList list = new CoreMetadataList();
        list.setFlattenedList(data);
        int size = list.flattenedSize();
        for (int i = 0; i < size; ++i) {
            int[] idx2 = list.flattenedIndexes(i);
            int idx = list.flattenedIndex(idx2[0], idx2[1]);
            AssertJUnit.assertEquals((int)i, (int)idx);
        }
    }

    @Test
    public void testAutomaticOrdering() {
        CoreMetadataList list = new CoreMetadataList();
        ArrayList<CoreMetadata> data = new ArrayList<CoreMetadata>();
        data.add(new CoreMetadata());
        data.add(new CoreMetadata());
        data.add(new CoreMetadata());
        data.add(new CoreMetadata());
        data.add(new CoreMetadata());
        ((CoreMetadata)data.get((int)0)).resolutionCount = 5;
        ((CoreMetadata)data.get((int)0)).sizeX = 4096;
        ((CoreMetadata)data.get((int)0)).sizeY = 4096;
        ((CoreMetadata)data.get((int)0)).sizeZ = 1024;
        ((CoreMetadata)data.get((int)1)).sizeX = 8192;
        ((CoreMetadata)data.get((int)1)).sizeY = 8192;
        ((CoreMetadata)data.get((int)1)).sizeZ = 1024;
        ((CoreMetadata)data.get((int)2)).sizeX = 0;
        ((CoreMetadata)data.get((int)2)).sizeY = 0;
        ((CoreMetadata)data.get((int)2)).sizeZ = 0;
        ((CoreMetadata)data.get((int)3)).sizeX = 2048;
        ((CoreMetadata)data.get((int)3)).sizeY = 2048;
        ((CoreMetadata)data.get((int)3)).sizeZ = 512;
        ((CoreMetadata)data.get((int)4)).sizeX = 1024;
        ((CoreMetadata)data.get((int)4)).sizeY = 1024;
        ((CoreMetadata)data.get((int)4)).sizeZ = 256;
        list.setFlattenedList(data);
        list.reorder();
        AssertJUnit.assertEquals((int)8192, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeX);
        AssertJUnit.assertEquals((int)8192, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeY);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeZ);
        AssertJUnit.assertEquals((int)4096, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeX);
        AssertJUnit.assertEquals((int)4096, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeY);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeZ);
        AssertJUnit.assertEquals((int)2048, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeX);
        AssertJUnit.assertEquals((int)2048, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeY);
        AssertJUnit.assertEquals((int)512, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeZ);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeX);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeY);
        AssertJUnit.assertEquals((int)256, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeZ);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeX);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeY);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeZ);
    }

    @Test
    public void testManualOrdering() {
        ArrayList<CoreMetadata> data = new ArrayList<CoreMetadata>();
        data.add(new CoreMetadata());
        data.add(new CoreMetadata());
        data.add(new CoreMetadata());
        data.add(new CoreMetadata());
        data.add(new CoreMetadata());
        ((CoreMetadata)data.get((int)0)).resolutionCount = 5;
        ((CoreMetadata)data.get((int)0)).sizeX = 4096;
        ((CoreMetadata)data.get((int)0)).sizeY = 4096;
        ((CoreMetadata)data.get((int)0)).sizeZ = 1024;
        ((CoreMetadata)data.get((int)1)).sizeX = 8192;
        ((CoreMetadata)data.get((int)1)).sizeY = 8192;
        ((CoreMetadata)data.get((int)1)).sizeZ = 1024;
        ((CoreMetadata)data.get((int)2)).sizeX = 0;
        ((CoreMetadata)data.get((int)2)).sizeY = 0;
        ((CoreMetadata)data.get((int)2)).sizeZ = 0;
        ((CoreMetadata)data.get((int)3)).sizeX = 2048;
        ((CoreMetadata)data.get((int)3)).sizeY = 2048;
        ((CoreMetadata)data.get((int)3)).sizeZ = 512;
        ((CoreMetadata)data.get((int)4)).sizeX = 1024;
        ((CoreMetadata)data.get((int)4)).sizeY = 1024;
        ((CoreMetadata)data.get((int)4)).sizeZ = 256;
        CoreMetadataList list = new CoreMetadataList(1, data.size());
        list.add();
        for (int i = 0; i < data.size(); ++i) {
            list.set(0, i, (Object)((CoreMetadata)data.get(i)));
        }
        AssertJUnit.assertEquals((int)4096, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeX);
        AssertJUnit.assertEquals((int)4096, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeY);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeZ);
        AssertJUnit.assertEquals((int)8192, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeX);
        AssertJUnit.assertEquals((int)8192, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeY);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeZ);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeX);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeY);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeZ);
        AssertJUnit.assertEquals((int)2048, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeX);
        AssertJUnit.assertEquals((int)2048, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeY);
        AssertJUnit.assertEquals((int)512, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeZ);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeX);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeY);
        AssertJUnit.assertEquals((int)256, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeZ);
        list.reorder();
        AssertJUnit.assertEquals((int)8192, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeX);
        AssertJUnit.assertEquals((int)8192, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeY);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)0)).sizeZ);
        AssertJUnit.assertEquals((int)4096, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeX);
        AssertJUnit.assertEquals((int)4096, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeY);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)1)).sizeZ);
        AssertJUnit.assertEquals((int)2048, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeX);
        AssertJUnit.assertEquals((int)2048, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeY);
        AssertJUnit.assertEquals((int)512, (int)((CoreMetadata)list.get((int)0, (int)2)).sizeZ);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeX);
        AssertJUnit.assertEquals((int)1024, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeY);
        AssertJUnit.assertEquals((int)256, (int)((CoreMetadata)list.get((int)0, (int)3)).sizeZ);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeX);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeY);
        AssertJUnit.assertEquals((int)0, (int)((CoreMetadata)list.get((int)0, (int)4)).sizeZ);
    }

    public static void compareCoreMetadata(CoreMetadata observed, CoreMetadata expected, boolean includeResolutionCount) {
        AssertJUnit.assertEquals((int)expected.sizeX, (int)observed.sizeX);
        AssertJUnit.assertEquals((int)expected.sizeY, (int)observed.sizeY);
        AssertJUnit.assertEquals((int)expected.sizeZ, (int)observed.sizeZ);
        AssertJUnit.assertEquals((int)expected.sizeC, (int)observed.sizeC);
        AssertJUnit.assertEquals((int)expected.sizeT, (int)observed.sizeT);
        AssertJUnit.assertEquals((int)expected.thumbSizeX, (int)observed.thumbSizeX);
        AssertJUnit.assertEquals((int)expected.thumbSizeY, (int)observed.thumbSizeY);
        AssertJUnit.assertEquals((int)expected.pixelType, (int)observed.pixelType);
        AssertJUnit.assertEquals((int)expected.bitsPerPixel, (int)observed.bitsPerPixel);
        AssertJUnit.assertEquals((int)expected.imageCount, (int)observed.imageCount);
        AssertJUnit.assertEquals((String)expected.dimensionOrder, (String)observed.dimensionOrder);
        AssertJUnit.assertEquals((boolean)expected.orderCertain, (boolean)observed.orderCertain);
        AssertJUnit.assertEquals((boolean)expected.rgb, (boolean)observed.rgb);
        AssertJUnit.assertEquals((boolean)expected.littleEndian, (boolean)observed.littleEndian);
        AssertJUnit.assertEquals((boolean)expected.interleaved, (boolean)observed.interleaved);
        AssertJUnit.assertEquals((boolean)expected.indexed, (boolean)observed.indexed);
        AssertJUnit.assertEquals((boolean)expected.falseColor, (boolean)observed.falseColor);
        AssertJUnit.assertEquals((boolean)expected.metadataComplete, (boolean)observed.metadataComplete);
        AssertJUnit.assertEquals((Object)expected.seriesMetadata, (Object)observed.seriesMetadata);
        AssertJUnit.assertEquals((boolean)expected.thumbnail, (boolean)observed.thumbnail);
        if (includeResolutionCount) {
            AssertJUnit.assertEquals((int)expected.resolutionCount, (int)observed.resolutionCount);
        } else {
            AssertJUnit.assertEquals((int)1, (int)observed.resolutionCount);
        }
    }
}

