/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import loci.common.DataTools;
import loci.formats.ImageReader;
import loci.formats.UnknownFormatException;
import loci.tests.testng.ConfigurationTree;
import loci.tests.testng.FormatReaderTest;
import loci.tests.testng.TestTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.Factory;

public class FormatReaderTestFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatReaderTestFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Factory
    public Object[] createInstances() {
        LOGGER.info("java.version = {}", (Object)System.getProperty("java.version"));
        ArrayList<String> files = new ArrayList<String>();
        String nameProp = "testng.filename";
        String filename = TestTools.getProperty("testng.filename");
        if (filename != null && !new File(filename).exists()) {
            LOGGER.error("Invalid filename: {}", (Object)filename);
            return new Object[0];
        }
        String cachedFileList = TestTools.getProperty("testng.file-list");
        String[] cachedFiles = null;
        if (cachedFileList != null && new File(cachedFileList).exists()) {
            try {
                cachedFiles = DataTools.readFile((String)cachedFileList).split("\n");
            }
            catch (IOException e) {
                LOGGER.warn("Could not read file: {}", (Object)cachedFileList, (Object)e);
            }
        }
        String baseDir = null;
        String configDir = null;
        String cacheDir = null;
        String[] validSubdirs = null;
        if (filename == null) {
            String baseDirProp = "testng.directory";
            baseDir = TestTools.getProperty("testng.directory");
            if (baseDir == null) {
                baseDir = TestTools.getProperty("testng.directory-prefix");
                String dirList = System.getProperty("testng.directory-list");
                try {
                    validSubdirs = DataTools.readFile((String)dirList).split("\n");
                }
                catch (IOException e) {
                    LOGGER.debug("", (Throwable)e);
                }
            }
            if (baseDir == null && cachedFiles != null) {
                baseDir = cachedFiles[0];
            }
            if (baseDir == null) {
                LOGGER.error("No base directory specified.");
                LOGGER.error("Please specify a directory containing files to test:");
                LOGGER.error("   ant -D{}=\"/path/to/data\" test-all", (Object)"testng.directory");
                return new Object[0];
            }
            File baseDirFile = new File(baseDir);
            if (!baseDirFile.isDirectory()) {
                LOGGER.info("Directory: {}", (Object)baseDir);
                LOGGER.info("  exists?: {}", (Object)baseDirFile.exists());
                LOGGER.info("  readable?: {}", (Object)baseDirFile.canRead());
                LOGGER.info("  is a directory?: {}", (Object)baseDirFile.isDirectory());
                LOGGER.error("Please specify a directory containing files to test:");
                LOGGER.error("   ant -D{}=\"/path/to/data\" test-all", (Object)"testng.directory");
                return new Object[0];
            }
            LOGGER.info("testng.directory = {}", (Object)baseDir);
            String configDirProperty = "testng.configDirectory";
            configDir = TestTools.getProperty("testng.configDirectory");
            if (configDir != null) {
                LOGGER.info("testng.configDirectory = {}", (Object)configDir);
            }
            String cacheDirProperty = "testng.cacheDirectory";
            cacheDir = TestTools.getProperty("testng.cacheDirectory");
            if (cacheDir != null) {
                LOGGER.info("testng.cacheDirectory = {}", (Object)cacheDir);
            }
            FormatReaderTest.configTree = new ConfigurationTree(baseDir, configDir, cacheDir);
        }
        String multProp = "testng.multiplier";
        String mult = TestTools.getProperty("testng.multiplier");
        float multiplier = 1.0f;
        if (mult != null) {
            try {
                multiplier = Float.parseFloat(mult);
            }
            catch (NumberFormatException exc) {
                LOGGER.warn("Invalid multiplier: {}", (Object)mult);
            }
        }
        LOGGER.info("testng.multiplier = {}", (Object)Float.valueOf(multiplier));
        String inMemoryProp = "testng.in-memory";
        String inMemoryValue = TestTools.getProperty("testng.in-memory");
        boolean inMemory = Boolean.parseBoolean(inMemoryValue);
        LOGGER.info("testng.in-memory = {}", (Object)inMemory);
        String toplevelConfig = "testng.toplevel-config";
        String configFile = TestTools.getProperty("testng.toplevel-config");
        if (configFile != null) {
            LOGGER.info("testng.toplevel-config = {}", (Object)configFile);
        }
        String configSuffixProperty = "testng.configSuffix";
        String configSuffix = TestTools.getProperty("testng.configSuffix");
        if (configSuffix == null) {
            configSuffix = "";
        }
        String allowMissingProp = "testng.allow-missing";
        String allowMissingValue = TestTools.getProperty("testng.allow-missing");
        boolean allowMissing = Boolean.parseBoolean(allowMissingValue);
        LOGGER.info("testng.allow-missing = {}", (Object)allowMissing);
        LOGGER.info("user.language = {}", (Object)System.getProperty("user.language"));
        LOGGER.info("user.country = {}", (Object)System.getProperty("user.country"));
        long maxMemory = Runtime.getRuntime().maxMemory() >> 20;
        LOGGER.info("Maximum heap size = {} MB", (Object)maxMemory);
        if (filename == null && cachedFiles == null) {
            System.out.println("Scanning for files...");
            long start = System.currentTimeMillis();
            try {
                TestTools.getFiles(baseDir, files, FormatReaderTest.configTree, configFile, validSubdirs, configSuffix);
            }
            catch (Exception e) {
                LOGGER.info("Failed to retrieve complete list of files", (Throwable)e);
            }
            long end = System.currentTimeMillis();
            double time = (double)(end - start) / 1000.0;
            LOGGER.info("----------------------------------------");
            LOGGER.info("Total files: {}", (Object)files.size());
            long avg = end - start;
            if (files.size() > 0) {
                avg /= (long)files.size();
            }
            LOGGER.info("Scan time: {} s ({} ms/file)", (Object)time, (Object)avg);
            LOGGER.info("----------------------------------------");
        } else if (filename != null) {
            files.add(filename);
        }
        LinkedHashSet<String> fileSet = new LinkedHashSet<String>();
        HashMap<String, String> originalPath = new HashMap<String, String>();
        for (String s : files) {
            String canonicalPath;
            try {
                canonicalPath = new File(s).getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.warn("Could not get canonical path for {}", (Object)s);
                canonicalPath = s;
            }
            fileSet.add(canonicalPath);
            originalPath.put(canonicalPath, s);
        }
        LinkedHashSet<String> minimalFiles = new LinkedHashSet<String>();
        ImageReader reader = new ImageReader();
        LinkedHashSet<String> failingIds = new LinkedHashSet<String>();
        while (!fileSet.isEmpty()) {
            ArrayList<String> handles4;
            String file = (String)fileSet.iterator().next();
            ArrayList<String> originalHandles = null;
            try {
                originalHandles = TestTools.getHandles(true);
                reader.setId(file);
            }
            catch (UnknownFormatException u) {
                boolean validConfig = false;
                try {
                    validConfig = FormatReaderTest.configTree.get(file) != null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (validConfig) {
                    LOGGER.error("setId(\"{}\") failed", (Object)file, (Object)u);
                    failingIds.add(file);
                } else {
                    LOGGER.debug("Skipping file {} with unknown type", (Object)file);
                }
                fileSet.remove(file);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("setId(\"{}\") failed", (Object)file, (Object)e);
                failingIds.add(file);
                fileSet.remove(file);
                continue;
            }
            String[] usedFiles2333333332 = reader.getUsedFiles();
            LinkedHashSet<String> auxFiles = new LinkedHashSet<String>();
            for (String s : usedFiles2333333332) {
                auxFiles.add(new File(s).getCanonicalPath());
            }
            fileSet.removeAll(auxFiles);
            String masterFile = reader.getCurrentFile();
            auxFiles.remove(masterFile);
            minimalFiles.removeAll(auxFiles);
            minimalFiles.add(masterFile);
            fileSet.remove(file);
            try {
                reader.close();
            }
            catch (IOException usedFiles2333333332) {
                // empty catch block
            }
            try {
                handles4 = TestTools.getHandles(true);
                if (originalHandles == null || handles4.size() <= originalHandles.size()) continue;
                String msg = String.format("setId on %s failed to close %s files", file, handles4.size() - originalHandles.size());
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            catch (IOException handles2) {
                continue;
            }
            catch (Exception e222222222) {
                try {
                    LOGGER.warn("Could not determine duplicate status for {}", (Object)file, (Object)e222222222);
                    minimalFiles.add(file);
                    fileSet.remove(file);
                }
                catch (Throwable throwable) {
                    fileSet.remove(file);
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        ArrayList<String> handles3 = TestTools.getHandles(true);
                        if (originalHandles != null && handles3.size() > originalHandles.size()) {
                            String msg = String.format("setId on %s failed to close %s files", file, handles3.size() - originalHandles.size());
                            LOGGER.error(msg);
                            throw new RuntimeException(msg);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (IOException e222222222) {
                    // empty catch block
                }
                try {
                    handles4 = TestTools.getHandles(true);
                    if (originalHandles == null || handles4.size() <= originalHandles.size()) continue;
                    String msg = String.format("setId on %s failed to close %s files", file, handles4.size() - originalHandles.size());
                    LOGGER.error(msg);
                    throw new RuntimeException(msg);
                }
                catch (IOException handles4) {
                }
            }
        }
        if (!failingIds.isEmpty()) {
            if (!allowMissing) {
                String msg = String.format("setId failed on %s", failingIds);
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            for (String id : failingIds) {
                boolean found = false;
                try {
                    if (FormatReaderTest.configTree.get(id) != null) {
                        found = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("", (Throwable)e);
                }
                if (found) {
                    String msg = String.format("setId failed on %s", id);
                    LOGGER.error(msg);
                    throw new RuntimeException(msg);
                }
                String msg = String.format("setId failed on %s (skipping)", id);
                LOGGER.warn(msg);
            }
        }
        files = new ArrayList();
        for (String s : minimalFiles) {
            if (!originalPath.containsKey(s)) {
                String msg = "No match found for " + s;
                LOGGER.error(msg);
                throw new RuntimeException(msg);
            }
            files.add((String)originalPath.get(s));
        }
        if (cachedFiles != null) {
            FormatReaderTest.configTree = new ConfigurationTree(baseDir, configDir, cacheDir);
            TestTools.parseConfigFiles(configDir, FormatReaderTest.configTree);
            for (int i = 1; i < cachedFiles.length; ++i) {
                files.add(cachedFiles[i]);
            }
        }
        System.out.println("Building list of tests...");
        ArrayList<FormatReaderTest> tests = new ArrayList<FormatReaderTest>();
        for (String id : files) {
            try {
                boolean found = true;
                if (FormatReaderTest.configTree.get(id) == null) {
                    found = false;
                    if (allowMissing) {
                        LOGGER.warn("{} not configured (skipping).", (Object)id);
                    } else {
                        LOGGER.error("{} not configured.", (Object)id);
                    }
                }
                if (!found && allowMissing) continue;
                tests.add(new FormatReaderTest(id, multiplier, inMemory));
            }
            catch (Exception e) {
                LOGGER.warn("", (Throwable)e);
            }
        }
        if (tests.size() == 1) {
            System.out.println("Ready to test " + (String)files.get(0));
        } else {
            System.out.println("Ready to test " + tests.size() + " files");
        }
        return tests.toArray(new Object[tests.size()]);
    }
}

