/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import loci.common.DataTools;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.gui.BufferedImageReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.out.JPEG2000Writer;
import loci.formats.out.JPEGWriter;
import loci.formats.services.OMEXMLService;
import loci.tests.testng.Configuration;
import loci.tests.testng.ConfigurationTree;
import loci.tests.testng.TestTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FormatWriterTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatWriterTest.class);
    private static final String SKIP_MESSAGE = "Dataset already tested.";
    public static ConfigurationTree configTree;
    public static List skipFiles;
    private static BufferedImageReader reader;
    private static BufferedImageReader convertedReader;
    private static Configuration config;
    private String id;
    private boolean skip = false;

    public FormatWriterTest(String filename) {
        this.id = filename;
        try {
            reader.setId(this.id);
        }
        catch (FormatException e) {
            LOGGER.info("", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.info("", (Throwable)e);
        }
    }

    @DataProvider(name="getWriterList")
    public Object[][] getWriterList() {
        IFormatWriter[] writers = new ImageWriter().getWriters();
        ArrayList<IFormatWriter> tmp = new ArrayList<IFormatWriter>();
        for (int i = 0; i < writers.length; ++i) {
            String[] compressionTypes = writers[i].getCompressionTypes();
            if (compressionTypes == null) {
                try {
                    IFormatWriter w = (IFormatWriter)writers[i].getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    tmp.add(w);
                }
                catch (ReflectiveOperationException w) {}
                continue;
            }
            for (int q = 0; q < compressionTypes.length; ++q) {
                try {
                    IFormatWriter w = (IFormatWriter)writers[i].getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (!DataTools.containsValue((int[])w.getPixelTypes(compressionTypes[q]), (int)reader.getPixelType())) continue;
                    w.setCompression(compressionTypes[q]);
                    tmp.add(w);
                    continue;
                }
                catch (FormatException formatException) {
                    continue;
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    // empty catch block
                }
            }
        }
        Object[][] writersToUse = new IFormatWriter[tmp.size()][1];
        for (int i = 0; i < tmp.size(); ++i) {
            writersToUse[i][0] = (IFormatWriter)tmp.get(i);
        }
        return writersToUse;
    }

    @Test(groups={"all"}, dataProvider="getWriterList")
    public void testWriterConsistency(IFormatWriter writer) {
        String testName = TestTools.shortClassName(writer) + " " + writer.getCompression() + " testWriterConsistency";
        boolean success = true;
        String msg = null;
        try {
            boolean imageMatch;
            reader.close();
            ServiceFactory factory = new ServiceFactory();
            OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            reader.setMetadataStore((MetadataStore)service.createOMEXMLMetadata());
            reader.setId(this.id);
            int type = reader.getPixelType();
            if (!writer.isSupportedType(type)) {
                success = true;
                FormatWriterTest.result(testName, success, msg);
                return;
            }
            config = configTree.get(this.id);
            String prefix = this.id.substring(this.id.lastIndexOf(File.separator) + 1, this.id.lastIndexOf("."));
            while (prefix.length() < 3) {
                prefix = "x" + prefix;
            }
            String suffix = "." + writer.getSuffixes()[0];
            File tmpFile = File.createTempFile(prefix, suffix);
            tmpFile.deleteOnExit();
            String convertedFile = tmpFile.getAbsolutePath();
            IMetadata meta = (IMetadata)reader.getMetadataStore();
            writer.close();
            writer.setMetadataRetrieve((MetadataRetrieve)meta);
            writer.setId(convertedFile);
            int seriesCount = writer.canDoStacks() ? reader.getSeriesCount() : 1;
            for (int series = 0; series < seriesCount; ++series) {
                reader.setSeries(series);
                writer.setSeries(series);
                int imageCount = writer.canDoStacks() ? reader.getImageCount() : 1;
                for (int image = 0; image < imageCount; ++image) {
                    writer.saveBytes(image, reader.openBytes(image));
                }
            }
            writer.close();
            convertedReader.setId(convertedFile);
            boolean seriesMatch = convertedReader.getSeriesCount() == config.getSeriesCount();
            boolean expectRGB = config.isRGB();
            int expectedCount = config.getSizeZ() * config.getSizeT() * (expectRGB ? 1 : config.getSizeC());
            boolean bl = imageMatch = convertedReader.getImageCount() == expectedCount;
            if (!seriesMatch && writer.canDoStacks()) {
                int totalImages = 0;
                for (int i = 0; i < reader.getSeriesCount(); ++i) {
                    reader.setSeries(i);
                    totalImages += reader.getImageCount();
                }
                reader.setSeries(0);
                if (convertedReader.getImageCount() != totalImages) {
                    success = false;
                    msg = "Series counts do not match (found " + convertedReader.getSeriesCount() + ", expected " + config.getSeriesCount() + ")";
                } else {
                    imageMatch = true;
                }
            }
            if (success) {
                for (int series = 0; series < seriesCount && series < convertedReader.getSeriesCount(); ++series) {
                    convertedReader.setSeries(series);
                    config.setSeries(series);
                    int expectedX = config.getSizeX();
                    int expectedY = config.getSizeY();
                    expectRGB = config.isRGB();
                    if (TestTools.shortClassName(writer).equals("OMEXMLWriter")) {
                        expectRGB = false;
                    } else if (TestTools.shortClassName(writer).equals("JPEGWriter")) {
                        expectRGB = expectRGB || config.isIndexed();
                    }
                    int expectedPixelType = FormatTools.pixelTypeFromString((String)config.getPixelType());
                    expectedCount = config.getSizeZ() * config.getSizeT() * (expectRGB ? 1 : config.getSizeC());
                    String expectedMD5 = config.getMD5();
                    int x = convertedReader.getSizeX();
                    int y = convertedReader.getSizeY();
                    int count = convertedReader.getImageCount();
                    boolean rgb = convertedReader.isRGB();
                    int pixelType = convertedReader.getPixelType();
                    boolean isQuicktime = TestTools.shortClassName(writer).equals("QTWriter");
                    String md5 = TestTools.md5(convertedReader.openBytes(0));
                    if (msg == null) {
                        msg = FormatWriterTest.checkMismatch(x, expectedX, series, "X");
                    }
                    if (msg == null) {
                        msg = FormatWriterTest.checkMismatch(y, expectedY, series, "Y");
                    }
                    if (msg == null && writer.canDoStacks() && !imageMatch) {
                        msg = FormatWriterTest.checkMismatch(count, expectedCount, series, "Image count");
                    }
                    if (msg == null && !isQuicktime) {
                        msg = FormatWriterTest.checkMismatch(rgb, expectRGB, series, "RGB");
                    }
                    if (msg == null && !isQuicktime) {
                        msg = FormatWriterTest.checkMismatch(pixelType, expectedPixelType, series, "Pixel type");
                    }
                    if (msg == null && FormatWriterTest.isLosslessWriter(writer) && config.isRGB() == expectRGB) {
                        msg = FormatWriterTest.checkMismatch(md5, expectedMD5, series, "Pixels hash");
                    }
                    boolean bl2 = success = msg == null;
                    if (!success) break;
                }
            }
            convertedReader.close();
        }
        catch (Throwable t) {
            LOGGER.info("", t);
            success = false;
        }
        FormatWriterTest.result(testName, success, msg);
    }

    private static String checkMismatch(boolean i1, boolean i2, int series, String label) {
        return FormatWriterTest.checkMismatch(String.valueOf(i1), String.valueOf(i2), series, label);
    }

    private static String checkMismatch(int i1, int i2, int series, String label) {
        return FormatWriterTest.checkMismatch(String.valueOf(i1), String.valueOf(i2), series, label);
    }

    private static String checkMismatch(String s1, String s2, int series, String label) {
        if (s1.equals(s2)) {
            return null;
        }
        return label + " mismatch [got " + s1 + ", expected " + s2 + "] in series " + series;
    }

    private static void result(String testName, boolean success, String msg) {
        LOGGER.info("\t{}: {} ({})", new Object[]{testName, success ? "PASSED" : "FAILED", msg == null ? "" : msg});
        if (msg == null) {
            assert (success);
        } else assert (success) : msg;
    }

    private static boolean isLosslessWriter(IFormatWriter writer) {
        if (writer instanceof JPEGWriter || writer instanceof JPEG2000Writer) {
            return false;
        }
        String compression = writer.getCompression();
        if (compression != null) {
            compression = compression.toLowerCase();
        }
        return compression == null || compression.equals("lzw") || compression.equals("zlib") || compression.equals("uncompressed");
    }

    static {
        skipFiles = new LinkedList();
        reader = new BufferedImageReader();
        convertedReader = new BufferedImageReader();
    }
}

