/*
 * Decompiled with CFR 0.152.
 */
package loci.tests.testng;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import loci.common.DebugTools;
import loci.tests.testng.Configuration;
import loci.tests.testng.ConfigurationTree;
import loci.tests.testng.TestTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportEnabledStatus {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportEnabledStatus.class);

    public void logConfiguredFiles(String dataDir, String configDir, boolean enabled) throws IOException {
        ArrayList files = new ArrayList();
        String[] validSubdirs = null;
        if (dataDir == null) {
            LOGGER.error("No data directory specified.");
            return;
        }
        File baseDirFile = new File(dataDir);
        if (!baseDirFile.isDirectory()) {
            LOGGER.info("Directory: {}", (Object)dataDir);
            LOGGER.info("  exists?: {}", (Object)baseDirFile.exists());
            LOGGER.info("  readable?: {}", (Object)baseDirFile.canRead());
            LOGGER.info("  is a directory?: {}", (Object)baseDirFile.isDirectory());
            return;
        }
        ConfigurationTree configTree = new ConfigurationTree(dataDir, configDir, null);
        System.out.println("Scanning for files...");
        long start = System.currentTimeMillis();
        try {
            TestTools.getFiles(dataDir, files, configTree, configDir, validSubdirs, "", false);
        }
        catch (Exception e) {
            LOGGER.info("Failed to retrieve complete list of files", (Throwable)e);
        }
        long end = System.currentTimeMillis();
        double time = (double)(end - start) / 1000.0;
        LOGGER.info("----------------------------------------");
        LOGGER.info("Total files: {}", (Object)files.size());
        long avg = end - start;
        if (files.size() > 0) {
            avg /= (long)files.size();
        }
        LOGGER.info("Scan time: {} s ({} ms/file)", (Object)time, (Object)avg);
        LOGGER.info("----------------------------------------");
        LinkedHashSet<String> fileSet = new LinkedHashSet<String>();
        for (String s : files) {
            String canonicalPath;
            try {
                canonicalPath = new File(s).getCanonicalPath();
            }
            catch (IOException e) {
                LOGGER.warn("Could not get canonical path for {}", (Object)s);
                canonicalPath = s;
            }
            if (fileSet.contains(canonicalPath)) continue;
            Configuration conf = configTree.get(canonicalPath);
            if (conf != null && conf.doTest() == enabled && (enabled || conf.getTestComment() == null)) {
                System.out.println(canonicalPath);
            }
            fileSet.add(canonicalPath);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0 || args[0].equals("--help")) {
            System.out.println("bf-unconfigured data_dir configuration_dir [--enabled]");
            System.out.println();
            System.out.println("  --enabled: print a list of files that are configured and tested");
        }
        DebugTools.enableLogging((String)"INFO");
        ReportEnabledStatus status = new ReportEnabledStatus();
        String data = null;
        String config = null;
        boolean enabled = false;
        String msg = null;
        for (String arg : args) {
            if (arg.equals("--enabled")) {
                enabled = true;
                continue;
            }
            if (data == null) {
                data = arg;
                continue;
            }
            if (config == null) {
                config = arg;
                continue;
            }
            msg = "Unexpected argument: " + arg;
            break;
        }
        if (data == null) {
            msg = "Data directory not specified";
        } else if (config == null) {
            msg = "Configuration directory not specified";
        }
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        status.logConfiguredFiles(data, config, enabled);
    }
}

