/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.IOException;
import loci.common.Location;
import loci.formats.ChannelFiller;
import loci.formats.ChannelMerger;
import loci.formats.ChannelSeparator;
import loci.formats.DimensionSwapper;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MinMaxCalculator;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class ReaderEqualityTest {
    private static final String TEST_FILE_A = "A&pixelType=uint8&sizeX=128&sizeY=64&sizeC=2&sizeZ=4&sizeT=5&series=3.fake";
    private static final String TEST_FILE_B = "B&pixelType=uint8&sizeX=128&sizeY=64&sizeC=2&sizeZ=4&sizeT=5&series=2.fake";

    @DataProvider(name="equalWrappers")
    public Object[][] createEqualWrappers() {
        Location.mapId((String)TEST_FILE_A, (String)TEST_FILE_A);
        Location.mapId((String)TEST_FILE_B, (String)TEST_FILE_B);
        Object[][] wrappers = new Object[][]{{new ImageReader(), new ImageReader()}, {new ImageReader(), new ImageReader()}, {new MinMaxCalculator((IFormatReader)new ChannelSeparator((IFormatReader)new ChannelFiller())), new MinMaxCalculator((IFormatReader)new ChannelSeparator((IFormatReader)new ChannelFiller()))}, {new DimensionSwapper((IFormatReader)new ChannelMerger()), new DimensionSwapper((IFormatReader)new ChannelMerger())}};
        for (int i = 1; i < wrappers.length; ++i) {
            IFormatReader readerA = (IFormatReader)wrappers[i][0];
            IFormatReader readerB = (IFormatReader)wrappers[i][1];
            try {
                readerA.setId(TEST_FILE_A);
                readerB.setId(TEST_FILE_B);
                continue;
            }
            catch (FormatException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrappers;
    }

    @DataProvider(name="unequalWrappers")
    public Object[][] createUnequalWrappers() {
        Object[][] wrappers = new Object[][]{{new ImageReader(), new ImageReader()}, {new ImageReader(), new ImageReader()}, {new MinMaxCalculator((IFormatReader)new ChannelSeparator((IFormatReader)new ChannelFiller())), new MinMaxCalculator((IFormatReader)new ChannelSeparator())}, {new DimensionSwapper((IFormatReader)new ChannelMerger()), new DimensionSwapper((IFormatReader)new ChannelMerger())}};
        for (int i = 0; i < wrappers.length; ++i) {
            IFormatReader readerA = (IFormatReader)wrappers[i][0];
            IFormatReader readerB = (IFormatReader)wrappers[i][1];
            try {
                if (i != 1) {
                    readerA.setId(TEST_FILE_A);
                } else {
                    readerA.setId(TEST_FILE_B);
                }
                if (i > 1) {
                    readerB.setId(TEST_FILE_B);
                    continue;
                }
                if (i != 1) continue;
                readerB.setId(TEST_FILE_A);
                continue;
            }
            catch (FormatException e) {
                e.printStackTrace();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return wrappers;
    }

    @Test(dataProvider="equalWrappers")
    public void testEquality(IFormatReader[] readers) {
        if (readers.length == 2) {
            AssertJUnit.assertTrue((boolean)FormatTools.equalReaders((IFormatReader)readers[0], (IFormatReader)readers[1]));
        }
    }

    @Test(dataProvider="unequalWrappers")
    public void testInequality(IFormatReader[] readers) {
        if (readers.length == 2) {
            AssertJUnit.assertFalse((boolean)FormatTools.equalReaders((IFormatReader)readers[0], (IFormatReader)readers[1]));
        }
    }
}

