/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.out;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import loci.formats.FormatException;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.MetadataOptions;
import loci.formats.in.OMETiffReader;
import loci.formats.in.TiffReader;
import loci.formats.meta.IMetadata;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.OMETiffWriter;
import loci.formats.tiff.IFD;
import loci.formats.utests.out.Plane;
import loci.formats.utests.out.WriterUtilities;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class OMETiffWriterTest {
    private OMETiffWriter writer;
    private IMetadata metadata;
    final long BIG_TIFF_CUTOFF = 4183818240L;
    private static final byte[] buf = new byte[0x100000];
    private static final int TILE_GRANULARITY = 16;
    private static int percentageOfTilingTests = 0;
    private static int percentageOfSaveBytesTests = 0;

    @DataProvider(name="bigTiffSuffixes")
    public Object[][] createSuffixes() {
        return new Object[][]{{"tf2"}, {"tf8"}, {"btf"}, {"tif"}, {"tiff"}};
    }

    @DataProvider(name="codecs")
    public Object[][] createCodecs() {
        return WriterUtilities.getCodecs();
    }

    @DataProvider(name="tiling")
    public Object[][] createTiling() {
        if (percentageOfTilingTests == 0) {
            return new Object[][]{{0, false, false, 0, 0, 0, null, 0, false}};
        }
        int[] tileSizes = new int[]{1, 32, 43, 64};
        int[] channelCounts = new int[]{1, 3};
        int[] seriesCounts = new int[]{1, 5};
        int[] timeCounts = new int[]{1};
        String[] compressions = new String[]{WriterUtilities.COMPRESSION_UNCOMPRESSED, WriterUtilities.COMPRESSION_LZW, WriterUtilities.COMPRESSION_J2K, WriterUtilities.COMPRESSION_J2K_LOSSY, WriterUtilities.COMPRESSION_JPEG};
        return WriterUtilities.getData(tileSizes, channelCounts, seriesCounts, timeCounts, compressions, percentageOfTilingTests);
    }

    @DataProvider(name="nonTiling")
    public Object[][] createNonTiling() {
        if (percentageOfSaveBytesTests == 0) {
            return new Object[][]{{0, false, false, 0, 0, 0, null, 0, false}};
        }
        int[] tileSizes = new int[]{160};
        int[] channelCounts = new int[]{1, 3};
        int[] seriesCounts = new int[]{1};
        int[] timeCounts = new int[]{1, 5};
        String[] compressions = new String[]{WriterUtilities.COMPRESSION_UNCOMPRESSED, WriterUtilities.COMPRESSION_LZW, WriterUtilities.COMPRESSION_J2K, WriterUtilities.COMPRESSION_J2K_LOSSY, WriterUtilities.COMPRESSION_JPEG};
        return WriterUtilities.getData(tileSizes, channelCounts, seriesCounts, timeCounts, compressions, percentageOfSaveBytesTests);
    }

    @BeforeClass
    public void readProperty() throws Exception {
        percentageOfTilingTests = WriterUtilities.getPropValue("testng.runWriterTilingTests");
        percentageOfSaveBytesTests = WriterUtilities.getPropValue("testng.runWriterSaveBytesTests");
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.writer = new OMETiffWriter();
        this.metadata = WriterUtilities.createMetadata();
        for (int i = 0; i < 0x100000; ++i) {
            OMETiffWriterTest.buf[i] = (byte)(i % 255);
        }
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.writer.close();
    }

    @Test
    public void testGetPlaneCount() throws IOException, FormatException {
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        this.writer.setSeries(0);
        Assert.assertEquals((int)80, (int)this.writer.getPlaneCount());
        this.metadata.setPixelsSizeC(new PositiveInteger(Integer.valueOf(4)), 0);
        this.metadata.setPixelsType(PixelType.INT16, 0);
        this.writer.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        Assert.assertEquals((int)320, (int)this.writer.getPlaneCount());
    }

    @Test(dataProvider="tiling")
    public void testSaveBytesTiling(int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        if (percentageOfTilingTests == 0) {
            return;
        }
        File tmp = File.createTempFile("OMETiffWriterTest_Tiling", ".ome.tiff");
        tmp.deleteOnExit();
        Plane originalPlane = WriterUtilities.writeImage(tmp, tileSize, littleEndian, interleaved, rgbChannels, seriesCount, sizeT, compression, pixelType, bigTiff);
        TiffReader reader = new TiffReader();
        reader.setId(tmp.getAbsolutePath());
        int expectedTileSize = tileSize;
        expectedTileSize = tileSize < 16 ? 16 : Math.round((float)tileSize / 16.0f) * 16;
        IFD tileIFd = (IFD)reader.getIFDs().get(0);
        Assert.assertEquals((int)tileIFd.getIFDIntValue(323), (int)expectedTileSize);
        Assert.assertEquals((int)tileIFd.getIFDIntValue(322), (int)expectedTileSize);
        WriterUtilities.checkImage(reader, originalPlane, interleaved, rgbChannels, seriesCount, sizeT, compression);
        tmp.delete();
        reader.close();
    }

    @Test(dataProvider="nonTiling")
    public void testSaveBytes(int tileSize, boolean littleEndian, boolean interleaved, int rgbChannels, int seriesCount, int sizeT, String compression, int pixelType, boolean bigTiff) throws Exception {
        if (percentageOfSaveBytesTests == 0) {
            return;
        }
        File tmp = File.createTempFile("OMETiffWriterTest", ".ome.tiff");
        tmp.deleteOnExit();
        Plane originalPlane = WriterUtilities.writeImage(tmp, tileSize, littleEndian, interleaved, rgbChannels, seriesCount, sizeT, compression, pixelType, bigTiff);
        TiffReader reader = new TiffReader();
        reader.setId(tmp.getAbsolutePath());
        WriterUtilities.checkImage(reader, originalPlane, interleaved, rgbChannels, seriesCount, sizeT, compression);
        tmp.delete();
        reader.close();
    }

    @Test
    public void testCompanion() throws Exception {
        Path wd = Files.createTempDirectory(this.getClass().getName(), new FileAttribute[0]);
        File outFile = wd.resolve("test.ome.tif").toFile();
        File cFile = wd.resolve("test.companion.ome").toFile();
        String companion = cFile.getAbsolutePath();
        DynamicMetadataOptions options = new DynamicMetadataOptions();
        options.set("ometiff.companion", companion);
        int planeCount = 80;
        OMETiffWriter cwriter = new OMETiffWriter();
        cwriter.setMetadataOptions((MetadataOptions)options);
        cwriter.setMetadataRetrieve((MetadataRetrieve)this.metadata);
        cwriter.setId(outFile.getAbsolutePath());
        cwriter.setSeries(0);
        byte[] img = new byte[0x100000];
        for (int i = 0; i < planeCount; ++i) {
            cwriter.saveBytes(i, img);
        }
        cwriter.close();
        Assert.assertTrue((boolean)cFile.exists());
        OMETiffReader reader = new OMETiffReader();
        reader.setId(companion);
        Assert.assertEquals((int)reader.getSizeX(), (int)1024);
        Assert.assertEquals((int)reader.getSizeY(), (int)1024);
        Assert.assertEquals((int)reader.getSizeZ(), (int)4);
        Assert.assertEquals((int)reader.getSizeC(), (int)1);
        Assert.assertEquals((int)reader.getSizeT(), (int)20);
        reader.close();
        outFile.deleteOnExit();
        cFile.deleteOnExit();
        wd.toFile().deleteOnExit();
    }
}

