/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import loci.formats.tiff.IFD;
import loci.formats.utests.tiff.BaseTiffReaderMock;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class BaseTiffReaderTest {
    private IFD ifd;
    private BaseTiffReaderMock reader;

    @BeforeClass
    public void setUp() throws Exception {
        this.ifd = new IFD();
        this.reader = new BaseTiffReaderMock();
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.ifd.clear();
        this.reader.clearIFDs();
    }

    @Test
    public void testCreationDateString() {
        this.ifd.put((Object)306, (Object)"CreationDate");
        this.reader.addIFD(this.ifd);
        AssertJUnit.assertEquals((String)"CreationDate", (String)this.reader.getCreationDate());
    }

    @Test
    public void testCreationDateNull() {
        this.ifd.put((Object)306, null);
        this.reader.addIFD(this.ifd);
        AssertJUnit.assertEquals(null, (String)this.reader.getCreationDate());
    }

    @Test
    public void testCreationDateEmptyString() {
        this.ifd.put((Object)306, (Object)"");
        this.reader.addIFD(this.ifd);
        AssertJUnit.assertEquals((String)"", (String)this.reader.getCreationDate());
    }

    @Test
    public void testCreationDateStringArray() {
        String[] creationDates = new String[]{"CreationDate1", "CreationDate2"};
        this.ifd.put((Object)306, (Object)creationDates);
        this.reader.addIFD(this.ifd);
        AssertJUnit.assertEquals((String)"CreationDate1", (String)this.reader.getCreationDate());
    }

    @Test
    public void testCreationDateEmptyStringArray() {
        String[] creationDates = new String[]{""};
        this.ifd.put((Object)306, (Object)creationDates);
        this.reader.addIFD(this.ifd);
        AssertJUnit.assertEquals((String)"", (String)this.reader.getCreationDate());
    }

    @Test
    public void testCreationDateNullStringArray() {
        String[] creationDates = new String[]{null};
        this.ifd.put((Object)306, (Object)creationDates);
        this.reader.addIFD(this.ifd);
        AssertJUnit.assertEquals(null, (String)this.reader.getCreationDate());
    }

    @Test
    public void testCreationDateZeroLengthArray() {
        String[] creationDates = new String[]{};
        this.ifd.put((Object)306, (Object)creationDates);
        this.reader.addIFD(this.ifd);
        AssertJUnit.assertEquals(null, (String)this.reader.getCreationDate());
    }

    @Test
    public void testCreationDateMultipleIFDs() {
        this.ifd.put((Object)306, (Object)"CreationDate1");
        this.reader.addIFD(this.ifd);
        IFD ifd2 = new IFD();
        ifd2.put((Object)306, (Object)"CreationDate2");
        this.reader.addIFD(ifd2);
        AssertJUnit.assertEquals((String)"CreationDate1", (String)this.reader.getCreationDate());
    }
}

