/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import loci.formats.FormatException;
import loci.formats.IFormatReader;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.IMetadata;
import loci.formats.meta.IPyramidStore;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.out.PyramidOMETiffWriter;
import loci.formats.tiff.IFD;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PyramidTest {
    private static final int RESOLUTION_COUNT = 4;
    private static final int EXTRA_WIDTH = 9;
    private static final int EXTRA_HEIGHT = 3;
    private static final int TILE_SIZE = 1;
    private static final int SCALE = 2;
    private File[] files = new File[9];

    @BeforeClass
    public void setUp() throws Exception {
        for (int i = 0; i < this.files.length; ++i) {
            this.files[i] = File.createTempFile("PyramidTest", ".ome.tiff");
        }
    }

    @AfterClass
    public void tearDown() throws Exception {
        for (File f : this.files) {
            f.delete();
        }
    }

    @Test
    public void testSinglePyramid() throws FormatException, IOException {
        this.writePyramid(this.files[0].getAbsolutePath(), new int[]{8}, new int[]{8}, 1, 0, false, false);
        try (IFormatReader reader = this.getReader(0);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)1);
            AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    @Test
    public void testSinglePyramidBigTiff() throws FormatException, IOException {
        this.writePyramid(this.files[1].getAbsolutePath(), new int[]{8}, new int[]{8}, 1, 0, false, true);
        try (IFormatReader reader = this.getReader(1);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)1);
            AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    @Test
    public void testSinglePyramidBigEndian() throws FormatException, IOException {
        this.writePyramid(this.files[2].getAbsolutePath(), new int[]{8}, new int[]{8}, 1, 0, true, false);
        try (IFormatReader reader = this.getReader(2);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)1);
            AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    @Test
    public void testSinglePyramidBigEndianBigTiff() throws FormatException, IOException {
        this.writePyramid(this.files[3].getAbsolutePath(), new int[]{8}, new int[]{8}, 1, 0, true, true);
        try (IFormatReader reader = this.getReader(3);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)1);
            AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    @Test
    public void testSinglePyramidWithExtra() throws FormatException, IOException {
        this.writePyramid(this.files[4].getAbsolutePath(), new int[]{16}, new int[]{16}, 1, 2, false, true);
        try (IFormatReader reader = this.getReader(4);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)3);
            AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
            AssertJUnit.assertEquals((int)reader.getSizeX(), (int)16);
            AssertJUnit.assertEquals((int)reader.getSizeY(), (int)16);
            reader.setSeries(1);
            AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)1);
            AssertJUnit.assertEquals((int)reader.getSizeX(), (int)9);
            AssertJUnit.assertEquals((int)reader.getSizeY(), (int)3);
            reader.setSeries(2);
            AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)1);
            AssertJUnit.assertEquals((int)reader.getSizeX(), (int)9);
            AssertJUnit.assertEquals((int)reader.getSizeY(), (int)3);
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    @Test
    public void testSinglePyramidMultiplePlanes() throws FormatException, IOException {
        this.writePyramid(this.files[5].getAbsolutePath(), new int[]{16}, new int[]{16}, 3, 0, false, true);
        try (IFormatReader reader = this.getReader(5);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)1);
            AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
            AssertJUnit.assertEquals((int)reader.getSizeX(), (int)16);
            AssertJUnit.assertEquals((int)reader.getSizeY(), (int)16);
            for (int i = 0; i < 4; ++i) {
                reader.setResolution(i);
                AssertJUnit.assertEquals((int)reader.getSizeZ(), (int)3);
            }
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiplePyramids() throws FormatException, IOException {
        int[] dims = new int[]{16, 10};
        this.writePyramid(this.files[6].getAbsolutePath(), dims, dims, 1, 0, false, true);
        try (IFormatReader reader = this.getReader(6);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)2);
            for (int s = 0; s < reader.getSeriesCount(); ++s) {
                reader.setSeries(s);
                AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
                AssertJUnit.assertEquals((int)reader.getSizeX(), (int)dims[s]);
                AssertJUnit.assertEquals((int)reader.getSizeY(), (int)dims[s]);
                AssertJUnit.assertEquals((int)reader.getSizeZ(), (int)1);
            }
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiplePyramidsExtra() throws FormatException, IOException {
        int[] dims = new int[]{8, 10};
        this.writePyramid(this.files[7].getAbsolutePath(), dims, dims, 1, 2, false, true);
        try (IFormatReader reader = this.getReader(7);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)4);
            for (int s = 0; s < reader.getSeriesCount(); ++s) {
                reader.setSeries(s);
                if (s < dims.length) {
                    AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
                    AssertJUnit.assertEquals((int)reader.getSizeX(), (int)dims[s]);
                    AssertJUnit.assertEquals((int)reader.getSizeY(), (int)dims[s]);
                } else {
                    AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)1);
                    AssertJUnit.assertEquals((int)reader.getSizeX(), (int)9);
                    AssertJUnit.assertEquals((int)reader.getSizeY(), (int)3);
                }
                AssertJUnit.assertEquals((int)reader.getSizeZ(), (int)1);
            }
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiplePyramidsMultiplePlanes() throws FormatException, IOException {
        int[] dims = new int[]{8, 10};
        this.writePyramid(this.files[8].getAbsolutePath(), dims, dims, 2, 0, false, true);
        try (IFormatReader reader = this.getReader(8);){
            AssertJUnit.assertEquals((int)reader.getSeriesCount(), (int)2);
            for (int s = 0; s < reader.getSeriesCount(); ++s) {
                reader.setSeries(s);
                AssertJUnit.assertEquals((int)reader.getResolutionCount(), (int)4);
                AssertJUnit.assertEquals((int)reader.getSizeX(), (int)dims[s]);
                AssertJUnit.assertEquals((int)reader.getSizeY(), (int)dims[s]);
                AssertJUnit.assertEquals((int)reader.getSizeZ(), (int)2);
            }
            AssertJUnit.assertTrue((boolean)this.checkPixels(reader));
        }
    }

    private IFormatReader getReader(int index) throws FormatException, IOException {
        ImageReader reader = new ImageReader();
        reader.setFlattenedResolutions(false);
        reader.setId(this.files[index].getAbsolutePath());
        return reader;
    }

    private boolean checkPixels(IFormatReader reader) throws FormatException, IOException {
        int index = 1;
        for (int s = 0; s < reader.getSeriesCount(); ++s) {
            reader.setSeries(s);
            for (int r = 0; r < reader.getResolutionCount(); ++r) {
                reader.setResolution(r);
                for (int p = 0; p < reader.getImageCount(); ++p) {
                    byte[] plane;
                    for (byte pixel : plane = reader.openBytes(p)) {
                        if ((pixel & 0xFF) == index) continue;
                        return false;
                    }
                    ++index;
                }
            }
        }
        return true;
    }

    private void writePyramid(String file, int[] widths, int[] heights, int planes, int extra, boolean bigEndian, boolean bigTiff) throws FormatException, IOException {
        int p;
        IMetadata meta = MetadataTools.createOMEXMLMetadata();
        if (!(meta instanceof IPyramidStore)) {
            throw new FormatException("MetadataStore is not an IPyramidStore; cannot write pyramid");
        }
        for (p = 0; p < widths.length; ++p) {
            this.populateImage(meta, p, widths[p], heights[p], planes, bigEndian);
            for (int r = 1; r < 4; ++r) {
                int scale = (int)Math.pow(2.0, r);
                ((IPyramidStore)meta).setResolutionSizeX(new PositiveInteger(Integer.valueOf(widths[p] / scale)), p, r);
                ((IPyramidStore)meta).setResolutionSizeY(new PositiveInteger(Integer.valueOf(heights[p] / scale)), p, r);
            }
        }
        for (p = widths.length; p < widths.length + extra; ++p) {
            this.populateImage(meta, p, 9, 3, planes, bigEndian);
        }
        PyramidOMETiffWriter writer = new PyramidOMETiffWriter();
        writer.setBigTiff(bigTiff);
        writer.setWriteSequentially(true);
        writer.setMetadataRetrieve((MetadataRetrieve)meta);
        writer.setId(file);
        int index = 1;
        for (int p2 = 0; p2 < widths.length; ++p2) {
            writer.setSeries(p2);
            for (int r = 0; r < 4; ++r) {
                writer.setResolution(r);
                int scale = (int)Math.pow(2.0, r);
                int width = widths[p2] / scale;
                int height = heights[p2] / scale;
                for (int plane = 0; plane < planes; ++plane) {
                    byte[] tile = new byte[]{(byte)index++};
                    IFD ifd = new IFD();
                    ifd.put((Object)322, (Object)1);
                    ifd.put((Object)323, (Object)1);
                    for (int yy = 0; yy < height; ++yy) {
                        for (int xx = 0; xx < width; ++xx) {
                            writer.saveBytes(plane, tile, ifd, xx, yy, 1, 1);
                        }
                    }
                }
            }
        }
        for (int e = 0; e < extra; ++e) {
            writer.setSeries(widths.length + e);
            for (int plane = 0; plane < planes; ++plane) {
                byte[] extraPlane = new byte[27];
                Arrays.fill(extraPlane, (byte)index++);
                writer.saveBytes(plane, extraPlane);
            }
        }
        writer.close();
    }

    private void populateImage(IMetadata meta, int p, int width, int height, int planes, boolean bigEndian) {
        meta.setImageID("Image:" + p, p);
        meta.setPixelsID("Pixels:" + p, p);
        meta.setPixelsDimensionOrder(DimensionOrder.XYZCT, p);
        meta.setPixelsSizeX(new PositiveInteger(Integer.valueOf(width)), p);
        meta.setPixelsSizeY(new PositiveInteger(Integer.valueOf(height)), p);
        meta.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(planes)), p);
        meta.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), p);
        meta.setPixelsSizeT(new PositiveInteger(Integer.valueOf(1)), p);
        meta.setPixelsType(PixelType.UINT8, p);
        meta.setPixelsBigEndian(Boolean.valueOf(bigEndian), p);
        meta.setChannelID("Channel:" + p + ":0", p, 0);
        meta.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), p, 0);
    }
}

