/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.FormatException;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffParser;
import loci.formats.tiff.TiffSaver;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TiffSaverTest {
    private RandomAccessOutputStream out;
    private RandomAccessInputStream in;
    private TiffSaver tiffSaver;
    private TiffParser tiffParser;
    private IFD ifd;
    private static final int INITIAL_CAPACITY = 0x100000;

    @BeforeMethod
    public void setUp() throws IOException {
        ByteArrayHandle handle = new ByteArrayHandle(0x100000);
        this.out = new RandomAccessOutputStream((IRandomAccess)handle);
        this.in = new RandomAccessInputStream((IRandomAccess)handle);
        this.tiffSaver = new TiffSaver(this.out, handle);
        this.tiffParser = new TiffParser(this.in);
        this.ifd = new IFD();
        this.ifd.putIFDValue(256, 512);
        this.ifd.putIFDValue(270, (Object)"comment");
    }

    @AfterMethod
    public void tearDown() throws IOException {
        this.in.close();
        this.out.close();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullOutputStream() throws IOException {
        RandomAccessOutputStream a = null;
        String b = null;
        this.tiffSaver = new TiffSaver(a, b);
        this.tiffSaver.writeHeader();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullFilename() throws IOException {
        RandomAccessOutputStream a = new RandomAccessOutputStream((IRandomAccess)new ByteArrayHandle());
        String b = null;
        this.tiffSaver = new TiffSaver(a, b);
        this.tiffSaver.writeHeader();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testNullBytes() throws IOException {
        RandomAccessOutputStream a = new RandomAccessOutputStream((IRandomAccess)new ByteArrayHandle());
        ByteArrayHandle b = null;
        this.tiffSaver = new TiffSaver(a, b);
        this.tiffSaver.writeHeader();
    }

    @Test
    public void testWriteHeaderBigEndianRegularTiff() throws IOException {
        this.tiffSaver.writeHeader();
        AssertJUnit.assertTrue((boolean)this.tiffParser.isValidHeader());
        AssertJUnit.assertFalse((boolean)this.tiffParser.checkHeader());
        AssertJUnit.assertFalse((boolean)this.tiffParser.isBigTiff());
    }

    @Test
    public void testWriteHeaderLittleEndianRegularTiff() throws IOException {
        this.tiffSaver.setLittleEndian(true);
        this.tiffSaver.writeHeader();
        AssertJUnit.assertTrue((boolean)this.tiffParser.isValidHeader());
        AssertJUnit.assertTrue((boolean)this.tiffParser.checkHeader());
        AssertJUnit.assertFalse((boolean)this.tiffParser.isBigTiff());
    }

    @Test
    public void testWriteHeaderBigEndianBigTiff() throws IOException {
        this.tiffSaver.setLittleEndian(false);
        this.tiffSaver.setBigTiff(true);
        this.tiffSaver.writeHeader();
        AssertJUnit.assertTrue((boolean)this.tiffParser.isValidHeader());
        AssertJUnit.assertFalse((boolean)this.tiffParser.checkHeader());
        AssertJUnit.assertTrue((boolean)this.tiffParser.isBigTiff());
    }

    @Test
    public void testWriteHeaderLittleEndianBigTiff() throws IOException {
        this.tiffSaver.setLittleEndian(true);
        this.tiffSaver.setBigTiff(true);
        this.tiffSaver.writeHeader();
        AssertJUnit.assertTrue((boolean)this.tiffParser.isValidHeader());
        AssertJUnit.assertTrue((boolean)this.tiffParser.checkHeader());
        AssertJUnit.assertTrue((boolean)this.tiffParser.isBigTiff());
    }

    @Test
    public void testOverwriteIFDValue() throws FormatException, IOException {
        this.out.seek(0L);
        this.tiffSaver.setBigTiff(false);
        this.tiffSaver.writeHeader();
        this.tiffSaver.writeIFD(this.ifd, 0L);
        this.tiffSaver.overwriteIFDValue(this.in, 0, 256, (Object)1024);
        AssertJUnit.assertEquals((long)1024L, (long)this.tiffParser.getFirstIFD().getImageWidth());
    }

    @Test
    public void testOverwriteComment() throws FormatException, IOException {
        this.out.seek(0L);
        this.tiffSaver.writeHeader();
        this.tiffSaver.writeIFD(this.ifd, 0L);
        this.tiffSaver.overwriteComment(this.in, (Object)"new comment");
        AssertJUnit.assertTrue((boolean)"new comment".equals(this.tiffParser.getComment()));
    }

    @Test
    public void testOverwriteCommentEqualLength() throws FormatException, IOException {
        this.out.seek(0L);
        this.tiffSaver.writeHeader();
        this.tiffSaver.writeIFD(this.ifd, 46L);
        this.tiffSaver.writeIFD(this.ifd, 0L);
        this.tiffSaver.overwriteComment(this.in, (Object)"COMMENT");
        AssertJUnit.assertEquals((String)"COMMENT", (String)this.tiffParser.getComment());
        AssertJUnit.assertEquals((String)"comment", (String)((IFD)this.tiffParser.getIFDs().get(1)).getIFDTextValue(270));
    }
}

