/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.IOException;
import loci.common.ByteArrayHandle;
import loci.common.IRandomAccess;
import loci.common.RandomAccessInputStream;
import loci.common.RandomAccessOutputStream;
import loci.formats.out.TiffWriter;
import loci.formats.tiff.TiffSaver;
import loci.formats.utests.tiff.ByteArrayHandleMock;

public class TiffWriterMock
extends TiffWriter {
    private static final int INITIAL_CAPACITY = 0x100000;
    private ByteArrayHandle handle = new ByteArrayHandle(0x100000);

    public TiffWriterMock() {
    }

    public TiffWriterMock(String format, String[] exts) {
        super(format, exts);
    }

    protected RandomAccessOutputStream createOutputStream() throws IOException {
        return new RandomAccessOutputStream((IRandomAccess)this.handle);
    }

    protected RandomAccessInputStream createInputStream() throws IOException {
        return new RandomAccessInputStream((IRandomAccess)this.handle);
    }

    protected TiffSaver createTiffSaver() {
        return new TiffSaver(this.out, this.handle);
    }

    public void createOutputBuffer(boolean mock) throws IOException {
        this.handle = mock ? new ByteArrayHandleMock(0x100000) : new ByteArrayHandle(0x100000);
    }

    public void setBufferLength(long length) throws IOException {
        this.handle.setLength(length);
    }
}

