/*
 * Decompiled with CFR 0.152.
 */
package spec;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"all"})
public class AbstractTest {
    public static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    public static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    public static final String OME_FORMAT = "ome";
    public static final String OME_XML_FORMAT = "ome.xml";
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected String rootpass;

    protected String sha1(byte[] data, int offset, int len) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        md.update(data, offset, len);
        return AbstractTest.byteArrayToHexString(md.digest());
    }

    protected String sha1(byte[] data) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Required SHA-1 message digest algorithm unavailable.");
        }
        md.update(data);
        return AbstractTest.byteArrayToHexString(md.digest());
    }

    public static String byteArrayToHexString(byte[] in) {
        byte ch = 0;
        if (in == null || in.length <= 0) {
            return null;
        }
        String[] pseudo = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        StringBuffer out = new StringBuffer(in.length * 2);
        for (int i = 0; i < in.length; ++i) {
            ch = (byte)(in[i] & 0xF0);
            ch = (byte)(ch >>> 4);
            ch = (byte)(ch & 0xF);
            out.append(pseudo[ch]);
            ch = (byte)(in[i] & 0xF);
            out.append(pseudo[ch]);
        }
        String rslt = new String(out);
        return rslt;
    }

    @BeforeClass
    protected void setUp() throws Exception {
    }

    @AfterClass
    public void tearDown() throws Exception {
    }

    protected void clean() throws Exception {
    }

    protected void transformFile(File input, File output, File xslt) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("No file to transform.");
        }
        if (output == null) {
            throw new IllegalArgumentException("No destination file.");
        }
        if (xslt == null) {
            throw new IllegalArgumentException("No stylesheet provided.");
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(xslt));
        StreamResult result = new StreamResult(new FileOutputStream(output));
        transformer.transform(new StreamSource(input), result);
    }

    protected void transformFileWithStream(File input, File output, InputStream xslt) throws Exception {
        if (input == null) {
            throw new IllegalArgumentException("No file to transform.");
        }
        if (output == null) {
            throw new IllegalArgumentException("No destination file.");
        }
        if (xslt == null) {
            throw new IllegalArgumentException("No stylesheet provided.");
        }
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer(new StreamSource(xslt));
        StreamResult result = new StreamResult(new FileOutputStream(output));
        transformer.transform(new StreamSource(input), result);
    }
}

