/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.IOException;
import java.security.MessageDigest;
import loci.common.DataTools;
import loci.formats.FormatException;
import loci.formats.in.DeltavisionReader;
import loci.formats.in.MetadataLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class DeltavisionMetadataConfigurableTest {
    private static final String ID = "/Users/callan/testimages/tinyTest.d3d.dv";
    private static final String ALL_ONLY_KEY = "Image Type";
    private static final String ALL_ONLY_VALUE = "normal";
    private DeltavisionReader pixelsOnly;
    private DeltavisionReader all;

    @BeforeClass
    public void setUp() {
        this.pixelsOnly = new DeltavisionReader();
        this.pixelsOnly.getMetadataOptions().setMetadataLevel(MetadataLevel.MINIMUM);
        this.all = new DeltavisionReader();
        this.all.getMetadataOptions().setMetadataLevel(MetadataLevel.ALL);
    }

    @Test
    public void testSetId() throws FormatException, IOException {
        long t0 = System.currentTimeMillis();
        this.pixelsOnly.setId(ID);
        AssertJUnit.assertEquals((Object)MetadataLevel.MINIMUM, (Object)this.pixelsOnly.getMetadataOptions().getMetadataLevel());
        AssertJUnit.assertNull(this.pixelsOnly.getSeriesMetadata().get(ALL_ONLY_KEY));
        long t1 = System.currentTimeMillis();
        this.all.setId(ID);
        AssertJUnit.assertEquals((Object)MetadataLevel.ALL, (Object)this.all.getMetadataOptions().getMetadataLevel());
        AssertJUnit.assertEquals((Object)ALL_ONLY_VALUE, this.all.getGlobalMetadata().get(ALL_ONLY_KEY));
        long t2 = System.currentTimeMillis();
        System.err.println(String.format("Pixels only: %d -- All: %d", t1 - t0, t2 - t1));
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testDimensions() {
        AssertJUnit.assertEquals((int)this.all.getSeriesCount(), (int)this.pixelsOnly.getSeriesCount());
        AssertJUnit.assertEquals((int)this.all.getSizeX(), (int)this.pixelsOnly.getSizeX());
        AssertJUnit.assertEquals((int)this.all.getSizeY(), (int)this.pixelsOnly.getSizeY());
        AssertJUnit.assertEquals((int)this.all.getSizeZ(), (int)this.pixelsOnly.getSizeZ());
        AssertJUnit.assertEquals((int)this.all.getSizeC(), (int)this.pixelsOnly.getSizeC());
        AssertJUnit.assertEquals((int)this.all.getSizeT(), (int)this.pixelsOnly.getSizeT());
        AssertJUnit.assertEquals((int)this.all.getPixelType(), (int)this.pixelsOnly.getPixelType());
    }

    @Test(dependsOnMethods={"testSetId"})
    public void testPlaneData() throws FormatException, IOException {
        for (int i = 0; i < this.pixelsOnly.getSeriesCount(); ++i) {
            this.pixelsOnly.setSeries(i);
            this.all.setSeries(i);
            AssertJUnit.assertEquals((int)this.all.getImageCount(), (int)this.pixelsOnly.getImageCount());
            for (int j = 0; j < this.pixelsOnly.getImageCount(); ++j) {
                byte[] allPlane;
                String sha1AllPlane;
                byte[] pixelsOnlyPlane = this.pixelsOnly.openBytes(j);
                String sha1PixelsOnlyPlane = this.sha1(pixelsOnlyPlane);
                if (sha1PixelsOnlyPlane.equals(sha1AllPlane = this.sha1(allPlane = this.all.openBytes(j)))) continue;
                AssertJUnit.fail((String)String.format("MISMATCH: Series:%d Image:%d PixelsOnly:%s All:%s", i, j, sha1PixelsOnlyPlane, sha1AllPlane));
            }
        }
    }

    private String sha1(byte[] buf) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            return DataTools.bytesToHex((byte[])md.digest(buf));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

