/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.xml;

import java.io.IOException;
import java.io.InputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.services.OMEXMLService;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class OMEXMLServiceTest {
    private static final String XML_FILE = "2008-09.ome";
    private OMEXMLService service;
    private String xml;

    @BeforeMethod
    public void setUp() throws DependencyException, IOException {
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        InputStream s = OMEXMLServiceTest.class.getResourceAsStream(XML_FILE);
        byte[] b = new byte[s.available()];
        s.read(b);
        s.close();
        this.xml = new String(b);
    }

    @Test
    public void testGetLatestVersion() {
        AssertJUnit.assertEquals((String)"2016-06", (String)this.service.getLatestVersion());
    }

    @Test
    public void testCreateEmptyOMEXMLMetadata() throws ServiceException {
        AssertJUnit.assertNotNull((Object)this.service.createOMEXMLMetadata());
    }

    @Test
    public void testCreateOMEXMLMetadata() throws ServiceException {
        AssertJUnit.assertNotNull((Object)this.service.createOMEXMLMetadata(this.xml));
    }

    @Test
    public void testCreateOMEXMLRoot() throws ServiceException {
        AssertJUnit.assertNotNull((Object)this.service.createOMEXMLRoot(this.xml));
    }

    @Test
    public void isOMEXMLMetadata() throws ServiceException {
        AssertJUnit.assertEquals((boolean)true, (boolean)this.service.isOMEXMLMetadata((Object)this.service.createOMEXMLMetadata()));
    }

    @Test
    public void getOMEXMLVersion() throws ServiceException {
        AssertJUnit.assertEquals((String)"2008-09", (String)this.service.getOMEXMLVersion((Object)this.xml));
        AssertJUnit.assertEquals((String)"2016-06", (String)this.service.getOMEXMLVersion((Object)this.service.createOMEXMLMetadata(this.xml)));
    }

    @Test
    public void getOMEXML() throws ServiceException {
        AssertJUnit.assertNotNull((Object)this.service.getOMEXML((MetadataRetrieve)this.service.createOMEXMLMetadata(this.xml)));
    }

    @Test
    public void transformToLatestVersion() throws ServiceException {
        String updated = this.service.transformToLatestVersion(this.xml);
        AssertJUnit.assertEquals((String)"2016-06", (String)this.service.getOMEXMLVersion((Object)updated));
    }

    @Test(expectedExceptions={ServiceException.class})
    public void transformToLatestVersionBad() throws ServiceException {
        this.service.transformToLatestVersion("");
    }
}

