/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.xml;

import java.io.InputStream;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.OME;
import ome.xml.model.StructuredAnnotations;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class Upgrade201004Test {
    private static final String XML_FILE = "2010-04.ome";
    private OMEXMLService service;
    private String xml;
    private OMEXMLMetadata metadata;
    private OME ome;

    @BeforeMethod
    public void setUp() throws Exception {
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        InputStream s = Upgrade201004Test.class.getResourceAsStream(XML_FILE);
        byte[] b = new byte[s.available()];
        s.read(b);
        s.close();
        this.xml = new String(b);
        this.metadata = this.service.createOMEXMLMetadata(this.xml);
        this.ome = (OME)this.metadata.getRoot();
    }

    @Test
    public void getOMEXMLVersion() throws ServiceException {
        AssertJUnit.assertEquals((String)"2016-06", (String)this.service.getOMEXMLVersion((Object)this.metadata));
    }

    @Test
    public void validateUpgrade() throws ServiceException {
        AssertJUnit.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        StructuredAnnotations structuredAnnotations = this.ome.getStructuredAnnotations();
        AssertJUnit.assertNotNull((Object)structuredAnnotations);
        AssertJUnit.assertEquals((int)1, (int)structuredAnnotations.sizeOfCommentAnnotationList());
        CommentAnnotation commentAnnotation = structuredAnnotations.getCommentAnnotation(0);
        AssertJUnit.assertEquals((String)"StringAnnotation:0", (String)commentAnnotation.getID());
        AssertJUnit.assertEquals((String)"Transform", (String)commentAnnotation.getNamespace());
        AssertJUnit.assertEquals((String)"Foobar", (String)commentAnnotation.getValue());
    }
}

