/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.IFormatReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataStore;

public abstract class DelegateReader
extends FormatReader {
    protected boolean useLegacy;
    protected IFormatReader nativeReader;
    protected IFormatReader legacyReader;
    protected boolean nativeReaderInitialized;
    protected boolean legacyReaderInitialized;

    public DelegateReader(String format, String suffix) {
        super(format, suffix);
    }

    public DelegateReader(String format, String[] suffixes) {
        super(format, suffixes);
    }

    public void setLegacy(boolean legacy) {
        this.useLegacy = legacy;
    }

    public boolean isLegacy() {
        return this.useLegacy;
    }

    @Override
    public Set<MetadataLevel> getSupportedMetadataLevels() {
        return this.nativeReader.getSupportedMetadataLevels();
    }

    @Override
    public MetadataOptions getMetadataOptions() {
        return this.nativeReader.getMetadataOptions();
    }

    @Override
    public void setMetadataOptions(MetadataOptions options) {
        this.nativeReader.setMetadataOptions(options);
        this.legacyReader.setMetadataOptions(options);
    }

    @Override
    public boolean isThisType(String name, boolean open) {
        return this.nativeReader.isThisType(name, open);
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        return this.nativeReader.isThisType(stream);
    }

    @Override
    public void setSeries(int no) {
        super.setSeries(no);
        if (this.nativeReaderInitialized) {
            this.nativeReader.setSeries(no);
        }
        if (this.legacyReaderInitialized) {
            this.legacyReader.setSeries(no);
        }
    }

    @Override
    public void setCoreIndex(int no) {
        super.setCoreIndex(no);
        if (this.nativeReaderInitialized) {
            this.nativeReader.setCoreIndex(no);
        }
        if (this.legacyReaderInitialized) {
            this.legacyReader.setCoreIndex(no);
        }
    }

    @Override
    public void setResolution(int resolution) {
        super.setResolution(resolution);
        if (this.nativeReaderInitialized) {
            this.nativeReader.setResolution(resolution);
        }
        if (this.legacyReaderInitialized) {
            this.legacyReader.setResolution(resolution);
        }
    }

    @Override
    public void setNormalized(boolean normalize) {
        super.setNormalized(normalize);
        this.nativeReader.setNormalized(normalize);
        this.legacyReader.setNormalized(normalize);
    }

    @Override
    public void setOriginalMetadataPopulated(boolean populate) {
        super.setOriginalMetadataPopulated(populate);
        this.nativeReader.setOriginalMetadataPopulated(populate);
        this.legacyReader.setOriginalMetadataPopulated(populate);
    }

    @Override
    public void setGroupFiles(boolean group) {
        super.setGroupFiles(group);
        this.nativeReader.setGroupFiles(group);
        this.legacyReader.setGroupFiles(group);
    }

    @Override
    public void setFlattenedResolutions(boolean flattened) {
        super.setFlattenedResolutions(flattened);
        this.nativeReader.setFlattenedResolutions(flattened);
        this.legacyReader.setFlattenedResolutions(flattened);
    }

    @Override
    public void setMetadataFiltered(boolean filter) {
        super.setMetadataFiltered(filter);
        this.nativeReader.setMetadataFiltered(filter);
        this.legacyReader.setMetadataFiltered(filter);
    }

    @Override
    public void setMetadataStore(MetadataStore store) {
        super.setMetadataStore(store);
        this.nativeReader.setMetadataStore(store);
        this.legacyReader.setMetadataStore(store);
    }

    @Override
    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        if (this.callLegacyReader()) {
            return this.legacyReader.get8BitLookupTable();
        }
        return this.nativeReader.get8BitLookupTable();
    }

    @Override
    public short[][] get16BitLookupTable() throws FormatException, IOException {
        if (this.callLegacyReader()) {
            return this.legacyReader.get16BitLookupTable();
        }
        return this.nativeReader.get16BitLookupTable();
    }

    @Override
    public String[] getSeriesUsedFiles(boolean noPixels) {
        if (this.callLegacyReader()) {
            return this.legacyReader.getSeriesUsedFiles(noPixels);
        }
        return this.nativeReader.getSeriesUsedFiles(noPixels);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.callLegacyReader()) {
            return this.legacyReader.openBytes(no, buf, x, y, w, h);
        }
        return this.nativeReader.openBytes(no, buf, x, y, w, h);
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (this.nativeReader != null) {
            this.nativeReader.close(fileOnly);
        }
        if (this.legacyReader != null) {
            this.legacyReader.close(fileOnly);
        }
        if (!fileOnly) {
            this.legacyReaderInitialized = false;
            this.nativeReaderInitialized = false;
        }
    }

    @Override
    public int getOptimalTileWidth() {
        if (this.callLegacyReader()) {
            return this.legacyReader.getOptimalTileWidth();
        }
        return this.nativeReader.getOptimalTileWidth();
    }

    @Override
    public int getOptimalTileHeight() {
        if (this.callLegacyReader()) {
            return this.legacyReader.getOptimalTileHeight();
        }
        return this.nativeReader.getOptimalTileHeight();
    }

    @Override
    public void reopenFile() throws IOException {
        if (this.callLegacyReader()) {
            this.legacyReader.reopenFile();
        } else {
            this.nativeReader.reopenFile();
        }
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        if (this.useLegacy && !this.nativeReaderInitialized && !this.legacyReaderInitialized) {
            try {
                this.legacyReader.setId(id);
                this.legacyReaderInitialized = true;
                this.currentId = this.legacyReader.getCurrentFile();
            }
            catch (FormatException e) {
                LOGGER.debug("", (Throwable)e);
                this.nativeReader.setId(id);
                this.nativeReaderInitialized = true;
                this.currentId = this.nativeReader.getCurrentFile();
            }
        } else {
            Exception exc = null;
            try {
                this.nativeReader.setId(id);
                this.nativeReaderInitialized = true;
                this.currentId = this.nativeReader.getCurrentFile();
            }
            catch (FormatException e) {
                exc = e;
            }
            catch (IOException e) {
                exc = e;
            }
            if (exc != null) {
                this.nativeReaderInitialized = false;
                LOGGER.info("", (Throwable)exc);
                this.legacyReader.setId(id);
                this.legacyReaderInitialized = true;
                this.currentId = this.legacyReader.getCurrentFile();
            }
            if (this.legacyReaderInitialized) {
                this.nativeReaderInitialized = false;
            }
        }
        if (this.nativeReaderInitialized) {
            this.core = new ArrayList<CoreMetadata>(this.nativeReader.getCoreMetadataList());
            this.metadata = this.nativeReader.getGlobalMetadata();
            this.metadataStore = this.nativeReader.getMetadataStore();
        }
        if (this.legacyReaderInitialized) {
            this.core = new ArrayList<CoreMetadata>(this.legacyReader.getCoreMetadataList());
            this.metadata = this.legacyReader.getGlobalMetadata();
            this.metadataStore = this.legacyReader.getMetadataStore();
        }
    }

    private boolean callLegacyReader() {
        return this.legacyReaderInitialized && (this.useLegacy || !this.nativeReaderInitialized);
    }
}

