/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import loci.common.DebugTools;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class DebugToolsTest {
    Logger root = (Logger)LoggerFactory.getLogger((String)"ROOT");
    boolean status;

    @DataProvider(name="levels")
    public Object[][] createLevels() {
        return new Object[][]{{"INFO"}, {"WARN"}, {"ERROR"}, {"DEBUG"}, {"TRACE"}, {"ALL"}};
    }

    @BeforeClass
    public void testConfigurationFile() {
        AssertJUnit.assertTrue((boolean)DebugTools.isEnabled());
        this.status = DebugTools.enableLogging();
        AssertJUnit.assertFalse((boolean)this.status);
        AssertJUnit.assertEquals((Object)this.root.getLevel(), (Object)Level.toLevel((String)"WARN"));
        this.status = DebugTools.enableLogging((String)"INFO");
        AssertJUnit.assertFalse((boolean)this.status);
        AssertJUnit.assertEquals((Object)this.root.getLevel(), (Object)Level.toLevel((String)"WARN"));
    }

    @BeforeMethod
    public void setUp() {
        this.root.getLoggerContext().reset();
        AssertJUnit.assertFalse((boolean)DebugTools.isEnabled());
        AssertJUnit.assertEquals((Object)this.root.getLevel(), (Object)Level.toLevel((String)"DEBUG"));
    }

    @Test
    public void testEnableLogging() {
        this.status = DebugTools.enableLogging();
        AssertJUnit.assertTrue((boolean)this.status);
        AssertJUnit.assertTrue((boolean)DebugTools.isEnabled());
        this.status = DebugTools.enableLogging();
        AssertJUnit.assertFalse((boolean)this.status);
        AssertJUnit.assertTrue((boolean)DebugTools.isEnabled());
    }

    @Test
    public void testEnableLoggingDefaultLevel() {
        this.status = DebugTools.enableLogging((String)"INFO");
        AssertJUnit.assertTrue((boolean)this.status);
        AssertJUnit.assertTrue((boolean)DebugTools.isEnabled());
        AssertJUnit.assertEquals((Object)this.root.getLevel(), (Object)Level.toLevel((String)"INFO"));
        this.status = DebugTools.enableLogging((String)"DEBUG");
        AssertJUnit.assertFalse((boolean)this.status);
        AssertJUnit.assertTrue((boolean)DebugTools.isEnabled());
        AssertJUnit.assertEquals((Object)this.root.getLevel(), (Object)Level.toLevel((String)"INFO"));
    }

    @Test(dataProvider="levels")
    public void testEnableLoggingLevels(String level) {
        this.status = DebugTools.enableLogging((String)level);
        AssertJUnit.assertTrue((boolean)this.status);
        AssertJUnit.assertTrue((boolean)DebugTools.isEnabled());
        AssertJUnit.assertEquals((Object)this.root.getLevel(), (Object)Level.toLevel((String)level));
        this.status = DebugTools.enableLogging();
        AssertJUnit.assertFalse((boolean)this.status);
        AssertJUnit.assertTrue((boolean)DebugTools.isEnabled());
    }

    @Test(dataProvider="levels")
    public void testSetRootLevel(String level) {
        this.status = DebugTools.enableLogging();
        AssertJUnit.assertTrue((boolean)this.status);
        AssertJUnit.assertTrue((boolean)DebugTools.isEnabled());
        DebugTools.setRootLevel((String)level);
        AssertJUnit.assertEquals((Object)this.root.getLevel(), (Object)Level.toLevel((String)level));
    }
}

