/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import java.util.Date;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetRange<T> {
    private static final String MIN_INCLUDED = "[";
    private static final String MIN_EXCLUDED = "(";
    private static final String MAX_INCLUDED = "]";
    private static final String MAX_EXCLUDED = ")";
    private final T min;
    private final T max;
    private final boolean includeMin;
    private final boolean includeMax;
    private final String rangeString;
    private final String fieldName;
    private final Class<?> rangeType;
    private String stringMin;
    private String stringMax;

    public FacetRange(Class<?> rangeType, T min, T max, boolean includeMin, boolean includeMax, String fieldName, DocumentBuilderIndexedEntity<?> documentBuilder) {
        if (max == null && min == null) {
            throw new IllegalArgumentException("At least one end of the range has to be specified");
        }
        if (documentBuilder == null) {
            throw new AssertionFailure("null is not a valid document builder");
        }
        this.min = min;
        this.max = max;
        this.includeMax = includeMax;
        this.includeMin = includeMin;
        this.fieldName = fieldName;
        this.rangeString = this.buildRangeString();
        this.rangeType = rangeType;
        if (Date.class.equals(rangeType)) {
            this.stringMin = documentBuilder.objectToString(fieldName, min);
            this.stringMax = documentBuilder.objectToString(fieldName, max);
        }
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean isMinIncluded() {
        return this.includeMin;
    }

    public boolean isMaxIncluded() {
        return this.includeMax;
    }

    public boolean isInRange(T value) {
        if (Number.class.isAssignableFrom(this.rangeType)) {
            return this.isInRangeNumber((Number)value, (Number)this.min, (Number)this.max);
        }
        if (String.class.equals(this.rangeType)) {
            return this.isInRangeString((String)value, (String)this.min, (String)this.max);
        }
        if (Date.class.equals(this.rangeType)) {
            return this.isInRangeString((String)value, this.stringMin, this.stringMax);
        }
        throw new AssertionFailure("Unexpected value type: " + value.getClass().getName());
    }

    public String getRangeString() {
        return this.rangeString;
    }

    private String buildRangeString() {
        StringBuilder builder = new StringBuilder();
        if (this.includeMin) {
            builder.append(MIN_INCLUDED);
        } else {
            builder.append(MIN_EXCLUDED);
        }
        if (this.min != null) {
            builder.append(this.min);
        }
        builder.append(", ");
        if (this.max != null) {
            builder.append(this.max);
        }
        if (this.includeMax) {
            builder.append(MAX_INCLUDED);
        } else {
            builder.append(MAX_EXCLUDED);
        }
        return builder.toString();
    }

    private boolean isInRangeString(String value, String min, String max) {
        if (min == null) {
            if (this.isMaxIncluded()) {
                return value.compareTo(max) <= 0;
            }
            return value.compareTo(max) < 0;
        }
        if (max == null) {
            if (this.isMinIncluded()) {
                return value.compareTo(min) >= 0;
            }
            return value.compareTo(min) > 0;
        }
        int minCheck = min.compareTo(value);
        if (this.isMinIncluded() && minCheck > 0) {
            return false;
        }
        if (!this.isMinIncluded() && minCheck >= 0) {
            return false;
        }
        int maxCheck = value.compareTo(max);
        if (this.isMaxIncluded() && maxCheck > 0) {
            return false;
        }
        return this.isMaxIncluded() || maxCheck < 0;
    }

    private boolean isInRangeNumber(Number value, Number min, Number max) {
        if (min == null) {
            if (this.isMaxIncluded()) {
                return this.compare(value, max) <= 0;
            }
            return this.compare(value, max) < 0;
        }
        if (max == null) {
            if (this.isMinIncluded()) {
                return this.compare(value, min) >= 0;
            }
            return this.compare(value, min) > 0;
        }
        int minCheck = this.compare(min, value);
        if (this.isMinIncluded() && minCheck > 0) {
            return false;
        }
        if (!this.isMinIncluded() && minCheck >= 0) {
            return false;
        }
        int maxCheck = this.compare(value, max);
        if (this.isMaxIncluded() && maxCheck > 0) {
            return false;
        }
        return this.isMaxIncluded() || maxCheck < 0;
    }

    private int compare(Number number1, Number number2) {
        if (!number2.getClass().equals(number1.getClass())) {
            throw new IllegalStateException();
        }
        if (number1 instanceof Comparable) {
            return ((Comparable)((Object)number1)).compareTo(number2);
        }
        if (number1.doubleValue() < number2.doubleValue()) {
            return -1;
        }
        if (number1.doubleValue() > number2.doubleValue()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FacetRange");
        sb.append("{min=").append(this.min);
        sb.append(", max=").append(this.max);
        sb.append(", includeMin=").append(this.includeMin);
        sb.append(", includeMax=").append(this.includeMax);
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append(", rangeType=").append(this.rangeType);
        sb.append('}');
        return sb.toString();
    }
}

