/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

public class Version {
    public static final int MAJOR = 1;
    public static final int MINOR = 2;
    public static final int PATCHLEVEL = 1;
    public static final boolean IS_DEVELOPMENT = false;
    public static final int RELEASE_CANDIDATE = 0;
    static final SimpleDateFormat dateFormat;
    static final SimpleDateFormat eclipseDateFormat;
    public static final String COMPUTED_DATE;
    public static final String DATE;
    public static final String COMPUTED_ECLIPSE_DATE;
    public static final String ECLIPSE_DATE;
    public static final int PREVIEW = 0;
    private static final String RELEASE_SUFFIX_WORD;
    public static final String RELEASE_BASE = "1.2.1";
    public static final String COMPUTED_RELEASE;
    public static final String RELEASE;
    public static final String COMPUTED_ECLIPSE_UI_VERSION;
    public static final String ECLIPSE_UI_VERSION;
    public static final String WEBSITE = "http://findbugs.sourceforge.net";
    public static final String DOWNLOADS_WEBSITE = "http://prdownloads.sourceforge.net/findbugs";
    public static final String SUPPORT_EMAIL = "http://findbugs.sourceforge.net/reportingBugs.html";

    public static void main(String[] argv) {
        String arg;
        if (argv.length != 1) {
            Version.usage();
        }
        if ((arg = argv[0]).equals("-release")) {
            System.out.println(RELEASE);
        } else if (arg.equals("-date")) {
            System.out.println(DATE);
        } else if (arg.equals("-props")) {
            System.out.println("release.number=" + COMPUTED_RELEASE);
            System.out.println("release.date=" + COMPUTED_DATE);
            System.out.println("eclipse.date=" + COMPUTED_ECLIPSE_DATE);
            System.out.println("eclipse.ui.version=" + COMPUTED_ECLIPSE_UI_VERSION);
            System.out.println("findbugs.website=http://findbugs.sourceforge.net");
            System.out.println("findbugs.downloads.website=http://prdownloads.sourceforge.net/findbugs");
        } else {
            Version.usage();
            System.exit(1);
        }
    }

    private static void usage() {
        System.err.println("Usage: " + Version.class.getName() + "  (-release|-date|-props)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        String eclipseDate;
        String date;
        String eclipse_ui_version;
        String release;
        dateFormat = new SimpleDateFormat("HH:mm:ss z, dd MMMM, yyyy");
        eclipseDateFormat = new SimpleDateFormat("yyyyMMdd");
        COMPUTED_DATE = dateFormat.format(new Date());
        COMPUTED_ECLIPSE_DATE = eclipseDateFormat.format(new Date());
        RELEASE_SUFFIX_WORD = "dev-" + COMPUTED_ECLIPSE_DATE;
        COMPUTED_RELEASE = RELEASE_BASE + "";
        COMPUTED_ECLIPSE_UI_VERSION = "1.2.1." + COMPUTED_ECLIPSE_DATE;
        InputStream in = null;
        try {
            Properties versionProperties = new Properties();
            in = Version.class.getResourceAsStream("/version.properties");
            versionProperties.load(in);
            release = (String)versionProperties.get("release.number");
            eclipse_ui_version = (String)versionProperties.get("eclipse.ui.version");
            date = (String)versionProperties.get("release.date");
            eclipseDate = (String)versionProperties.get("eclipse.date");
        }
        catch (RuntimeException e) {
            release = COMPUTED_RELEASE;
            eclipse_ui_version = COMPUTED_ECLIPSE_UI_VERSION;
            date = COMPUTED_DATE;
            eclipseDate = COMPUTED_ECLIPSE_DATE;
        }
        catch (IOException e) {
            release = COMPUTED_RELEASE;
            eclipse_ui_version = COMPUTED_ECLIPSE_UI_VERSION;
            date = COMPUTED_DATE;
            eclipseDate = COMPUTED_ECLIPSE_DATE;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
        RELEASE = release;
        ECLIPSE_UI_VERSION = eclipse_ui_version;
        DATE = date;
        ECLIPSE_DATE = eclipseDate;
    }
}

