/*
 * Decompiled with CFR 0.152.
 */
package org.subethamail.smtp.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.cert.Certificate;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.subethamail.smtp.AuthenticationHandler;
import org.subethamail.smtp.DropConnectionException;
import org.subethamail.smtp.MessageContext;
import org.subethamail.smtp.MessageHandler;
import org.subethamail.smtp.io.CRLFTerminatedReader;
import org.subethamail.smtp.server.SMTPServer;
import org.subethamail.smtp.server.ServerThread;

public class Session
implements Runnable,
MessageContext {
    private static final Logger log = LoggerFactory.getLogger(Session.class);
    private SMTPServer server;
    private ServerThread serverThread;
    private final Map<?, ?> parentLoggingMdcContext = MDC.getCopyOfContextMap();
    private String sessionId;
    private volatile boolean quitting = false;
    private Socket socket;
    private InputStream input;
    private CRLFTerminatedReader reader;
    private PrintWriter writer;
    private AuthenticationHandler authenticationHandler;
    private MessageHandler messageHandler;
    private String helo;
    private boolean hasMailFrom;
    private int recipientCount;
    private String singleRecipient;
    private int declaredMessageSize = 0;
    private boolean tlsStarted;
    private Certificate[] tlsPeerCertificates;

    public Session(SMTPServer server, ServerThread serverThread, Socket socket) throws IOException {
        this.server = server;
        this.serverThread = serverThread;
        this.setSocket(socket);
    }

    public SMTPServer getServer() {
        return this.server;
    }

    public void run() {
        block15: {
            MDC.setContextMap(this.parentLoggingMdcContext);
            this.sessionId = this.server.getSessionIdFactory().create();
            MDC.put((String)"SessionId", (String)this.sessionId);
            String originalName = Thread.currentThread().getName();
            Thread.currentThread().setName(Session.class.getName() + "-" + this.socket.getInetAddress() + ":" + this.socket.getPort());
            if (log.isDebugEnabled()) {
                InetAddress remoteInetAddress = this.getRemoteAddress().getAddress();
                remoteInetAddress.getHostName();
                log.debug("SMTP connection from {}, new connection count: {}", (Object)remoteInetAddress, (Object)this.serverThread.getNumberOfConnections());
            }
            try {
                this.runCommandLoop();
            }
            catch (IOException e1) {
                if (this.quitting) break block15;
                try {
                    this.sendResponse("421 4.4.0 Problem attempting to execute commands. Please try again later.");
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (log.isWarnEnabled()) {
                    log.warn("Exception during SMTP transaction", (Throwable)e1);
                }
            }
            catch (Throwable e) {
                log.error("Unexpected error in the SMTP handler thread", e);
                try {
                    this.sendResponse("421 4.3.0 Mail system failure, closing transmission channel");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof Error) {
                    throw (Error)e;
                }
                throw new RuntimeException("Unexpected exception", e);
            }
            finally {
                this.closeConnection();
                this.endMessageHandler();
                this.serverThread.sessionEnded(this);
                Thread.currentThread().setName(originalName);
                MDC.clear();
            }
        }
    }

    private void runCommandLoop() throws IOException {
        if (this.serverThread.hasTooManyConnections()) {
            log.debug("SMTP Too many connections!");
            this.sendResponse("421 Too many connections, try again later");
            return;
        }
        this.sendResponse("220 " + this.server.getHostName() + " ESMTP " + this.server.getSoftwareName());
        this.resetMessageState();
        while (!this.quitting) {
            try {
                String line = null;
                try {
                    line = this.reader.readLine();
                }
                catch (SocketException ex) {
                    if (log.isDebugEnabled()) {
                        log.debug("Error reading client command: " + ex.getMessage(), (Throwable)ex);
                    }
                    return;
                }
                if (line == null) {
                    log.debug("no more lines from client");
                    return;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Client: " + line);
                }
                this.server.getCommandHandler().handleCommand(this, line);
            }
            catch (DropConnectionException ex) {
                this.sendResponse(ex.getErrorResponse());
                return;
            }
            catch (SocketTimeoutException ex) {
                this.sendResponse("421 Timeout waiting for data from client.");
                return;
            }
            catch (CRLFTerminatedReader.TerminationException te) {
                String msg = "501 Syntax error at character position " + te.position() + ". CR and LF must be CRLF paired.  See RFC 2821 #2.7.1.";
                log.debug(msg);
                this.sendResponse(msg);
                return;
            }
            catch (CRLFTerminatedReader.MaxLineLengthException mlle) {
                String msg = "501 " + mlle.getMessage();
                log.debug(msg);
                this.sendResponse(msg);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnection() {
        try {
            try {
                this.writer.close();
                this.input.close();
            }
            finally {
                this.closeSocket();
            }
        }
        catch (IOException e) {
            log.info(e.toString());
        }
    }

    public void setSocket(Socket socket) throws IOException {
        this.socket = socket;
        this.input = this.socket.getInputStream();
        this.reader = new CRLFTerminatedReader(this.input);
        this.writer = new PrintWriter(this.socket.getOutputStream());
        this.socket.setSoTimeout(this.server.getConnectionTimeout());
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void closeSocket() throws IOException {
        if (this.socket != null && this.socket.isBound() && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    public InputStream getRawInput() {
        return this.input;
    }

    public CRLFTerminatedReader getReader() {
        return this.reader;
    }

    public void sendResponse(String response) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("Server: " + response);
        }
        this.writer.print(response + "\r\n");
        this.writer.flush();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.socket.getRemoteSocketAddress();
    }

    public SMTPServer getSMTPServer() {
        return this.server;
    }

    public MessageHandler getMessageHandler() {
        return this.messageHandler;
    }

    public String getHelo() {
        return this.helo;
    }

    public void setHelo(String value) {
        this.helo = value;
    }

    public boolean getHasMailFrom() {
        return this.hasMailFrom;
    }

    public void setHasMailFrom(boolean value) {
        this.hasMailFrom = value;
    }

    public void addRecipient(String recipientAddress) {
        ++this.recipientCount;
        this.singleRecipient = this.recipientCount == 1 ? recipientAddress : null;
    }

    public int getRecipientCount() {
        return this.recipientCount;
    }

    public String getSingleRecipient() {
        return this.singleRecipient;
    }

    public boolean isAuthenticated() {
        return this.authenticationHandler != null;
    }

    public AuthenticationHandler getAuthenticationHandler() {
        return this.authenticationHandler;
    }

    public void setAuthenticationHandler(AuthenticationHandler handler) {
        this.authenticationHandler = handler;
    }

    public int getDeclaredMessageSize() {
        return this.declaredMessageSize;
    }

    public void setDeclaredMessageSize(int declaredMessageSize) {
        this.declaredMessageSize = declaredMessageSize;
    }

    public void resetSmtpProtocol() {
        this.resetMessageState();
        this.helo = null;
    }

    public void resetMessageState() {
        this.endMessageHandler();
        this.messageHandler = null;
        this.hasMailFrom = false;
        this.recipientCount = 0;
        this.singleRecipient = null;
        this.declaredMessageSize = 0;
    }

    public void startMailTransaction() {
        if (this.messageHandler != null) {
            throw new IllegalStateException("Mail transaction is already in progress");
        }
        this.messageHandler = this.server.getMessageHandlerFactory().create(this);
    }

    protected void endMessageHandler() {
        if (this.messageHandler != null) {
            try {
                this.messageHandler.done();
            }
            catch (Throwable ex) {
                log.error("done() threw exception", ex);
            }
        }
    }

    public void quit() {
        this.quitting = true;
        this.closeConnection();
    }

    public boolean isTLSStarted() {
        return this.tlsStarted;
    }

    public void setTlsStarted(boolean tlsStarted) {
        this.tlsStarted = tlsStarted;
    }

    public void setTlsPeerCertificates(Certificate[] tlsPeerCertificates) {
        this.tlsPeerCertificates = tlsPeerCertificates;
    }

    public Certificate[] getTlsPeerCertificates() {
        return this.tlsPeerCertificates;
    }
}

