/*
 * Decompiled with CFR 0.152.
 */
package omero.cmd;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import ome.api.local.LocalAdmin;
import ome.conditions.InternalException;
import ome.conditions.SecurityViolation;
import ome.system.EventContext;
import ome.system.Roles;
import ome.system.ServiceFactory;
import ome.util.SqlAction;
import omero.ServerError;
import omero.cmd.ERR;
import omero.cmd.HandleI;
import omero.cmd.Request;
import omero.cmd.Response;
import omero.cmd.State;
import omero.cmd.Status;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Helper {
    private final Logger log;
    private final AtomicReference<Response> rsp = new AtomicReference();
    private final Request request;
    private final Status status;
    private final ServiceFactory sf;
    private final Session session;
    private final SqlAction sql;
    private int assertSteps = 0;
    private int assertResponses = 0;
    private boolean stepsSet = false;
    private transient boolean isGuest = true;
    private transient boolean preventGuest = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Helper(Request request, Status status, SqlAction sql, Session session, ServiceFactory sf) {
        Status status2 = status;
        synchronized (status2) {
            if (status.flags == null) {
                status.flags = new ArrayList<State>();
            }
        }
        this.request = request;
        this.status = status;
        this.sql = sql;
        this.session = session;
        this.sf = sf;
        if (sf != null) {
            Roles roles;
            long userId = this.getEventContext().getCurrentUserId();
            this.isGuest = userId == (roles = sf.getAdminService().getSecurityRoles()).getGuestId();
        }
        this.log = LoggerFactory.getLogger((String)((Object)((Object)this.request)).toString().replaceAll("@", ".@"));
    }

    public Helper subhelper(Request req, Status substatus) {
        return new Helper(req, substatus, this.sql, this.session, this.sf);
    }

    private void requireStepsSet() {
        if (!this.stepsSet) {
            this.cancel(new ERR(), (Throwable)new InternalException("Steps unset!"), "steps-unset", new String[0]);
        }
    }

    public void allowGuests() {
        this.preventGuest = false;
    }

    public void setSteps(int steps) {
        if (this.preventGuest && this.isGuest) {
            this.cancel(new ERR(), (Throwable)new SecurityViolation("Disallowed for guests"), "guest-restriction", new String[0]);
        }
        if (this.stepsSet) {
            this.cancel(new ERR(), (Throwable)new InternalException("Steps set!"), "steps-set", new String[0]);
        }
        this.status.steps = steps;
        this.stepsSet = true;
        if (steps == 0) {
            this.cancel(new ERR(), null, "no-steps", new String[0]);
        }
    }

    public int getSteps() {
        this.requireStepsSet();
        return this.status.steps;
    }

    public Status getStatus() {
        return this.status;
    }

    public Response getResponse() {
        return this.rsp.get();
    }

    public boolean setResponseIfNull(Response rsp) {
        return this.rsp.compareAndSet(null, rsp);
    }

    public ServiceFactory getServiceFactory() {
        return this.sf;
    }

    public Session getSession() {
        return this.session;
    }

    public SqlAction getSql() {
        return this.sql;
    }

    public void debug(String fmt, Object ... args) {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format(fmt, args));
        }
    }

    public void info(String fmt, Object ... args) {
        if (this.log.isInfoEnabled()) {
            this.log.info(String.format(fmt, args));
        }
    }

    public void warn(String fmt, Object ... args) {
        if (this.log.isWarnEnabled()) {
            this.log.warn(String.format(fmt, args));
        }
    }

    public void error(String fmt, Object ... args) {
        this.error(null, fmt, args);
    }

    public void error(Throwable t, String fmt, Object ... args) {
        if (this.log.isErrorEnabled()) {
            if (t != null) {
                this.log.error(String.format(fmt, args), t);
            } else {
                this.log.error(String.format(fmt, args));
            }
        }
    }

    public Map<String, String> params(String ... paramList) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (int i = 0; i < paramList.length - 1 && i + 1 != paramList.length; i += 2) {
            params.put(paramList[i], paramList[i + 1]);
        }
        return params;
    }

    public void fail(ERR err, Throwable t, String name, String ... paramList) {
        this.fail(err, t, name, this.params(paramList));
    }

    public void fail(ERR err, Throwable t, String name, Map<String, String> params) {
        this.status.flags.add(State.FAILURE);
        err.category = this.request.ice_id();
        err.name = name;
        if (err.parameters == null) {
            err.parameters = params;
        } else {
            err.parameters.putAll(params);
        }
        if (t != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t.printStackTrace(pw);
            String st = sw.toString();
            if (t instanceof ServerError) {
                String msg = ((ServerError)((Object)t)).message;
                err.parameters.put("message", msg);
            } else {
                String msg = t.getMessage();
                err.parameters.put("message", msg);
            }
            err.parameters.put("stacktrace", st);
        }
        this.rsp.set(err);
    }

    public HandleI.Cancel cancel(ERR err, Throwable t, String name, String ... paramList) {
        return this.cancel(err, t, name, this.params(paramList));
    }

    public HandleI.Cancel cancel(ERR err, Throwable t, String name, Map<String, String> params) {
        this.fail(err, t, name, params);
        this.status.flags.add(State.CANCELLED);
        HandleI.Cancel cancel = new HandleI.Cancel(name);
        if (t != null) {
            cancel.initCause(t);
        }
        this.info("Cancelled", new Object[0]);
        throw cancel;
    }

    public void assertStep(int i, int step) {
        if (step != i) {
            this.cancel(new ERR(), null, "bad step", "actual_step", "" + step, "expected_step", "" + i);
        }
    }

    public void assertStep(int step) {
        this.assertStep(this.assertSteps, step);
        ++this.assertSteps;
    }

    public void assertResponse(int step) {
        this.assertStep(this.assertResponses, step);
        ++this.assertResponses;
    }

    public boolean isLast(int step) {
        return step == this.status.steps - 1;
    }

    public EventContext getEventContext() {
        LocalAdmin admin = (LocalAdmin)this.sf.getAdminService();
        EventContext ec = admin.getEventContextQuiet();
        return ec;
    }
}

