/*
 * Decompiled with CFR 0.152.
 */
package ome.model.acquisition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ome.conditions.ApiUsageException;
import ome.model.IAnnotated;
import ome.model.IMutable;
import ome.model.IObject;
import ome.model.acquisition.Detector;
import ome.model.acquisition.Dichroic;
import ome.model.acquisition.Filter;
import ome.model.acquisition.FilterSet;
import ome.model.acquisition.LightSource;
import ome.model.acquisition.Microscope;
import ome.model.acquisition.OTF;
import ome.model.acquisition.Objective;
import ome.model.annotations.Annotation;
import ome.model.annotations.InstrumentAnnotationLink;
import ome.model.internal.GraphHolder;
import ome.model.internal.Permissions;
import ome.model.meta.Event;
import ome.model.meta.Experimenter;
import ome.model.meta.ExperimenterGroup;
import ome.model.meta.ExternalInfo;
import ome.util.CBlock;
import ome.util.CountCollectionPersister;
import ome.util.DetailsFieldBridge;
import ome.util.EmptyIterator;
import ome.util.Validation;
import ome.util.Validator;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Persister;
import org.hibernate.annotations.Target;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;

@FilterDefs(value={@FilterDef(name="instrument_owner_filter", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="instrument_owner_filter_DETECTOR", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter_DETECTOR", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter_DETECTOR", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter_DETECTOR", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="instrument_owner_filter_OBJECTIVE", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter_OBJECTIVE", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter_OBJECTIVE", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter_OBJECTIVE", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="instrument_owner_filter_LIGHTSOURCE", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter_LIGHTSOURCE", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter_LIGHTSOURCE", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter_LIGHTSOURCE", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="instrument_owner_filter_FILTER", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter_FILTER", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter_FILTER", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter_FILTER", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="instrument_owner_filter_DICHROIC", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter_DICHROIC", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter_DICHROIC", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter_DICHROIC", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="instrument_owner_filter_FILTERSET", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter_FILTERSET", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter_FILTERSET", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter_FILTERSET", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="instrument_owner_filter_OTF", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter_OTF", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter_OTF", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter_OTF", parameters={@ParamDef(name="permsStr", type="java.lang.String")}), @FilterDef(name="instrument_owner_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="ownerId", type="java.lang.Long")}), @FilterDef(name="instrument_group_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="groupId", type="java.lang.Long")}), @FilterDef(name="instrument_event_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="eventId", type="java.lang.Long")}), @FilterDef(name="instrument_perms_filter_ANNOTATIONLINKS", parameters={@ParamDef(name="permsStr", type="java.lang.String")})})
@Filters(value={@org.hibernate.annotations.Filter(name="instrument_owner_filter", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter", condition=":permsStr = permissions"), @org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT instrument FROM image* WHERE id IN (:images)))")})
@Entity
@Table(name="instrument", uniqueConstraints={})
@org.hibernate.annotations.Entity(selectBeforeUpdate=true)
@Inheritance(strategy=InheritanceType.JOINED)
@GenericGenerator(name="seq_instrument", strategy="ome.util.TableIdGenerator", parameters={@Parameter(name="table_name", value="seq_table"), @Parameter(name="segment_value", value="seq_instrument"), @Parameter(name="optimizer", value="pooled"), @Parameter(name="increment_size", value="50")})
@Indexed(index="FullText")
@ClassBridge(name="details", impl=DetailsFieldBridge.class, index=Index.UN_TOKENIZED, store=Store.NO)
public class Instrument
implements Serializable,
IObject,
IMutable,
IAnnotated {
    private static final long serialVersionUID = 0xC00020C2L;
    public static final String OWNER_FILTER = "instrument_owner_filter";
    public static final String GROUP_FILTER = "instrument_group_filter";
    public static final String EVENT_FILTER = "instrument_event_filter";
    public static final String PERMS_FILTER = "instrument_perms_filter";
    public static final String ID = "ome.model.acquisition.Instrument_id";
    protected Long id;
    public static final String VERSION = "ome.model.acquisition.Instrument_version";
    protected Integer version = 0;
    protected Microscope microscope = null;
    protected Set<Detector> detector = new HashSet<Detector>();
    public static final String OWNER_FILTER_DETECTOR = "instrument_owner_filter_DETECTOR";
    public static final String GROUP_FILTER_DETECTOR = "instrument_group_filter_DETECTOR";
    public static final String EVENT_FILTER_DETECTOR = "instrument_event_filter_DETECTOR";
    public static final String PERMS_FILTER_DETECTOR = "instrument_perms_filter_DETECTOR";
    protected Set<Objective> objective = new HashSet<Objective>();
    public static final String OWNER_FILTER_OBJECTIVE = "instrument_owner_filter_OBJECTIVE";
    public static final String GROUP_FILTER_OBJECTIVE = "instrument_group_filter_OBJECTIVE";
    public static final String EVENT_FILTER_OBJECTIVE = "instrument_event_filter_OBJECTIVE";
    public static final String PERMS_FILTER_OBJECTIVE = "instrument_perms_filter_OBJECTIVE";
    protected Set<LightSource> lightSource = new HashSet<LightSource>();
    public static final String OWNER_FILTER_LIGHTSOURCE = "instrument_owner_filter_LIGHTSOURCE";
    public static final String GROUP_FILTER_LIGHTSOURCE = "instrument_group_filter_LIGHTSOURCE";
    public static final String EVENT_FILTER_LIGHTSOURCE = "instrument_event_filter_LIGHTSOURCE";
    public static final String PERMS_FILTER_LIGHTSOURCE = "instrument_perms_filter_LIGHTSOURCE";
    protected Set<Filter> filter = new HashSet<Filter>();
    public static final String OWNER_FILTER_FILTER = "instrument_owner_filter_FILTER";
    public static final String GROUP_FILTER_FILTER = "instrument_group_filter_FILTER";
    public static final String EVENT_FILTER_FILTER = "instrument_event_filter_FILTER";
    public static final String PERMS_FILTER_FILTER = "instrument_perms_filter_FILTER";
    protected Set<Dichroic> dichroic = new HashSet<Dichroic>();
    public static final String OWNER_FILTER_DICHROIC = "instrument_owner_filter_DICHROIC";
    public static final String GROUP_FILTER_DICHROIC = "instrument_group_filter_DICHROIC";
    public static final String EVENT_FILTER_DICHROIC = "instrument_event_filter_DICHROIC";
    public static final String PERMS_FILTER_DICHROIC = "instrument_perms_filter_DICHROIC";
    protected Set<FilterSet> filterSet = new HashSet<FilterSet>();
    public static final String OWNER_FILTER_FILTERSET = "instrument_owner_filter_FILTERSET";
    public static final String GROUP_FILTER_FILTERSET = "instrument_group_filter_FILTERSET";
    public static final String EVENT_FILTER_FILTERSET = "instrument_event_filter_FILTERSET";
    public static final String PERMS_FILTER_FILTERSET = "instrument_perms_filter_FILTERSET";
    protected Set<OTF> otf = new HashSet<OTF>();
    public static final String OWNER_FILTER_OTF = "instrument_owner_filter_OTF";
    public static final String GROUP_FILTER_OTF = "instrument_group_filter_OTF";
    public static final String EVENT_FILTER_OTF = "instrument_event_filter_OTF";
    public static final String PERMS_FILTER_OTF = "instrument_perms_filter_OTF";
    protected Set<InstrumentAnnotationLink> annotationLinks = new HashSet<InstrumentAnnotationLink>();
    public static final String OWNER_FILTER_ANNOTATIONLINKS = "instrument_owner_filter_ANNOTATIONLINKS";
    public static final String GROUP_FILTER_ANNOTATIONLINKS = "instrument_group_filter_ANNOTATIONLINKS";
    public static final String EVENT_FILTER_ANNOTATIONLINKS = "instrument_event_filter_ANNOTATIONLINKS";
    public static final String PERMS_FILTER_ANNOTATIONLINKS = "instrument_perms_filter_ANNOTATIONLINKS";
    private Map<Long, Long> annotationLinksCountPerOwner = null;
    protected ome.model.internal.Details details = new Details();
    public static final String MICROSCOPE = "ome.model.acquisition.Instrument_microscope";
    public static final String DETECTOR = "ome.model.acquisition.Instrument_detector";
    public static final String OBJECTIVE = "ome.model.acquisition.Instrument_objective";
    public static final String LIGHTSOURCE = "ome.model.acquisition.Instrument_lightSource";
    public static final String FILTER = "ome.model.acquisition.Instrument_filter";
    public static final String DICHROIC = "ome.model.acquisition.Instrument_dichroic";
    public static final String FILTERSET = "ome.model.acquisition.Instrument_filterSet";
    public static final String OTF = "ome.model.acquisition.Instrument_otf";
    public static final String ANNOTATIONLINKSCOUNTPEROWNER = "ome.model.acquisition.Instrument_annotationLinksCountPerOwner";
    public static final String ANNOTATIONLINKS = "ome.model.acquisition.Instrument_annotationLinks";
    public static final String DETAILS = "ome.model.acquisition.Instrument_details";
    public static final Set<String> FIELDS;
    @Transient
    protected Map<String, Object> _dynamicFields;
    @Transient
    protected boolean _loaded = true;
    @Transient
    private transient GraphHolder _graphHolder;

    public Instrument() {
        this(null, true);
    }

    protected Instrument(Long id) {
        this(id, true);
    }

    public Instrument(Long id, boolean loaded) {
        this.setId(id);
        if (loaded) {
            this.getDetails().setContext(this);
        } else {
            if (this.id == null) {
                throw new ApiUsageException("Id cannot be null for a proxy");
            }
            this.unload();
        }
    }

    @Override
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="seq_instrument")
    @DocumentId
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="version")
    public Integer getVersion() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.version;
    }

    @Override
    public void setVersion(Integer version) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.version = version;
    }

    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, targetEntity=Microscope.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @JoinColumn(name="microscope", nullable=true, unique=false, insertable=true, updatable=true)
    @ForeignKey(name="FKinstrument_microscope_microscope")
    public Microscope getMicroscope() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.microscope;
    }

    public void setMicroscope(Microscope microscope) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.microscope = microscope;
    }

    @OneToMany(mappedBy="instrument", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT detector.id FROM detector*, image* WHERE detector.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="instrument_owner_filter_DETECTOR", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter_DETECTOR", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter_DETECTOR", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter_DETECTOR", condition=":permsStr = permissions")})
    protected Set<Detector> getDetector() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.detector;
    }

    protected void setDetector(Set<Detector> detector) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.detector = detector;
    }

    public int sizeOfDetector() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.detector == null ? -1 : this.detector.size();
    }

    public Iterator<Detector> iterateDetector() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDetector() == null) {
            return new EmptyIterator<Detector>();
        }
        return this.getDetector().iterator();
    }

    public Collection<Detector> unmodifiableDetector() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDetector() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getDetector());
    }

    public <E> List<E> collectDetector(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Detector> it = this.iterateDetector();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addDetector(Detector target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDetector() == null) {
            this.throwNullCollectionException("Detector");
        }
        this.getDetector().add(target);
        if (target != null) {
            target.setInstrument(this);
        }
    }

    public void addDetectorSet(Collection<Detector> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDetector() == null) {
            this.throwNullCollectionException("Detector");
        }
        this.getDetector().addAll(targets);
        for (Detector target : targets) {
            if (target == null) continue;
            target.setInstrument(this);
        }
    }

    public void removeDetector(Detector target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDetector() == null) {
            this.throwNullCollectionException("Detector");
        }
        this.getDetector().remove(target);
        target.setInstrument(null);
    }

    public void removeDetectorSet(Collection<Detector> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDetector() == null) {
            this.throwNullCollectionException("Detector");
        }
        this.getDetector().removeAll(targets);
        for (Detector target : targets) {
            target.setInstrument(null);
        }
    }

    public void clearDetector() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDetector() == null) {
            this.throwNullCollectionException("Detector");
        }
        this.getDetector().clear();
        Iterator<Detector> it = this.iterateDetector();
        while (it.hasNext()) {
            Detector target = it.next();
            target.setInstrument(null);
        }
    }

    @OneToMany(mappedBy="instrument", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT objective.id FROM objective*, image* WHERE objective.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="instrument_owner_filter_OBJECTIVE", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter_OBJECTIVE", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter_OBJECTIVE", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter_OBJECTIVE", condition=":permsStr = permissions")})
    protected Set<Objective> getObjective() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.objective;
    }

    protected void setObjective(Set<Objective> objective) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.objective = objective;
    }

    public int sizeOfObjective() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.objective == null ? -1 : this.objective.size();
    }

    public Iterator<Objective> iterateObjective() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getObjective() == null) {
            return new EmptyIterator<Objective>();
        }
        return this.getObjective().iterator();
    }

    public Collection<Objective> unmodifiableObjective() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getObjective() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getObjective());
    }

    public <E> List<E> collectObjective(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Objective> it = this.iterateObjective();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addObjective(Objective target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getObjective() == null) {
            this.throwNullCollectionException("Objective");
        }
        this.getObjective().add(target);
        if (target != null) {
            target.setInstrument(this);
        }
    }

    public void addObjectiveSet(Collection<Objective> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getObjective() == null) {
            this.throwNullCollectionException("Objective");
        }
        this.getObjective().addAll(targets);
        for (Objective target : targets) {
            if (target == null) continue;
            target.setInstrument(this);
        }
    }

    public void removeObjective(Objective target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getObjective() == null) {
            this.throwNullCollectionException("Objective");
        }
        this.getObjective().remove(target);
        target.setInstrument(null);
    }

    public void removeObjectiveSet(Collection<Objective> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getObjective() == null) {
            this.throwNullCollectionException("Objective");
        }
        this.getObjective().removeAll(targets);
        for (Objective target : targets) {
            target.setInstrument(null);
        }
    }

    public void clearObjective() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getObjective() == null) {
            this.throwNullCollectionException("Objective");
        }
        this.getObjective().clear();
        Iterator<Objective> it = this.iterateObjective();
        while (it.hasNext()) {
            Objective target = it.next();
            target.setInstrument(null);
        }
    }

    @OneToMany(mappedBy="instrument", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT lightsource.id FROM lightsource*, image* WHERE lightsource.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="instrument_owner_filter_LIGHTSOURCE", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter_LIGHTSOURCE", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter_LIGHTSOURCE", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter_LIGHTSOURCE", condition=":permsStr = permissions")})
    protected Set<LightSource> getLightSource() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lightSource;
    }

    protected void setLightSource(Set<LightSource> lightSource) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.lightSource = lightSource;
    }

    public int sizeOfLightSource() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.lightSource == null ? -1 : this.lightSource.size();
    }

    public Iterator<LightSource> iterateLightSource() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSource() == null) {
            return new EmptyIterator<LightSource>();
        }
        return this.getLightSource().iterator();
    }

    public Collection<LightSource> unmodifiableLightSource() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSource() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getLightSource());
    }

    public <E> List<E> collectLightSource(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<LightSource> it = this.iterateLightSource();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addLightSource(LightSource target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSource() == null) {
            this.throwNullCollectionException("LightSource");
        }
        this.getLightSource().add(target);
        if (target != null) {
            target.setInstrument(this);
        }
    }

    public void addLightSourceSet(Collection<LightSource> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSource() == null) {
            this.throwNullCollectionException("LightSource");
        }
        this.getLightSource().addAll(targets);
        for (LightSource target : targets) {
            if (target == null) continue;
            target.setInstrument(this);
        }
    }

    public void removeLightSource(LightSource target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSource() == null) {
            this.throwNullCollectionException("LightSource");
        }
        this.getLightSource().remove(target);
        target.setInstrument(null);
    }

    public void removeLightSourceSet(Collection<LightSource> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSource() == null) {
            this.throwNullCollectionException("LightSource");
        }
        this.getLightSource().removeAll(targets);
        for (LightSource target : targets) {
            target.setInstrument(null);
        }
    }

    public void clearLightSource() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getLightSource() == null) {
            this.throwNullCollectionException("LightSource");
        }
        this.getLightSource().clear();
        Iterator<LightSource> it = this.iterateLightSource();
        while (it.hasNext()) {
            LightSource target = it.next();
            target.setInstrument(null);
        }
    }

    @OneToMany(mappedBy="instrument", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT filter.id FROM filter*, image* WHERE filter.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="instrument_owner_filter_FILTER", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter_FILTER", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter_FILTER", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter_FILTER", condition=":permsStr = permissions")})
    protected Set<Filter> getFilter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.filter;
    }

    protected void setFilter(Set<Filter> filter) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.filter = filter;
    }

    public int sizeOfFilter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.filter == null ? -1 : this.filter.size();
    }

    public Iterator<Filter> iterateFilter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilter() == null) {
            return new EmptyIterator<Filter>();
        }
        return this.getFilter().iterator();
    }

    public Collection<Filter> unmodifiableFilter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilter() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getFilter());
    }

    public <E> List<E> collectFilter(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Filter> it = this.iterateFilter();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilter(Filter target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilter() == null) {
            this.throwNullCollectionException("Filter");
        }
        this.getFilter().add(target);
        if (target != null) {
            target.setInstrument(this);
        }
    }

    public void addFilterSet(Collection<Filter> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilter() == null) {
            this.throwNullCollectionException("Filter");
        }
        this.getFilter().addAll(targets);
        for (Filter target : targets) {
            if (target == null) continue;
            target.setInstrument(this);
        }
    }

    public void removeFilter(Filter target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilter() == null) {
            this.throwNullCollectionException("Filter");
        }
        this.getFilter().remove(target);
        target.setInstrument(null);
    }

    public void removeFilterSet(Collection<Filter> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilter() == null) {
            this.throwNullCollectionException("Filter");
        }
        this.getFilter().removeAll(targets);
        for (Filter target : targets) {
            target.setInstrument(null);
        }
    }

    public void clearFilter() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilter() == null) {
            this.throwNullCollectionException("Filter");
        }
        this.getFilter().clear();
        Iterator<Filter> it = this.iterateFilter();
        while (it.hasNext()) {
            Filter target = it.next();
            target.setInstrument(null);
        }
    }

    @OneToMany(mappedBy="instrument", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT dichroic.id FROM dichroic*, image* WHERE dichroic.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="instrument_owner_filter_DICHROIC", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter_DICHROIC", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter_DICHROIC", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter_DICHROIC", condition=":permsStr = permissions")})
    protected Set<Dichroic> getDichroic() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.dichroic;
    }

    protected void setDichroic(Set<Dichroic> dichroic) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.dichroic = dichroic;
    }

    public int sizeOfDichroic() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.dichroic == null ? -1 : this.dichroic.size();
    }

    public Iterator<Dichroic> iterateDichroic() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDichroic() == null) {
            return new EmptyIterator<Dichroic>();
        }
        return this.getDichroic().iterator();
    }

    public Collection<Dichroic> unmodifiableDichroic() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDichroic() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getDichroic());
    }

    public <E> List<E> collectDichroic(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Dichroic> it = this.iterateDichroic();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addDichroic(Dichroic target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDichroic() == null) {
            this.throwNullCollectionException("Dichroic");
        }
        this.getDichroic().add(target);
        if (target != null) {
            target.setInstrument(this);
        }
    }

    public void addDichroicSet(Collection<Dichroic> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDichroic() == null) {
            this.throwNullCollectionException("Dichroic");
        }
        this.getDichroic().addAll(targets);
        for (Dichroic target : targets) {
            if (target == null) continue;
            target.setInstrument(this);
        }
    }

    public void removeDichroic(Dichroic target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDichroic() == null) {
            this.throwNullCollectionException("Dichroic");
        }
        this.getDichroic().remove(target);
        target.setInstrument(null);
    }

    public void removeDichroicSet(Collection<Dichroic> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDichroic() == null) {
            this.throwNullCollectionException("Dichroic");
        }
        this.getDichroic().removeAll(targets);
        for (Dichroic target : targets) {
            target.setInstrument(null);
        }
    }

    public void clearDichroic() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getDichroic() == null) {
            this.throwNullCollectionException("Dichroic");
        }
        this.getDichroic().clear();
        Iterator<Dichroic> it = this.iterateDichroic();
        while (it.hasNext()) {
            Dichroic target = it.next();
            target.setInstrument(null);
        }
    }

    @OneToMany(mappedBy="instrument", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT filterset.id FROM filterset*, image* WHERE filterset.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="instrument_owner_filter_FILTERSET", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter_FILTERSET", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter_FILTERSET", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter_FILTERSET", condition=":permsStr = permissions")})
    protected Set<FilterSet> getFilterSet() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.filterSet;
    }

    protected void setFilterSet(Set<FilterSet> filterSet) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.filterSet = filterSet;
    }

    public int sizeOfFilterSet() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.filterSet == null ? -1 : this.filterSet.size();
    }

    public Iterator<FilterSet> iterateFilterSet() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilterSet() == null) {
            return new EmptyIterator<FilterSet>();
        }
        return this.getFilterSet().iterator();
    }

    public Collection<FilterSet> unmodifiableFilterSet() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilterSet() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getFilterSet());
    }

    public <E> List<E> collectFilterSet(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<FilterSet> it = this.iterateFilterSet();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addFilterSet(FilterSet target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilterSet() == null) {
            this.throwNullCollectionException("FilterSet");
        }
        this.getFilterSet().add(target);
        if (target != null) {
            target.setInstrument(this);
        }
    }

    public void addFilterSetSet(Collection<FilterSet> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilterSet() == null) {
            this.throwNullCollectionException("FilterSet");
        }
        this.getFilterSet().addAll(targets);
        for (FilterSet target : targets) {
            if (target == null) continue;
            target.setInstrument(this);
        }
    }

    public void removeFilterSet(FilterSet target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilterSet() == null) {
            this.throwNullCollectionException("FilterSet");
        }
        this.getFilterSet().remove(target);
        target.setInstrument(null);
    }

    public void removeFilterSetSet(Collection<FilterSet> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilterSet() == null) {
            this.throwNullCollectionException("FilterSet");
        }
        this.getFilterSet().removeAll(targets);
        for (FilterSet target : targets) {
            target.setInstrument(null);
        }
    }

    public void clearFilterSet() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getFilterSet() == null) {
            this.throwNullCollectionException("FilterSet");
        }
        this.getFilterSet().clear();
        Iterator<FilterSet> it = this.iterateFilterSet();
        while (it.hasNext()) {
            FilterSet target = it.next();
            target.setInstrument(null);
        }
    }

    @OneToMany(mappedBy="instrument", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0 OR id IN (SELECT otf.id FROM otf*, image* WHERE otf.instrument = image.instrument AND image.id IN (:images)))"), @org.hibernate.annotations.Filter(name="instrument_owner_filter_OTF", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter_OTF", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter_OTF", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter_OTF", condition=":permsStr = permissions")})
    protected Set<OTF> getOtf() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.otf;
    }

    protected void setOtf(Set<OTF> otf) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.otf = otf;
    }

    public int sizeOfOtf() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.otf == null ? -1 : this.otf.size();
    }

    public Iterator<OTF> iterateOtf() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOtf() == null) {
            return new EmptyIterator<OTF>();
        }
        return this.getOtf().iterator();
    }

    public Collection<OTF> unmodifiableOtf() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOtf() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getOtf());
    }

    public <E> List<E> collectOtf(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<OTF> it = this.iterateOtf();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addOTF(OTF target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOtf() == null) {
            this.throwNullCollectionException("Otf");
        }
        this.getOtf().add(target);
        if (target != null) {
            target.setInstrument(this);
        }
    }

    public void addOTFSet(Collection<OTF> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOtf() == null) {
            this.throwNullCollectionException("Otf");
        }
        this.getOtf().addAll(targets);
        for (OTF target : targets) {
            if (target == null) continue;
            target.setInstrument(this);
        }
    }

    public void removeOTF(OTF target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOtf() == null) {
            this.throwNullCollectionException("Otf");
        }
        this.getOtf().remove(target);
        target.setInstrument(null);
    }

    public void removeOTFSet(Collection<OTF> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOtf() == null) {
            this.throwNullCollectionException("Otf");
        }
        this.getOtf().removeAll(targets);
        for (OTF target : targets) {
            target.setInstrument(null);
        }
    }

    public void clearOtf() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getOtf() == null) {
            this.throwNullCollectionException("Otf");
        }
        this.getOtf().clear();
        Iterator<OTF> it = this.iterateOtf();
        while (it.hasNext()) {
            OTF target = it.next();
            target.setInstrument(null);
        }
    }

    @OneToMany(mappedBy="parent", fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Filters(value={@org.hibernate.annotations.Filter(name="OneGroupSecurityFilter"), @org.hibernate.annotations.Filter(name="AllGroupsSecurityFilter"), @org.hibernate.annotations.Filter(name="SharingSecurityFilter", condition="(:is_admin = 1 OR :is_share = 0)"), @org.hibernate.annotations.Filter(name="instrument_owner_filter_ANNOTATIONLINKS", condition=":ownerId = owner_id"), @org.hibernate.annotations.Filter(name="instrument_group_filter_ANNOTATIONLINKS", condition=":groupId = group_id"), @org.hibernate.annotations.Filter(name="instrument_event_filter_ANNOTATIONLINKS", condition=":eventId = event_id"), @org.hibernate.annotations.Filter(name="instrument_perms_filter_ANNOTATIONLINKS", condition=":permsStr = permissions")})
    protected Set<InstrumentAnnotationLink> getAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks;
    }

    protected void setAnnotationLinks(Set<InstrumentAnnotationLink> annotationLinks) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.annotationLinks = annotationLinks;
    }

    @Override
    public int sizeOfAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.annotationLinks == null ? -1 : this.annotationLinks.size();
    }

    public Iterator<InstrumentAnnotationLink> iterateAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<InstrumentAnnotationLink>();
        }
        return this.getAnnotationLinks().iterator();
    }

    public Collection<InstrumentAnnotationLink> unmodifiableAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.getAnnotationLinks());
    }

    @Override
    public <E> List<E> collectAnnotationLinks(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<InstrumentAnnotationLink> it = this.iterateAnnotationLinks();
        while (it.hasNext()) {
            IObject obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    public void addInstrumentAnnotationLink(InstrumentAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(target);
        if (target != null) {
            target.setParent(this);
        }
    }

    public void addInstrumentAnnotationLinkSet(Collection<InstrumentAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().addAll(targets);
        for (InstrumentAnnotationLink target : targets) {
            if (target == null) continue;
            target.setParent(this);
        }
    }

    public void removeInstrumentAnnotationLink(InstrumentAnnotationLink target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(target);
        target.setParent(null);
    }

    public void removeInstrumentAnnotationLinkSet(Collection<InstrumentAnnotationLink> targets) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().removeAll(targets);
        for (InstrumentAnnotationLink target : targets) {
            target.setParent(null);
        }
    }

    public InstrumentAnnotationLink linkAnnotation(Annotation addition) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        InstrumentAnnotationLink link = new InstrumentAnnotationLink();
        link.link(this, addition);
        this.addInstrumentAnnotationLink(link, true);
        return link;
    }

    public void addInstrumentAnnotationLink(InstrumentAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().add(link);
    }

    @Override
    public Iterator<Annotation> linkedAnnotationIterator() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            return new EmptyIterator<Annotation>();
        }
        final Iterator<InstrumentAnnotationLink> it = this.getAnnotationLinks().iterator();
        return new Iterator<Annotation>(){

            @Override
            public boolean hasNext() {
                return it == null ? false : it.hasNext();
            }

            @Override
            public Annotation next() {
                if (it == null) {
                    throw new NoSuchElementException("annotationLinks is null; no elements.");
                }
                InstrumentAnnotationLink link = (InstrumentAnnotationLink)it.next();
                return link.child();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Cannot call remove on this iterator.");
            }
        };
    }

    public Set<InstrumentAnnotationLink> findInstrumentAnnotationLink(Annotation target) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<InstrumentAnnotationLink> it = this.iterateAnnotationLinks();
        HashSet<InstrumentAnnotationLink> result = new HashSet<InstrumentAnnotationLink>();
        while (it.hasNext()) {
            InstrumentAnnotationLink link = it.next();
            if (link == null || link.child() != target) continue;
            result.add(link);
        }
        return result;
    }

    @Override
    public List<Annotation> linkedAnnotationList() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return list;
    }

    @Override
    public <E> List<E> eachLinkedAnnotation(CBlock<E> block) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<E> result = new ArrayList<E>();
        Iterator<Annotation> it = this.linkedAnnotationIterator();
        while (it.hasNext()) {
            Annotation obj = it.next();
            if (block != null) {
                result.add(block.call(obj));
                continue;
            }
            result.add(obj);
        }
        return result;
    }

    @Override
    public void unlinkAnnotation(Annotation removal) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        Set<InstrumentAnnotationLink> toRemove = this.findInstrumentAnnotationLink(removal);
        Iterator<InstrumentAnnotationLink> it = toRemove.iterator();
        while (it.hasNext()) {
            this.removeInstrumentAnnotationLink(it.next(), true);
        }
    }

    public void removeInstrumentAnnotationLink(InstrumentAnnotationLink link, boolean bothSides) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        if (this.getAnnotationLinks() == null) {
            this.throwNullCollectionException("AnnotationLinks");
        }
        this.getAnnotationLinks().remove(link);
    }

    @Override
    public void clearAnnotationLinks() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        ArrayList<InstrumentAnnotationLink> list = new ArrayList<InstrumentAnnotationLink>(this.getAnnotationLinks());
        for (InstrumentAnnotationLink link : list) {
            this.removeInstrumentAnnotationLink(link, true);
        }
    }

    protected void setAnnotationLinksCountPerOwner(Map<Long, Long> map) {
        this.annotationLinksCountPerOwner = map;
    }

    @Persister(impl=CountCollectionPersister.class)
    @ForeignKey(name="FK_count_to_Instrument_annotationLinks")
    @ElementCollection
    @MapKeyColumn(name="owner_id", insertable=false, updatable=false, nullable=false)
    @Column(name="count", insertable=false, updatable=false, nullable=false)
    @CollectionTable(name="count_Instrument_annotationLinks_by_owner", joinColumns={@JoinColumn(name="Instrument_id")})
    public Map<Long, Long> getAnnotationLinksCountPerOwner() {
        return this.annotationLinksCountPerOwner;
    }

    @Override
    @Embedded
    @Target(value=Details.class)
    public ome.model.internal.Details getDetails() {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        return this.details;
    }

    protected void setDetails(ome.model.internal.Details details) {
        if (!this._loaded) {
            this.errorIfUnloaded();
        }
        this.details = (Details)details;
    }

    @Override
    @Transient
    public boolean isValid() {
        return Validator.validate(this).isValid();
    }

    @Override
    public Validation validate() {
        return Validator.validate(this);
    }

    public Instrument newInstance() {
        return new Instrument();
    }

    public Instrument proxy() {
        return new Instrument(this.id, false);
    }

    @Override
    public boolean acceptFilter(ome.util.Filter __filter) {
        try {
            this.id = (Long)__filter.filter(ID, this.id);
            this.version = (Integer)__filter.filter(VERSION, this.version);
            this.microscope = (Microscope)__filter.filter(MICROSCOPE, this.microscope);
            this.detector = (Set)__filter.filter(DETECTOR, this.detector);
            this.objective = (Set)__filter.filter(OBJECTIVE, this.objective);
            this.lightSource = (Set)__filter.filter(LIGHTSOURCE, this.lightSource);
            this.filter = (Set)__filter.filter(FILTER, this.filter);
            this.dichroic = (Set)__filter.filter(DICHROIC, this.dichroic);
            this.filterSet = (Set)__filter.filter(FILTERSET, this.filterSet);
            this.otf = (Set)__filter.filter(OTF, this.otf);
            this.annotationLinksCountPerOwner = __filter.filter(ANNOTATIONLINKSCOUNTPEROWNER, this.annotationLinksCountPerOwner);
            this.annotationLinks = (Set)__filter.filter(ANNOTATIONLINKS, this.annotationLinks);
            this.details = (ome.model.internal.Details)__filter.filter(DETAILS, this.details);
            return true;
        }
        catch (RuntimeException re) {
            if (re.getCause() instanceof InstantiationException) {
                this.unload();
                return true;
            }
            throw re;
        }
    }

    public String toString() {
        String name = this.getClass().getName();
        StringBuilder sb = new StringBuilder(name.length() + 24);
        sb.append(name);
        if (this.id == null) {
            sb.append(":Hash_");
            sb.append(this.hashCode());
        } else {
            sb.append(":Id_");
            sb.append(this.id);
        }
        return sb.toString();
    }

    @Override
    public Set<String> fields() {
        return FIELDS;
    }

    @Override
    public Object retrieve(String field) {
        if (field == null) {
            return null;
        }
        if (field.equals(ID)) {
            return this.getId();
        }
        if (field.equals(VERSION)) {
            return this.getVersion();
        }
        if (field.equals(MICROSCOPE)) {
            return this.getMicroscope();
        }
        if (field.equals(DETECTOR)) {
            return this.getDetector();
        }
        if (field.equals(OBJECTIVE)) {
            return this.getObjective();
        }
        if (field.equals(LIGHTSOURCE)) {
            return this.getLightSource();
        }
        if (field.equals(FILTER)) {
            return this.getFilter();
        }
        if (field.equals(DICHROIC)) {
            return this.getDichroic();
        }
        if (field.equals(FILTERSET)) {
            return this.getFilterSet();
        }
        if (field.equals(OTF)) {
            return this.getOtf();
        }
        if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            return this.getAnnotationLinksCountPerOwner();
        }
        if (field.equals(ANNOTATIONLINKS)) {
            return this.getAnnotationLinks();
        }
        if (field.equals(DETAILS)) {
            return this.getDetails();
        }
        if (this._dynamicFields != null) {
            return this._dynamicFields.get(field);
        }
        return null;
    }

    @Override
    public void putAt(String field, Object value) {
        if (field == null) {
            return;
        }
        if (field.equals(ID)) {
            this.setId((Long)value);
        } else if (field.equals(VERSION)) {
            this.setVersion((Integer)value);
        } else if (field.equals(MICROSCOPE)) {
            this.setMicroscope((Microscope)value);
        } else if (field.equals(DETECTOR)) {
            this.setDetector((Set)value);
        } else if (field.equals(OBJECTIVE)) {
            this.setObjective((Set)value);
        } else if (field.equals(LIGHTSOURCE)) {
            this.setLightSource((Set)value);
        } else if (field.equals(FILTER)) {
            this.setFilter((Set)value);
        } else if (field.equals(DICHROIC)) {
            this.setDichroic((Set)value);
        } else if (field.equals(FILTERSET)) {
            this.setFilterSet((Set)value);
        } else if (field.equals(OTF)) {
            this.setOtf((Set)value);
        } else if (field.equals(ANNOTATIONLINKSCOUNTPEROWNER)) {
            this.setAnnotationLinksCountPerOwner((Map)value);
        } else if (field.equals(ANNOTATIONLINKS)) {
            this.setAnnotationLinks((Set)value);
        } else if (field.equals(DETAILS)) {
            this.setDetails((ome.model.internal.Details)value);
        } else {
            if (this._dynamicFields == null) {
                this._dynamicFields = new HashMap<String, Object>();
            }
            this._dynamicFields.put(field, value);
        }
    }

    @Override
    @Transient
    public boolean isLoaded() {
        return this._loaded;
    }

    protected void errorIfUnloaded() {
        throw new IllegalStateException("Object unloaded:" + this);
    }

    @Override
    public void unload() {
        this._loaded = false;
        this.version = null;
        this.microscope = null;
        this.detector = null;
        this.objective = null;
        this.lightSource = null;
        this.filter = null;
        this.dichroic = null;
        this.filterSet = null;
        this.otf = null;
        this.annotationLinksCountPerOwner = null;
        this.annotationLinks = null;
        this.details = null;
    }

    @Override
    @Transient
    public final GraphHolder getGraphHolder() {
        if (this._graphHolder == null) {
            this._graphHolder = new GraphHolder();
        }
        return this._graphHolder;
    }

    protected void throwNullCollectionException(String propertyName) {
        throw new ApiUsageException("Error updating collection:" + propertyName + "\nCollection is currently null. This can be seen\nby testing \"sizeOf" + propertyName + " < 0\". This implies\nthat this collection was unloaded. Please refresh this object\nin order to update this collection.\n");
    }

    static {
        HashSet<String> raw = new HashSet<String>();
        raw.add(ID);
        raw.add(VERSION);
        raw.add(MICROSCOPE);
        raw.add(DETECTOR);
        raw.add(OBJECTIVE);
        raw.add(LIGHTSOURCE);
        raw.add(FILTER);
        raw.add(DICHROIC);
        raw.add(FILTERSET);
        raw.add(OTF);
        raw.add(ANNOTATIONLINKSCOUNTPEROWNER);
        raw.add(ANNOTATIONLINKS);
        raw.add(DETAILS);
        FIELDS = Collections.unmodifiableSet(raw);
    }

    public static class Details
    extends ome.model.internal.Details {
        private static final long serialVersionUID = 3221233857L;

        public Details() {
        }

        public Details(Object[] contexts) {
            super(contexts);
        }

        @Override
        public ome.model.internal.Details newInstance() {
            return new Details(this.contexts);
        }

        @Override
        @Embedded
        public Permissions getPermissions() {
            return super.getPermissions();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="external_id", nullable=true, unique=true, insertable=true, updatable=true)
        @ForeignKey(name="FKinstrument_external_id_externalinfo")
        public ExternalInfo getExternalInfo() {
            return super.getExternalInfo();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="owner_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKinstrument_owner_id_experimenter")
        public Experimenter getOwner() {
            return super.getOwner();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="creation_id", nullable=false, unique=false, insertable=true, updatable=false)
        @ForeignKey(name="FKinstrument_creation_id_event")
        public Event getCreationEvent() {
            return super.getCreationEvent();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="group_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKinstrument_group_id_experimentergroup")
        public ExperimenterGroup getGroup() {
            return super.getGroup();
        }

        @Override
        @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.DETACH, CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH})
        @Cascade(value={org.hibernate.annotations.CascadeType.LOCK, org.hibernate.annotations.CascadeType.MERGE, org.hibernate.annotations.CascadeType.PERSIST, org.hibernate.annotations.CascadeType.REPLICATE, org.hibernate.annotations.CascadeType.REFRESH, org.hibernate.annotations.CascadeType.SAVE_UPDATE})
        @JoinColumn(name="update_id", nullable=false, unique=false, insertable=true, updatable=true)
        @ForeignKey(name="FKinstrument_update_id_event")
        public Event getUpdateEvent() {
            return super.getUpdateEvent();
        }
    }
}

