/*
 * Decompiled with CFR 0.152.
 */
package ome.security.basic;

import ome.model.IObject;
import ome.security.basic.CurrentDetails;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.PreUpdateEvent;
import org.hibernate.event.PreUpdateEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateEventListener
implements PreUpdateEventListener {
    public static final String UPDATE_EVENT = "UpdateEvent";
    private static final long serialVersionUID = -7607753637653567889L;
    private static Logger log = LoggerFactory.getLogger(UpdateEventListener.class);
    private final CurrentDetails cd;

    public UpdateEventListener(CurrentDetails cd) {
        this.cd = cd;
    }

    public boolean onPreUpdate(PreUpdateEvent event) {
        int[] dirty;
        Object entity = event.getEntity();
        if (entity instanceof IObject && !this.cd.isDisabled(UPDATE_EVENT) && (dirty = event.getPersister().findDirty(event.getState(), event.getOldState(), event.getEntity(), (SessionImplementor)event.getSession())) != null && dirty.length != 0) {
            IObject obj = (IObject)entity;
            obj.getDetails().setUpdateEvent(this.cd.getEvent());
        }
        return false;
    }
}

