/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.search.spell.SpellChecker;
import org.apache.lucene.search.spell.StringDistance;
import org.apache.lucene.search.spell.SuggestWordFrequencyComparator;
import org.apache.lucene.search.spell.SuggestWordQueue;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.FieldType;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.SolrSpellChecker;
import org.apache.solr.spelling.SpellingOptions;
import org.apache.solr.spelling.SpellingResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLuceneSpellChecker
extends SolrSpellChecker {
    public static final Logger log = LoggerFactory.getLogger(AbstractLuceneSpellChecker.class);
    public static final String SPELLCHECKER_ARG_NAME = "spellchecker";
    public static final String LOCATION = "sourceLocation";
    public static final String INDEX_DIR = "spellcheckIndexDir";
    public static final String ACCURACY = "accuracy";
    public static final String STRING_DISTANCE = "distanceMeasure";
    public static final String FIELD_TYPE = "fieldType";
    public static final String COMPARATOR_CLASS = "comparatorClass";
    public static final String SCORE_COMP = "score";
    public static final String FREQ_COMP = "freq";
    protected String field;
    protected String fieldTypeName;
    protected SpellChecker spellChecker;
    protected String sourceLocation;
    protected Directory index;
    protected Dictionary dictionary;
    public static final int DEFAULT_SUGGESTION_COUNT = 5;
    protected String indexDir;
    protected float accuracy = 0.5f;
    public static final String FIELD = "field";
    protected StringDistance sd;

    @Override
    public String init(NamedList config, SolrCore core) {
        super.init(config, core);
        this.indexDir = (String)config.get(INDEX_DIR);
        String accuracy = (String)config.get(ACCURACY);
        if (this.indexDir != null && !new File(this.indexDir).isAbsolute()) {
            this.indexDir = core.getDataDir() + File.separator + this.indexDir;
        }
        this.sourceLocation = (String)config.get(LOCATION);
        String compClass = (String)config.get(COMPARATOR_CLASS);
        Object comp = null;
        comp = compClass != null ? (compClass.equalsIgnoreCase(SCORE_COMP) ? SuggestWordQueue.DEFAULT_COMPARATOR : (compClass.equalsIgnoreCase(FREQ_COMP) ? new SuggestWordFrequencyComparator() : (Comparator)core.getResourceLoader().newInstance(compClass, new String[0]))) : SuggestWordQueue.DEFAULT_COMPARATOR;
        this.field = (String)config.get(FIELD);
        String strDistanceName = (String)config.get(STRING_DISTANCE);
        this.sd = strDistanceName != null ? (StringDistance)core.getResourceLoader().newInstance(strDistanceName, new String[0]) : new LevensteinDistance();
        try {
            this.initIndex();
            this.spellChecker = new SpellChecker(this.index, this.sd, (Comparator)comp);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (accuracy != null) {
            try {
                this.accuracy = Float.parseFloat(accuracy);
                this.spellChecker.setAccuracy(this.accuracy);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Unparseable accuracy given for dictionary: " + this.name, e);
            }
        }
        if (this.field != null && core.getSchema().getFieldTypeNoEx(this.field) != null) {
            this.analyzer = core.getSchema().getFieldType(this.field).getQueryAnalyzer();
        }
        this.fieldTypeName = (String)config.get(FIELD_TYPE);
        if (core.getSchema().getFieldTypes().containsKey(this.fieldTypeName)) {
            FieldType fieldType = core.getSchema().getFieldTypes().get(this.fieldTypeName);
            this.analyzer = fieldType.getQueryAnalyzer();
        }
        if (this.analyzer == null) {
            log.info("Using WhitespaceAnalzyer for dictionary: " + this.name);
            this.analyzer = new WhitespaceAnalyzer(core.getSolrConfig().luceneMatchVersion);
        }
        return this.name;
    }

    @Override
    public SpellingResult getSuggestions(Collection<Token> tokens, IndexReader reader, int count, boolean onlyMorePopular, boolean extendedResults) throws IOException {
        return this.getSuggestions(new SpellingOptions(tokens, reader, count, onlyMorePopular, extendedResults, this.spellChecker.getAccuracy(), null));
    }

    @Override
    public SpellingResult getSuggestions(SpellingOptions options) throws IOException {
        boolean shardRequest = false;
        SolrParams params = options.customParams;
        if (params != null) {
            shardRequest = "true".equals(params.get("isShard"));
        }
        SpellingResult result = new SpellingResult(options.tokens);
        IndexReader reader = this.determineReader(options.reader);
        Term term = this.field != null ? new Term(this.field, "") : null;
        float theAccuracy = options.accuracy == Float.MIN_VALUE ? this.spellChecker.getAccuracy() : options.accuracy;
        int count = Math.max(options.count, 5);
        for (Token token : options.tokens) {
            String tokenText = new String(token.buffer(), 0, token.length());
            String[] suggestions = this.spellChecker.suggestSimilar(tokenText, count, (IndexReader)(this.field != null ? reader : null), this.field, options.onlyMorePopular, theAccuracy);
            if (suggestions.length == 1 && suggestions[0].equals(tokenText)) continue;
            if (options.extendedResults && reader != null && this.field != null) {
                term = term.createTerm(tokenText);
                result.add(token, reader.docFreq(term));
                int countLimit = Math.min(options.count, suggestions.length);
                if (countLimit > 0) {
                    for (int i = 0; i < countLimit; ++i) {
                        term = term.createTerm(suggestions[i]);
                        result.add(token, suggestions[i], reader.docFreq(term));
                    }
                    continue;
                }
                if (!shardRequest) continue;
                List<String> suggList = Collections.emptyList();
                result.add(token, suggList);
                continue;
            }
            if (suggestions.length > 0) {
                List<String> suggList = Arrays.asList(suggestions);
                if (suggestions.length > options.count) {
                    suggList = suggList.subList(0, options.count);
                }
                result.add(token, suggList);
                continue;
            }
            if (!shardRequest) continue;
            List<String> suggList = Collections.emptyList();
            result.add(token, suggList);
        }
        return result;
    }

    protected IndexReader determineReader(IndexReader reader) {
        return reader;
    }

    @Override
    public void reload(SolrCore core, SolrIndexSearcher searcher) throws IOException {
        this.spellChecker.setSpellIndex(this.index);
    }

    protected void initIndex() throws IOException {
        this.index = this.indexDir != null ? FSDirectory.open((File)new File(this.indexDir)) : new RAMDirectory();
    }

    public float getAccuracy() {
        return this.accuracy;
    }

    public String getField() {
        return this.field;
    }

    public String getFieldTypeName() {
        return this.fieldTypeName;
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public StringDistance getStringDistance() {
        return this.sd;
    }

    public SpellChecker getSpellChecker() {
        return this.spellChecker;
    }
}

