/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import omero.RDouble;
import omero.RString;
import omero.gateway.model.ShapeData;
import omero.model.Point;
import omero.model.PointI;
import omero.model.Shape;
import omero.rtypes;

public class PointData
extends ShapeData {
    public PointData(Shape shape) {
        super(shape);
    }

    public PointData() {
        this(0.0, 0.0);
    }

    public PointData(double x, double y) {
        super((Shape)new PointI(), true);
        this.setX(x);
        this.setY(y);
    }

    public String getText() {
        Point shape = (Point)this.asIObject();
        RString value = shape.getTextValue();
        if (value == null) {
            return "";
        }
        return value.getValue();
    }

    public void setText(String text) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Point shape = (Point)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setTextValue(rtypes.rstring((String)text));
        this.setDirty(true);
    }

    public double getX() {
        Point shape = (Point)this.asIObject();
        if (shape == null) {
            return 0.0;
        }
        RDouble value = shape.getX();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setX(double x) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Point shape = (Point)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setX(rtypes.rdouble((double)x));
        this.setDirty(true);
    }

    public double getY() {
        Point shape = (Point)this.asIObject();
        if (shape == null) {
            return 0.0;
        }
        RDouble value = shape.getY();
        if (value == null) {
            return 0.0;
        }
        return value.getValue();
    }

    public void setY(double y) {
        if (this.isReadOnly()) {
            throw new IllegalArgumentException("Shape ReadOnly");
        }
        Point shape = (Point)this.asIObject();
        if (shape == null) {
            throw new IllegalArgumentException("No shape specified.");
        }
        shape.setY(rtypes.rdouble((double)y));
        this.setDirty(true);
    }
}

