/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.gui;

import bitronix.tm.journal.JournalRecord;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.DefaultTableModel;

public class DuplicatedGtridTableModel
extends DefaultTableModel {
    private final Map duplicatedGtrids;

    public DuplicatedGtridTableModel(Map map) {
        super(map.size(), 2);
        this.duplicatedGtrids = map;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Sequence number";
            }
            case 1: {
                return "GTRID";
            }
        }
        return "?";
    }

    @Override
    public Object getValueAt(int row, int column) {
        Iterator it = this.duplicatedGtrids.entrySet().iterator();
        List tlogs = null;
        for (int i = 0; i <= row && it.hasNext(); ++i) {
            Map.Entry entry = it.next();
            tlogs = (List)entry.getValue();
        }
        if (tlogs == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return this.buildTlogsSequenceNumber(tlogs);
            }
            case 1: {
                return this.buildTlogsGtrid(tlogs);
            }
        }
        return "?";
    }

    private String buildTlogsSequenceNumber(List tlogs) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tlogs.size(); ++i) {
            JournalRecord tlog = (JournalRecord)tlogs.get(i);
            sb.append(tlog.getRecordProperties().get("sequenceNumber"));
            if (i >= tlogs.size() - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String buildTlogsGtrid(List tlogs) {
        JournalRecord tlog = (JournalRecord)tlogs.get(0);
        return tlog.getGtrid().toString();
    }
}

