/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.dicom;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum DicomVR {
    AE(16709, 1),
    AS(16723, 1),
    AT(16724, 2),
    CS(17235, 1),
    DA(17473, 1),
    DS(17491, 1),
    DT(17492, 1),
    FD(17988, 8),
    FL(17996, 4),
    IS(18771, 1),
    LO(19535, 1),
    LT(19540, 1),
    OB(20290, 1),
    OD(20292, 8),
    OF(20294, 4),
    OL(20300, 4),
    OV(20310, 8),
    OW(20311, 2),
    PN(20558, 1),
    SH(21320, 1),
    SL(21324, 4),
    SQ(21329, 0),
    SS(21331, 2),
    ST(21332, 1),
    SV(21334, 8),
    TM(21581, 1),
    UC(21827, 1),
    UI(21833, 1),
    UL(21836, 4),
    UN(21838, 1),
    UR(21842, 1),
    US(21843, 2),
    UT(21844, 1),
    UV(21846, 8),
    QQ(16191, 1),
    IMPLICIT(11565, 0),
    RESERVED(65535, 0);

    private int code;
    private int width;
    private static final Map<Integer, DicomVR> lookup;

    private DicomVR(int code, int width) {
        this.code = code;
        this.width = width;
    }

    public int getCode() {
        return this.code;
    }

    public int getWidth() {
        return this.width;
    }

    public static DicomVR get(int code) {
        return lookup.get(code);
    }

    static {
        lookup = new HashMap<Integer, DicomVR>();
        for (DicomVR v : EnumSet.allOf(DicomVR.class)) {
            lookup.put(v.getCode(), v);
        }
    }
}

