/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.props;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.props.PriorityAdjustment;
import edu.umd.cs.findbugs.props.WarningProperty;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WarningPropertySet
implements Cloneable {
    private Map<WarningProperty, Object> map = new HashMap<WarningProperty, Object>();

    public String toString() {
        StringBuffer buf = new StringBuffer("{ ");
        Iterator<Map.Entry<WarningProperty, Object>> i$ = this.map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<WarningProperty, Object> entry = i$.next();
            WarningProperty prop = entry.getKey();
            Object attribute = entry.getValue();
            buf.append("  ");
            buf.append(prop.getPriorityAdjustment());
            buf.append("\t");
            buf.append(prop.getName());
            buf.append("\t");
            buf.append(attribute);
            buf.append("\n");
        }
        buf.append("}\n");
        return buf.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public WarningPropertySet addProperty(WarningProperty prop) {
        this.map.put(prop, Boolean.TRUE);
        return this;
    }

    public WarningPropertySet removeProperty(WarningProperty prop) {
        this.map.remove(prop);
        return this;
    }

    public WarningPropertySet setProperty(WarningProperty prop, String value) {
        this.map.put(prop, value);
        return this;
    }

    public void setProperty(WarningProperty prop, Boolean value) {
        this.map.put(prop, value);
    }

    public boolean containsProperty(WarningProperty prop) {
        return this.map.keySet().contains(prop);
    }

    public boolean checkProperty(WarningProperty prop, Object value) {
        Object attribute = this.getProperty(prop);
        return attribute != null && attribute.equals(value);
    }

    public Object getProperty(WarningProperty prop) {
        return this.map.get(prop);
    }

    public int computePriority(int basePriority) {
        boolean relaxedReporting = FindBugsAnalysisFeatures.isRelaxedMode();
        boolean atLeastMedium = false;
        boolean falsePositive = false;
        boolean atMostLow = false;
        int aLittleBitLower = 0;
        int priority = basePriority;
        if (!relaxedReporting) {
            Iterator<WarningProperty> i$ = this.map.keySet().iterator();
            while (i$.hasNext()) {
                WarningProperty warningProperty = i$.next();
                PriorityAdjustment adj = warningProperty.getPriorityAdjustment();
                if (adj == PriorityAdjustment.FALSE_POSITIVE) {
                    falsePositive = true;
                    continue;
                }
                if (adj == PriorityAdjustment.A_LITTLE_BIT_LOWER_PRIORITY) {
                    ++aLittleBitLower;
                    continue;
                }
                if (adj == PriorityAdjustment.A_LITTLE_BIT_HIGHER_PRIORITY) {
                    --aLittleBitLower;
                    continue;
                }
                if (adj == PriorityAdjustment.RAISE_PRIORITY) {
                    --priority;
                    continue;
                }
                if (adj == PriorityAdjustment.RAISE_PRIORITY_TO_AT_LEAST_NORMAL) {
                    --priority;
                    atLeastMedium = true;
                    continue;
                }
                if (adj == PriorityAdjustment.RAISE_PRIORITY_TO_HIGH) {
                    return 1;
                }
                if (adj == PriorityAdjustment.LOWER_PRIORITY) {
                    ++priority;
                    continue;
                }
                if (adj == PriorityAdjustment.AT_MOST_LOW) {
                    ++priority;
                    atMostLow = true;
                    continue;
                }
                if (adj == PriorityAdjustment.NO_ADJUSTMENT) continue;
                throw new IllegalStateException("Unknown priority " + adj);
            }
            if (aLittleBitLower >= 3 || priority == 1 && aLittleBitLower == 2) {
                ++priority;
            } else if (aLittleBitLower <= -2) {
                --priority;
            }
            if (atMostLow) {
                return Math.min(Math.max(3, priority), 4);
            }
            if (atLeastMedium && priority > 2) {
                priority = 2;
            } else if (falsePositive && !atLeastMedium) {
                return 5;
            }
            if (priority < 1) {
                priority = 1;
            } else if (priority > 4) {
                priority = 4;
            }
        }
        return priority;
    }

    public boolean isFalsePositive(int priority) {
        return priority > 4;
    }

    public void decorateBugInstance(BugInstance bugInstance) {
        Iterator<Map.Entry<WarningProperty, Object>> i$ = this.map.entrySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<WarningProperty, Object> entry = i$.next();
            WarningProperty prop = entry.getKey();
            Object attribute = entry.getValue();
            if (attribute == null) {
                attribute = "";
            }
            bugInstance.setProperty(prop.getName(), attribute.toString());
        }
    }
}

