/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.depend;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.optional.depend.AntAnalyzer;
import org.apache.tools.ant.taskdefs.optional.depend.ClassFileUtils;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.util.FileUtils;

public class Depend
extends MatchingTask {
    private static final int ONE_SECOND = 1000;
    private Path srcPath;
    private Path destPath;
    private File cache;
    private String[] srcPathList;
    private Hashtable affectedClassMap;
    private Hashtable classFileInfoMap;
    private Hashtable classpathDependencies;
    private Hashtable outOfDateClasses;
    private boolean closure = false;
    private boolean warnOnRmiStubs = true;
    private boolean dump = false;
    private Path dependClasspath;
    private static final String CACHE_FILE_NAME = "dependencies.txt";
    private static final String CLASSNAME_PREPEND = "||:";

    public void setClasspath(Path classpath) {
        if (this.dependClasspath == null) {
            this.dependClasspath = classpath;
        } else {
            this.dependClasspath.append(classpath);
        }
    }

    public Path getClasspath() {
        return this.dependClasspath;
    }

    public Path createClasspath() {
        if (this.dependClasspath == null) {
            this.dependClasspath = new Path(this.getProject());
        }
        return this.dependClasspath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setWarnOnRmiStubs(boolean warnOnRmiStubs) {
        this.warnOnRmiStubs = warnOnRmiStubs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hashtable readCachedDependencies(File depFile) throws IOException {
        Hashtable dependencyMap = new Hashtable();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(depFile));
            String line = null;
            Vector<String> dependencyList = null;
            String className = null;
            int prependLength = CLASSNAME_PREPEND.length();
            while ((line = in.readLine()) != null) {
                if (line.startsWith(CLASSNAME_PREPEND)) {
                    dependencyList = new Vector<String>();
                    className = line.substring(prependLength);
                    dependencyMap.put(className, dependencyList);
                    continue;
                }
                dependencyList.addElement(line);
            }
        }
        catch (Throwable throwable) {
            FileUtils.close(in);
            throw throwable;
        }
        FileUtils.close((Reader)in);
        return dependencyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCachedDependencies(Hashtable dependencyMap) throws IOException {
        if (this.cache != null) {
            BufferedWriter pw = null;
            try {
                this.cache.mkdirs();
                File depFile = new File(this.cache, CACHE_FILE_NAME);
                pw = new BufferedWriter(new FileWriter(depFile));
                Enumeration e = dependencyMap.keys();
                while (e.hasMoreElements()) {
                    String className = (String)e.nextElement();
                    pw.write(CLASSNAME_PREPEND + className);
                    pw.newLine();
                    Vector dependencyList = (Vector)dependencyMap.get(className);
                    int size = dependencyList.size();
                    for (int x = 0; x < size; ++x) {
                        pw.write(String.valueOf(dependencyList.elementAt(x)));
                        pw.newLine();
                    }
                }
            }
            catch (Throwable throwable) {
                FileUtils.close(pw);
                throw throwable;
            }
            FileUtils.close((Writer)pw);
        }
    }

    private Path getCheckClassPath() {
        if (this.dependClasspath == null) {
            return null;
        }
        String[] destPathElements = this.destPath.list();
        String[] classpathElements = this.dependClasspath.list();
        String checkPath = "";
        for (int i = 0; i < classpathElements.length; ++i) {
            String element = classpathElements[i];
            boolean inDestPath = false;
            for (int j = 0; j < destPathElements.length && !inDestPath; ++j) {
                inDestPath = destPathElements[j].equals(element);
            }
            if (inDestPath) continue;
            checkPath = checkPath.length() == 0 ? element : checkPath + ":" + element;
        }
        Path p = null;
        if (checkPath.length() > 0) {
            p = new Path(this.getProject(), checkPath);
        }
        this.log("Classpath without dest dir is " + p, 4);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void determineDependencies() throws IOException {
        this.affectedClassMap = new Hashtable();
        this.classFileInfoMap = new Hashtable();
        boolean cacheDirty = false;
        Hashtable dependencyMap = new Hashtable();
        File cacheFile = null;
        boolean cacheFileExists = true;
        long cacheLastModified = Long.MAX_VALUE;
        if (this.cache != null) {
            cacheFile = new File(this.cache, CACHE_FILE_NAME);
            cacheFileExists = cacheFile.exists();
            cacheLastModified = cacheFile.lastModified();
            if (cacheFileExists) {
                dependencyMap = this.readCachedDependencies(cacheFile);
            }
        }
        Enumeration classfileEnum = this.getClassFiles(this.destPath).elements();
        while (classfileEnum.hasMoreElements()) {
            ClassFileInfo info = (ClassFileInfo)classfileEnum.nextElement();
            this.log("Adding class info for " + info.className, 4);
            this.classFileInfoMap.put(info.className, info);
            Vector dependencyList = null;
            if (this.cache != null && cacheFileExists && cacheLastModified > info.absoluteFile.lastModified()) {
                dependencyList = (Vector)dependencyMap.get(info.className);
            }
            if (dependencyList == null) {
                AntAnalyzer analyzer = new AntAnalyzer();
                analyzer.addRootClass(info.className);
                analyzer.addClassPath(this.destPath);
                analyzer.setClosure(false);
                dependencyList = new Vector();
                Enumeration depEnum = analyzer.getClassDependencies();
                while (depEnum.hasMoreElements()) {
                    Object o = depEnum.nextElement();
                    dependencyList.addElement(o);
                    this.log("Class " + info.className + " depends on " + o, 4);
                }
                cacheDirty = true;
                dependencyMap.put(info.className, dependencyList);
            }
            Enumeration depEnum = dependencyList.elements();
            while (depEnum.hasMoreElements()) {
                String dependentClass = (String)depEnum.nextElement();
                Hashtable<String, ClassFileInfo> affectedClasses = (Hashtable<String, ClassFileInfo>)this.affectedClassMap.get(dependentClass);
                if (affectedClasses == null) {
                    affectedClasses = new Hashtable<String, ClassFileInfo>();
                    this.affectedClassMap.put(dependentClass, affectedClasses);
                }
                affectedClasses.put(info.className, info);
                this.log(dependentClass + " affects " + info.className, 4);
            }
        }
        this.classpathDependencies = null;
        Path checkPath = this.getCheckClassPath();
        if (checkPath != null) {
            this.classpathDependencies = new Hashtable();
            AntClassLoader loader = null;
            try {
                loader = this.getProject().createClassLoader(checkPath);
                Hashtable<String, void> classpathFileCache = new Hashtable<String, void>();
                Object nullFileMarker = new Object();
                Enumeration e = dependencyMap.keys();
                while (e.hasMoreElements()) {
                    String className = (String)e.nextElement();
                    this.log("Determining classpath dependencies for " + className, 4);
                    Vector dependencyList = (Vector)dependencyMap.get(className);
                    Hashtable<File, File> dependencies = new Hashtable<File, File>();
                    this.classpathDependencies.put(className, dependencies);
                    Enumeration e2 = dependencyList.elements();
                    while (e2.hasMoreElements()) {
                        void var18_17;
                        String dependency = (String)e2.nextElement();
                        this.log("Looking for " + dependency, 4);
                        Object v = classpathFileCache.get(dependency);
                        if (v == null) {
                            void var18_22;
                            Object object = nullFileMarker;
                            if (!dependency.startsWith("java.") && !dependency.startsWith("javax.")) {
                                URL classURL = loader.getResource(dependency.replace('.', '/') + ".class");
                                this.log("URL is " + classURL, 4);
                                if (classURL != null) {
                                    if (classURL.getProtocol().equals("jar")) {
                                        String jarFilePath = classURL.getFile();
                                        int classMarker = jarFilePath.indexOf(33);
                                        if (!(jarFilePath = jarFilePath.substring(0, classMarker)).startsWith("file:")) throw new IOException("Bizarre nested path in jar: protocol: " + jarFilePath);
                                        File file = new File(FileUtils.getFileUtils().fromURI(jarFilePath));
                                    } else if (classURL.getProtocol().equals("file")) {
                                        File file = new File(FileUtils.getFileUtils().fromURI(classURL.toExternalForm()));
                                    }
                                    this.log("Class " + className + " depends on " + var18_22 + " due to " + dependency, 4);
                                }
                            } else {
                                this.log("Ignoring base classlib dependency " + dependency, 4);
                            }
                            classpathFileCache.put(dependency, var18_22);
                        }
                        if (var18_17 == nullFileMarker) continue;
                        File jarFile = (File)var18_17;
                        this.log("Adding a classpath dependency on " + jarFile, 4);
                        dependencies.put(jarFile, jarFile);
                    }
                }
            }
            finally {
                if (loader != null) {
                    loader.cleanup();
                }
            }
        } else {
            this.log("No classpath to check", 4);
        }
        if (this.cache == null || !cacheDirty) return;
        this.writeCachedDependencies(dependencyMap);
    }

    private int deleteAllAffectedFiles() {
        int count = 0;
        Enumeration e = this.outOfDateClasses.elements();
        while (e.hasMoreElements()) {
            String className = (String)e.nextElement();
            count += this.deleteAffectedFiles(className);
            ClassFileInfo classInfo = (ClassFileInfo)this.classFileInfoMap.get(className);
            if (classInfo == null || !classInfo.absoluteFile.exists()) continue;
            if (classInfo.sourceFile == null) {
                this.warnOutOfDateButNotDeleted(classInfo, className, className);
                continue;
            }
            classInfo.absoluteFile.delete();
            ++count;
        }
        return count;
    }

    private int deleteAffectedFiles(String className) {
        int count = 0;
        Hashtable affectedClasses = (Hashtable)this.affectedClassMap.get(className);
        if (affectedClasses == null) {
            return count;
        }
        Enumeration e = affectedClasses.keys();
        while (e.hasMoreElements()) {
            String affectedClass = (String)e.nextElement();
            ClassFileInfo affectedClassInfo = (ClassFileInfo)affectedClasses.get(affectedClass);
            if (!affectedClassInfo.absoluteFile.exists()) continue;
            if (affectedClassInfo.sourceFile == null) {
                this.warnOutOfDateButNotDeleted(affectedClassInfo, affectedClass, className);
                continue;
            }
            this.log("Deleting file " + affectedClassInfo.absoluteFile.getPath() + " since " + className + " out of date", 3);
            affectedClassInfo.absoluteFile.delete();
            ++count;
            if (this.closure) {
                count += this.deleteAffectedFiles(affectedClass);
                continue;
            }
            if (affectedClass.indexOf("$") == -1) continue;
            String topLevelClassName = affectedClass.substring(0, affectedClass.indexOf("$"));
            this.log("Top level class = " + topLevelClassName, 3);
            ClassFileInfo topLevelClassInfo = (ClassFileInfo)this.classFileInfoMap.get(topLevelClassName);
            if (topLevelClassInfo == null || !topLevelClassInfo.absoluteFile.exists()) continue;
            this.log("Deleting file " + topLevelClassInfo.absoluteFile.getPath() + " since one of its inner classes was removed", 3);
            topLevelClassInfo.absoluteFile.delete();
            ++count;
            if (!this.closure) continue;
            count += this.deleteAffectedFiles(topLevelClassName);
        }
        return count;
    }

    private void warnOutOfDateButNotDeleted(ClassFileInfo affectedClassInfo, String affectedClass, String className) {
        if (affectedClassInfo.isUserWarned) {
            return;
        }
        int level = 1;
        if (!this.warnOnRmiStubs && this.isRmiStub(affectedClass, className)) {
            level = 3;
        }
        this.log("The class " + affectedClass + " in file " + affectedClassInfo.absoluteFile.getPath() + " is out of date due to " + className + " but has not been deleted because its source file" + " could not be determined", level);
        affectedClassInfo.isUserWarned = true;
    }

    private boolean isRmiStub(String affectedClass, String className) {
        return this.isStub(affectedClass, className, "_Stub") || this.isStub(affectedClass, className, "_Skel") || this.isStub(affectedClass, className, "_Stub") || this.isStub(affectedClass, className, "_Skel");
    }

    private boolean isStub(String affectedClass, String baseClass, String suffix) {
        return (baseClass + suffix).equals(affectedClass);
    }

    private void dumpDependencies() {
        this.log("Reverse Dependency Dump for " + this.affectedClassMap.size() + " classes:", 4);
        Enumeration classEnum = this.affectedClassMap.keys();
        while (classEnum.hasMoreElements()) {
            String className = (String)classEnum.nextElement();
            this.log(" Class " + className + " affects:", 4);
            Hashtable affectedClasses = (Hashtable)this.affectedClassMap.get(className);
            Enumeration affectedClassEnum = affectedClasses.keys();
            while (affectedClassEnum.hasMoreElements()) {
                String affectedClass = (String)affectedClassEnum.nextElement();
                ClassFileInfo info = (ClassFileInfo)affectedClasses.get(affectedClass);
                this.log("    " + affectedClass + " in " + info.absoluteFile.getPath(), 4);
            }
        }
        if (this.classpathDependencies != null) {
            this.log("Classpath file dependencies (Forward):", 4);
            Enumeration classpathEnum = this.classpathDependencies.keys();
            while (classpathEnum.hasMoreElements()) {
                String className = (String)classpathEnum.nextElement();
                this.log(" Class " + className + " depends on:", 4);
                Hashtable dependencies = (Hashtable)this.classpathDependencies.get(className);
                Enumeration classpathFileEnum = dependencies.elements();
                while (classpathFileEnum.hasMoreElements()) {
                    File classpathFile = (File)classpathFileEnum.nextElement();
                    this.log("    " + classpathFile.getPath(), 4);
                }
            }
        }
    }

    private void determineOutOfDateClasses() {
        this.outOfDateClasses = new Hashtable();
        for (int i = 0; i < this.srcPathList.length; ++i) {
            File srcDir = this.getProject().resolveFile(this.srcPathList[i]);
            if (!srcDir.exists()) continue;
            DirectoryScanner ds = this.getDirectoryScanner(srcDir);
            String[] files = ds.getIncludedFiles();
            this.scanDir(srcDir, files);
        }
        if (this.classpathDependencies == null) {
            return;
        }
        Enumeration classpathDepsEnum = this.classpathDependencies.keys();
        block1: while (classpathDepsEnum.hasMoreElements()) {
            ClassFileInfo info;
            String className = (String)classpathDepsEnum.nextElement();
            if (this.outOfDateClasses.containsKey(className) || (info = (ClassFileInfo)this.classFileInfoMap.get(className)) == null) continue;
            Hashtable dependencies = (Hashtable)this.classpathDependencies.get(className);
            Enumeration e2 = dependencies.elements();
            while (e2.hasMoreElements()) {
                File classpathFile = (File)e2.nextElement();
                if (classpathFile.lastModified() <= info.absoluteFile.lastModified()) continue;
                this.log("Class " + className + " is out of date with respect to " + classpathFile, 4);
                this.outOfDateClasses.put(className, className);
                continue block1;
            }
        }
    }

    public void execute() throws BuildException {
        try {
            long start = System.currentTimeMillis();
            if (this.srcPath == null) {
                throw new BuildException("srcdir attribute must be set", this.getLocation());
            }
            this.srcPathList = this.srcPath.list();
            if (this.srcPathList.length == 0) {
                throw new BuildException("srcdir attribute must be non-empty", this.getLocation());
            }
            if (this.destPath == null) {
                this.destPath = this.srcPath;
            }
            if (this.cache != null && this.cache.exists() && !this.cache.isDirectory()) {
                throw new BuildException("The cache, if specified, must point to a directory");
            }
            if (this.cache != null && !this.cache.exists()) {
                this.cache.mkdirs();
            }
            this.determineDependencies();
            if (this.dump) {
                this.dumpDependencies();
            }
            this.determineOutOfDateClasses();
            int count = this.deleteAllAffectedFiles();
            long duration = (System.currentTimeMillis() - start) / 1000L;
            int summaryLogLevel = count > 0 ? 2 : 4;
            this.log("Deleted " + count + " out of date files in " + duration + " seconds", summaryLogLevel);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void scanDir(File srcDir, String[] files) {
        for (int i = 0; i < files.length; ++i) {
            File srcFile = new File(srcDir, files[i]);
            if (!files[i].endsWith(".java")) continue;
            String filePath = srcFile.getPath();
            String className = filePath.substring(srcDir.getPath().length() + 1, filePath.length() - ".java".length());
            ClassFileInfo info = (ClassFileInfo)this.classFileInfoMap.get(className = ClassFileUtils.convertSlashName(className));
            if (info == null) {
                this.outOfDateClasses.put(className, className);
                continue;
            }
            if (srcFile.lastModified() <= info.absoluteFile.lastModified()) continue;
            this.outOfDateClasses.put(className, className);
        }
    }

    private Vector getClassFiles(Path classLocations) {
        String[] classLocationsList = classLocations.list();
        Vector classFileList = new Vector();
        for (int i = 0; i < classLocationsList.length; ++i) {
            File dir = new File(classLocationsList[i]);
            if (!dir.isDirectory()) continue;
            this.addClassFiles(classFileList, dir, dir);
        }
        return classFileList;
    }

    private File findSourceFile(String classname, File sourceFileKnownToExist) {
        int innerIndex = classname.indexOf("$");
        String sourceFilename = innerIndex != -1 ? classname.substring(0, innerIndex) + ".java" : classname + ".java";
        for (int i = 0; i < this.srcPathList.length; ++i) {
            File sourceFile = new File(this.srcPathList[i], sourceFilename);
            if (!sourceFile.equals(sourceFileKnownToExist) && !sourceFile.exists()) continue;
            return sourceFile;
        }
        return null;
    }

    private void addClassFiles(Vector classFileList, File dir, File root) {
        String[] filesInDir = dir.list();
        if (filesInDir == null) {
            return;
        }
        int length = filesInDir.length;
        int rootLength = root.getPath().length();
        File sourceFileKnownToExist = null;
        for (int i = 0; i < length; ++i) {
            File file = new File(dir, filesInDir[i]);
            if (filesInDir[i].endsWith(".class")) {
                ClassFileInfo info = new ClassFileInfo();
                info.absoluteFile = file;
                String relativeName = file.getPath().substring(rootLength + 1, file.getPath().length() - ".class".length());
                info.className = ClassFileUtils.convertSlashName(relativeName);
                sourceFileKnownToExist = this.findSourceFile(relativeName, sourceFileKnownToExist);
                info.sourceFile = sourceFileKnownToExist;
                classFileList.addElement(info);
                continue;
            }
            this.addClassFiles(classFileList, file, root);
        }
    }

    public void setSrcdir(Path srcPath) {
        this.srcPath = srcPath;
    }

    public void setDestDir(Path destPath) {
        this.destPath = destPath;
    }

    public void setCache(File cache) {
        this.cache = cache;
    }

    public void setClosure(boolean closure) {
        this.closure = closure;
    }

    public void setDump(boolean dump) {
        this.dump = dump;
    }

    private static class ClassFileInfo {
        private File absoluteFile;
        private String className;
        private File sourceFile;
        private boolean isUserWarned = false;

        private ClassFileInfo() {
        }
    }
}

