/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.jhotdraw.draw.Drawing;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.InputFormat;
import org.jhotdraw.draw.OutputFormat;
import org.jhotdraw.gui.datatransfer.InputStreamTransferable;
import org.jhotdraw.io.ExtensionFileFilter;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.NanoXMLDOMInput;
import org.jhotdraw.xml.NanoXMLDOMOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOMStorableInputOutputFormat
implements OutputFormat,
InputFormat {
    private DOMFactory factory;
    private String description;
    private String fileExtension;
    private String formatName;
    private String mimeType;
    private DataFlavor dataFlavor;

    public DOMStorableInputOutputFormat(DOMFactory factory) {
        this(factory, "Drawing", "xml", "image/x-jhotdraw");
    }

    public DOMStorableInputOutputFormat(DOMFactory factory, String description, String fileExtension, String mimeType) {
        this.factory = factory;
        this.fileExtension = fileExtension;
        this.mimeType = mimeType;
        try {
            this.dataFlavor = new DataFlavor(mimeType);
        }
        catch (ClassNotFoundException ex) {
            InternalError error = new InternalError("Unable to create data flavor for mime type:" + mimeType);
            error.initCause(ex);
            throw error;
        }
    }

    @Override
    public FileFilter getFileFilter() {
        return new ExtensionFileFilter(this.description, this.fileExtension);
    }

    @Override
    public JComponent getOutputFormatAccessory() {
        return null;
    }

    @Override
    public JComponent getInputFormatAccessory() {
        return null;
    }

    protected void read(URL url, InputStream in, Drawing drawing, LinkedList<Figure> figures) throws IOException {
        NanoXMLDOMInput domi = new NanoXMLDOMInput(this.factory, in);
        domi.openElement(this.factory.getName(drawing));
        domi.openElement("figures", 0);
        figures.clear();
        int n = domi.getElementCount();
        for (int i = 0; i < n; ++i) {
            Figure f = (Figure)domi.readObject();
            figures.add(f);
        }
        domi.closeElement();
        domi.closeElement();
        drawing.basicAddAll(drawing.getFigureCount(), figures);
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file, Drawing drawing) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.write(out, drawing);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    @Override
    public void write(OutputStream out, Drawing drawing) throws IOException {
        NanoXMLDOMOutput domo = new NanoXMLDOMOutput(this.factory);
        domo.openElement(this.factory.getName(drawing));
        drawing.write(domo);
        domo.closeElement();
        domo.save(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(File file, Drawing drawing) throws IOException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            this.read(in, drawing);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Override
    public void read(InputStream in, Drawing drawing) throws IOException {
        NanoXMLDOMInput domi = new NanoXMLDOMInput(this.factory, in);
        domi.openElement(this.factory.getName(drawing));
        drawing.read(domi);
        domi.closeElement();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(this.dataFlavor);
    }

    @Override
    public List<Figure> readFigures(Transferable t) throws UnsupportedFlavorException, IOException {
        LinkedList<Figure> figures = new LinkedList<Figure>();
        InputStream in = (InputStream)t.getTransferData(new DataFlavor(this.mimeType, this.description));
        NanoXMLDOMInput domi = new NanoXMLDOMInput(this.factory, in);
        domi.openElement("Drawing-Clip");
        int n = domi.getElementCount();
        for (int i = 0; i < n; ++i) {
            Figure f = (Figure)domi.readObject(i);
            figures.add(f);
        }
        domi.closeElement();
        return figures;
    }

    @Override
    public Transferable createTransferable(List<Figure> figures, double scaleFactor) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        NanoXMLDOMOutput domo = new NanoXMLDOMOutput(this.factory);
        domo.openElement("Drawing-Clip");
        for (Figure f : figures) {
            domo.writeObject(f);
        }
        domo.closeElement();
        domo.save(buf);
        return new InputStreamTransferable(new DataFlavor(this.mimeType, this.description), buf.toByteArray());
    }
}

