/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5EnumerationType;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueMDArray;
import ch.systemsx.cisd.hdf5.HDF5MDEnumBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.IHDF5EnumReader;
import ch.systemsx.cisd.hdf5.ReflectionUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import hdf.hdf5lib.exceptions.HDF5JavaException;
import java.util.Iterator;

class HDF5EnumReader
implements IHDF5EnumReader {
    protected final HDF5BaseReader baseReader;

    HDF5EnumReader(HDF5BaseReader baseReader) {
        assert (baseReader != null);
        this.baseReader = baseReader;
    }

    @Override
    public HDF5EnumerationType getType(String name) {
        this.baseReader.checkOpen();
        String dataTypePath = HDF5Utils.createDataTypePath("Enum_", this.baseReader.houseKeepingNameSuffix, name);
        long storageDataTypeId = this.baseReader.getDataTypeId(dataTypePath);
        return this.baseReader.getEnumTypeForStorageDataType(name, storageDataTypeId, true, null, null, this.baseReader.fileRegistry);
    }

    @Override
    public HDF5EnumerationType getType(String name, String[] values) throws HDF5JavaException {
        return this.getType(name, values, true);
    }

    @Override
    public <T extends Enum<?>> HDF5EnumerationType getType(Class<T> enumClass) throws HDF5JavaException {
        return this.getType(enumClass.getSimpleName(), ReflectionUtils.getEnumOptions(enumClass), true);
    }

    @Override
    public HDF5EnumerationType getType(Class<? extends Enum<?>> enumClass, boolean check) throws HDF5JavaException {
        return this.getType(enumClass.getSimpleName(), ReflectionUtils.getEnumOptions(enumClass), check);
    }

    @Override
    public HDF5EnumerationType getType(String name, Class<? extends Enum<?>> enumClass) throws HDF5JavaException {
        return this.getType(name, ReflectionUtils.getEnumOptions(enumClass), true);
    }

    @Override
    public <T extends Enum<?>> HDF5EnumerationType getType(String name, Class<T> enumClass, boolean check) throws HDF5JavaException {
        return this.getType(name, ReflectionUtils.getEnumOptions(enumClass), check);
    }

    @Override
    public HDF5EnumerationType getType(String name, String[] values, boolean check) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5EnumerationType dataType = this.getType(name);
        if (check) {
            this.baseReader.checkEnumValues(dataType.getStorageTypeId(), values, name);
        }
        return dataType;
    }

    @Override
    public HDF5EnumerationType getType(EnumerationType genericType) throws HDF5JavaException {
        return this.getType(genericType, true);
    }

    @Override
    public HDF5EnumerationType getType(EnumerationType genericType, boolean check) throws HDF5JavaException {
        this.baseReader.checkOpen();
        HDF5EnumerationType dataType = this.getType(genericType.tryGetName());
        if (check) {
            this.baseReader.checkEnumValues(dataType.getStorageTypeId(), genericType.getValueArray(), genericType.tryGetName());
        }
        return dataType;
    }

    @Override
    public HDF5EnumerationType getDataSetType(final String dataSetPath) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5EnumerationType> readEnumTypeCallable = new ICallableWithCleanUp<HDF5EnumerationType>(){

            @Override
            public HDF5EnumerationType call(ICleanUpRegistry registry) {
                long dataSetId = HDF5EnumReader.this.baseReader.h5.openDataSet(HDF5EnumReader.this.baseReader.fileId, dataSetPath, registry);
                return HDF5EnumReader.this.getEnumTypeForDataSetId(dataSetId, dataSetPath, HDF5EnumReader.this.baseReader.isScaledEnum(dataSetId, registry), registry);
            }
        };
        return this.baseReader.runner.call(readEnumTypeCallable);
    }

    private HDF5EnumerationType getEnumTypeForDataSetId(long objectId, String objectName, boolean scaledEnum, ICleanUpRegistry registry) {
        if (scaledEnum) {
            String enumTypeName = this.baseReader.getStringAttribute(objectId, objectName, HDF5Utils.getEnumTypeNameAttributeName(this.baseReader.houseKeepingNameSuffix), false, registry);
            return this.getType(enumTypeName);
        }
        long storageDataTypeId = this.baseReader.h5.getDataTypeForDataSet(objectId, this.baseReader.fileRegistry);
        return this.baseReader.getEnumTypeForStorageDataType(null, storageDataTypeId, true, objectName, null, this.baseReader.fileRegistry);
    }

    @Override
    public HDF5EnumerationType getAttributeType(final String dataSetPath, final String attributeName) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5EnumerationType> readEnumTypeCallable = new ICallableWithCleanUp<HDF5EnumerationType>(){

            @Override
            public HDF5EnumerationType call(ICleanUpRegistry registry) {
                long dataSetId = HDF5EnumReader.this.baseReader.h5.openDataSet(HDF5EnumReader.this.baseReader.fileId, dataSetPath, registry);
                long attributeId = HDF5EnumReader.this.baseReader.h5.openAttribute(dataSetId, attributeName, registry);
                long storageDataTypeId = HDF5EnumReader.this.baseReader.h5.getDataTypeForAttribute(attributeId, HDF5EnumReader.this.baseReader.fileRegistry);
                return HDF5EnumReader.this.baseReader.getEnumTypeForStorageDataType(null, storageDataTypeId, true, dataSetPath, attributeName, HDF5EnumReader.this.baseReader.fileRegistry);
            }
        };
        return this.baseReader.runner.call(readEnumTypeCallable);
    }

    @Override
    public String getAttrAsString(final String objectPath, final String attributeName) throws HDF5JavaException {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> readRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                int size;
                byte[] data;
                long objectId = HDF5EnumReader.this.baseReader.h5.openObject(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                long attributeId = HDF5EnumReader.this.baseReader.h5.openAttribute(objectId, attributeName, registry);
                long storageDataTypeId = HDF5EnumReader.this.baseReader.h5.getDataTypeForAttribute(attributeId, registry);
                long nativeDataTypeId = HDF5EnumReader.this.baseReader.h5.getNativeDataType(storageDataTypeId, registry);
                long enumDataTypeId = HDF5EnumReader.this.baseReader.getEnumDataTypeId(storageDataTypeId, registry);
                String value = HDF5EnumReader.this.baseReader.h5.getNameForEnumOrCompoundMemberIndex(enumDataTypeId, EnumerationType.fromStorageForm(data = HDF5EnumReader.this.baseReader.h5.readAttributeAsByteArray(attributeId, nativeDataTypeId, size = HDF5EnumReader.this.baseReader.h5.getDataTypeSize(enumDataTypeId)), 0, size));
                if (value == null) {
                    throw new HDF5JavaException("Attribute " + attributeName + " of object " + objectPath + " needs to be an Enumeration.");
                }
                return value;
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public HDF5EnumerationValue getAttr(final String objectPath, final String attributeName) throws HDF5JavaException {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5EnumerationValue> readRunnable = new ICallableWithCleanUp<HDF5EnumerationValue>(){

            @Override
            public HDF5EnumerationValue call(ICleanUpRegistry registry) {
                long objectId = HDF5EnumReader.this.baseReader.h5.openObject(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                long attributeId = HDF5EnumReader.this.baseReader.h5.openAttribute(objectId, attributeName, registry);
                long storageDataTypeId = HDF5EnumReader.this.baseReader.h5.getDataTypeForAttribute(attributeId, HDF5EnumReader.this.baseReader.fileRegistry);
                long enumTypeId = HDF5EnumReader.this.baseReader.getEnumDataTypeId(storageDataTypeId, HDF5EnumReader.this.baseReader.fileRegistry);
                HDF5EnumerationType enumType = HDF5EnumReader.this.baseReader.getEnumTypeForStorageDataType(null, enumTypeId, true, objectPath, attributeName, HDF5EnumReader.this.baseReader.fileRegistry);
                long nativeDataTypeId = storageDataTypeId != enumTypeId ? HDF5EnumReader.this.baseReader.h5.getNativeDataType(storageDataTypeId, registry) : enumType.getNativeTypeId();
                int enumOrdinal = HDF5EnumReader.this.baseReader.getEnumOrdinal(attributeId, nativeDataTypeId, enumType);
                return new HDF5EnumerationValue(enumType, enumOrdinal);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public <T extends Enum<T>> T getAttr(String objectPath, String attributeName, Class<T> enumClass) throws HDF5JavaException {
        String value = this.getAttrAsString(objectPath, attributeName);
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HDF5JavaException("The Java enum class " + enumClass.getCanonicalName() + " has no value '" + value + "'.");
        }
    }

    @Override
    public HDF5EnumerationValueArray getArrayAttr(final String objectPath, final String attributeName) throws HDF5JavaException {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5EnumerationValueArray> readRunnable = new ICallableWithCleanUp<HDF5EnumerationValueArray>(){

            @Override
            public HDF5EnumerationValueArray call(ICleanUpRegistry registry) {
                long objectId = HDF5EnumReader.this.baseReader.h5.openObject(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                long attributeId = HDF5EnumReader.this.baseReader.h5.openAttribute(objectId, attributeName, registry);
                return HDF5EnumReader.this.baseReader.getEnumValueArray(attributeId, objectPath, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    public String[] getEnumArrayAttributeAsString(String objectPath, String attributeName) throws HDF5JavaException {
        HDF5EnumerationValueArray array = this.getArrayAttr(objectPath, attributeName);
        return array.toStringArray();
    }

    @Override
    public HDF5EnumerationValueMDArray getMDArrayAttr(final String objectPath, final String attributeName) throws HDF5JavaException {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5EnumerationValueMDArray> readRunnable = new ICallableWithCleanUp<HDF5EnumerationValueMDArray>(){

            @Override
            public HDF5EnumerationValueMDArray call(ICleanUpRegistry registry) {
                long objectId = HDF5EnumReader.this.baseReader.h5.openObject(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                long attributeId = HDF5EnumReader.this.baseReader.h5.openAttribute(objectId, attributeName, registry);
                return HDF5EnumReader.this.baseReader.getEnumValueMDArray(attributeId, objectPath, attributeName, registry);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public String readAsString(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<String> writeRunnable = new ICallableWithCleanUp<String>(){

            @Override
            public String call(ICleanUpRegistry registry) {
                long dataSetId = HDF5EnumReader.this.baseReader.h5.openDataSet(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                long storageDataTypeId = HDF5EnumReader.this.baseReader.h5.getDataTypeForDataSet(dataSetId, registry);
                long nativeDataTypeId = HDF5EnumReader.this.baseReader.h5.getNativeDataType(storageDataTypeId, registry);
                int size = HDF5EnumReader.this.baseReader.h5.getDataTypeSize(nativeDataTypeId);
                byte[] data = new byte[size];
                HDF5EnumReader.this.baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, data);
                String value = HDF5EnumReader.this.baseReader.h5.getNameForEnumOrCompoundMemberIndex(storageDataTypeId, EnumerationType.fromStorageForm(data));
                if (value == null) {
                    throw new HDF5JavaException(String.valueOf(objectPath) + " needs to be an Enumeration.");
                }
                return value;
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public <T extends Enum<T>> T read(String objectPath, Class<T> enumClass) throws HDF5JavaException {
        String value = this.readAsString(objectPath);
        try {
            return Enum.valueOf(enumClass, value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HDF5JavaException("The Java enum class " + enumClass.getCanonicalName() + " has no value '" + value + "'.");
        }
    }

    @Override
    public HDF5EnumerationValue read(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5EnumerationValue> readRunnable = new ICallableWithCleanUp<HDF5EnumerationValue>(){

            @Override
            public HDF5EnumerationValue call(ICleanUpRegistry registry) {
                long dataSetId = HDF5EnumReader.this.baseReader.h5.openDataSet(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                HDF5EnumerationType enumType = HDF5EnumReader.this.getEnumTypeForDataSetId(dataSetId, objectPath, false, registry);
                return HDF5EnumReader.this.readEnumValue(dataSetId, enumType);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public HDF5EnumerationValue read(final String objectPath, final HDF5EnumerationType enumType) throws HDF5JavaException {
        assert (objectPath != null);
        assert (enumType != null);
        this.baseReader.checkOpen();
        enumType.check(this.baseReader.fileId);
        ICallableWithCleanUp<HDF5EnumerationValue> readRunnable = new ICallableWithCleanUp<HDF5EnumerationValue>(){

            @Override
            public HDF5EnumerationValue call(ICleanUpRegistry registry) {
                long dataSetId = HDF5EnumReader.this.baseReader.h5.openDataSet(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                return HDF5EnumReader.this.readEnumValue(dataSetId, enumType);
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    private HDF5EnumerationValue readEnumValue(long dataSetId, HDF5EnumerationType enumType) {
        byte[] data = new byte[enumType.getStorageForm().getStorageSize()];
        this.baseReader.h5.readDataSet(dataSetId, enumType.getNativeTypeId(), data);
        return new HDF5EnumerationValue(enumType, EnumerationType.fromStorageForm(data));
    }

    @Override
    public HDF5EnumerationValueArray readArray(final String objectPath, final HDF5EnumerationType enumTypeOrNull) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        if (enumTypeOrNull != null) {
            enumTypeOrNull.check(this.baseReader.fileId);
        }
        ICallableWithCleanUp<HDF5EnumerationValueArray> readRunnable = new ICallableWithCleanUp<HDF5EnumerationValueArray>(){

            @Override
            public HDF5EnumerationValueArray call(ICleanUpRegistry registry) {
                long dataSetId = HDF5EnumReader.this.baseReader.h5.openDataSet(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                long[] dimensions = HDF5EnumReader.this.baseReader.h5.getDataDimensions(dataSetId, registry);
                boolean scaledEnum = HDF5EnumReader.this.baseReader.isScaledEnum(dataSetId, registry);
                HDF5EnumerationType actualEnumType = enumTypeOrNull == null ? HDF5EnumReader.this.getEnumTypeForDataSetId(dataSetId, objectPath, scaledEnum, registry) : enumTypeOrNull;
                int arraySize = HDF5Utils.getOneDimensionalArraySize(dimensions);
                HDF5EnumerationType.EnumStorageForm storageForm = actualEnumType.getStorageForm();
                byte[] data = new byte[arraySize * storageForm.getStorageSize()];
                if (scaledEnum) {
                    HDF5EnumReader.this.baseReader.h5.readDataSet(dataSetId, actualEnumType.getStorageForm().getIntNativeTypeId(), data);
                } else {
                    HDF5EnumReader.this.baseReader.h5.readDataSet(dataSetId, actualEnumType.getNativeTypeId(), data);
                }
                return new HDF5EnumerationValueArray(actualEnumType, EnumerationType.fromStorageForm(data, storageForm));
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public HDF5EnumerationValueArray readArray(String objectPath) throws HDF5JavaException {
        return this.readArray(objectPath, null);
    }

    @Override
    public HDF5EnumerationValueArray readArrayBlockWithOffset(final String objectPath, final HDF5EnumerationType enumTypeOrNull, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        if (enumTypeOrNull != null) {
            enumTypeOrNull.check(this.baseReader.fileId);
        }
        ICallableWithCleanUp<HDF5EnumerationValueArray> readRunnable = new ICallableWithCleanUp<HDF5EnumerationValueArray>(){

            @Override
            public HDF5EnumerationValueArray call(ICleanUpRegistry registry) {
                long dataSetId = HDF5EnumReader.this.baseReader.h5.openDataSet(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5EnumReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                boolean scaledEnum = HDF5EnumReader.this.baseReader.isScaledEnum(dataSetId, registry);
                HDF5EnumerationType actualEnumType = enumTypeOrNull == null ? HDF5EnumReader.this.getEnumTypeForDataSetId(dataSetId, objectPath, scaledEnum, registry) : enumTypeOrNull;
                byte[] data = new byte[spaceParams.blockSize * actualEnumType.getStorageForm().getStorageSize()];
                if (scaledEnum) {
                    HDF5EnumReader.this.baseReader.h5.readDataSet(dataSetId, actualEnumType.getStorageForm().getIntNativeTypeId(), spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                } else {
                    HDF5EnumReader.this.baseReader.h5.readDataSet(dataSetId, actualEnumType.getNativeTypeId(), spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                }
                return new HDF5EnumerationValueArray(actualEnumType, EnumerationType.fromStorageForm(data, actualEnumType.getStorageForm()));
            }
        };
        return this.baseReader.runner.call(readRunnable);
    }

    @Override
    public HDF5EnumerationValueArray readArrayBlockWithOffset(String objectPath, int blockSize, long offset) {
        return this.readArrayBlockWithOffset(objectPath, null, blockSize, offset);
    }

    @Override
    public HDF5EnumerationValueArray readArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(objectPath, null, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public HDF5EnumerationValueArray readArrayBlock(String objectPath, HDF5EnumerationType enumType, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(objectPath, enumType, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public HDF5EnumerationValueMDArray readMDArray(String objectPath) throws HDF5JavaException {
        return this.readMDArray(objectPath, null);
    }

    @Override
    public HDF5EnumerationValueMDArray readMDArray(String objectPath, HDF5EnumerationType enumTypeOrNull) throws HDF5JavaException {
        return this.readMDArrayBlockWithOffset(objectPath, enumTypeOrNull, null, null);
    }

    @Override
    public HDF5EnumerationValueMDArray readMDArrayBlockWithOffset(final String objectPath, final HDF5EnumerationType enumTypeOrNull, final int[] blockDimensionsOrNull, final long[] offsetOrNull) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        if (enumTypeOrNull != null) {
            enumTypeOrNull.check(this.baseReader.fileId);
        }
        ICallableWithCleanUp<HDF5EnumerationValueMDArray> writeRunnable = new ICallableWithCleanUp<HDF5EnumerationValueMDArray>(){

            @Override
            public HDF5EnumerationValueMDArray call(ICleanUpRegistry registry) {
                long dataSetId = HDF5EnumReader.this.baseReader.h5.openDataSet(HDF5EnumReader.this.baseReader.fileId, objectPath, registry);
                boolean scaledEnum = HDF5EnumReader.this.baseReader.isScaledEnum(dataSetId, registry);
                HDF5EnumerationType actualEnumType = enumTypeOrNull == null ? HDF5EnumReader.this.getEnumTypeForDataSetId(dataSetId, objectPath, scaledEnum, registry) : enumTypeOrNull;
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5EnumReader.this.baseReader.getSpaceParameters(dataSetId, offsetOrNull, blockDimensionsOrNull, registry);
                HDF5EnumerationType.EnumStorageForm storageForm = actualEnumType.getStorageForm();
                byte[] byteArr = new byte[spaceParams.blockSize * storageForm.getStorageSize()];
                if (scaledEnum) {
                    HDF5EnumReader.this.baseReader.h5.readDataSet(dataSetId, storageForm.getIntNativeTypeId(), spaceParams.memorySpaceId, spaceParams.dataSpaceId, byteArr);
                } else {
                    HDF5EnumReader.this.baseReader.h5.readDataSet(dataSetId, actualEnumType.getNativeTypeId(), spaceParams.memorySpaceId, spaceParams.dataSpaceId, byteArr);
                }
                return new HDF5EnumerationValueMDArray(actualEnumType, EnumerationType.fromStorageForm(byteArr, spaceParams.dimensions, storageForm));
            }
        };
        return this.baseReader.runner.call(writeRunnable);
    }

    @Override
    public HDF5EnumerationValueMDArray readMDArrayBlock(String objectPath, HDF5EnumerationType type, int[] blockDimensions, long[] blockNumber) throws HDF5JavaException {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = (long)blockDimensions[i] * blockNumber[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(objectPath, type, blockDimensions, offset);
    }

    @Override
    public HDF5EnumerationValueMDArray readMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) throws HDF5JavaException {
        return this.readMDArrayBlock(objectPath, null, blockDimensions, blockNumber);
    }

    @Override
    public HDF5EnumerationValueMDArray readMDArrayBlockWithOffset(String objectPath, int[] blockDimensions, long[] offset) throws HDF5JavaException {
        return this.readMDArrayBlockWithOffset(objectPath, null, blockDimensions, offset);
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5EnumerationValueArray>> getArrayBlocks(final String objectPath, final HDF5EnumerationType enumTypeOrNull) throws HDF5JavaException {
        this.baseReader.checkOpen();
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5DataBlock<HDF5EnumerationValueArray>>(){

            @Override
            public Iterator<HDF5DataBlock<HDF5EnumerationValueArray>> iterator() {
                return new Iterator<HDF5DataBlock<HDF5EnumerationValueArray>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<HDF5EnumerationValueArray> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        HDF5EnumerationValueArray block = HDF5EnumReader.this.readArrayBlockWithOffset(objectPath, enumTypeOrNull, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<HDF5EnumerationValueArray>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5EnumerationValueArray>> getArrayBlocks(String objectPath) throws HDF5JavaException {
        return this.getArrayBlocks(objectPath, null);
    }

    @Override
    public Iterable<HDF5MDEnumBlock> getMDArrayBlocks(final String objectPath, final HDF5EnumerationType enumTypeOrNull) throws HDF5JavaException {
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(objectPath, HDF5DataTypeInformation.DataTypeInfoOptions.MINIMAL, true));
        return new Iterable<HDF5MDEnumBlock>(){

            @Override
            public Iterator<HDF5MDEnumBlock> iterator() {
                return new Iterator<HDF5MDEnumBlock>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDEnumBlock next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        HDF5EnumerationValueMDArray block = HDF5EnumReader.this.readMDArrayBlockWithOffset(objectPath, enumTypeOrNull, this.index.getBlockSize(), offset);
                        return new HDF5MDEnumBlock(block, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDEnumBlock> getMDArrayBlocks(String objectPath) throws HDF5JavaException {
        return this.getMDArrayBlocks(objectPath, null);
    }
}

