/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.jdbc;

import bitronix.tm.internal.BitronixRollbackSystemException;
import bitronix.tm.internal.BitronixSystemException;
import bitronix.tm.resource.common.AbstractXAResourceHolder;
import bitronix.tm.resource.common.RecoveryXAResourceHolder;
import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.TransactionContextHelper;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jdbc.JdbcClassHelper;
import bitronix.tm.resource.jdbc.JdbcPooledConnectionMBean;
import bitronix.tm.resource.jdbc.LruEvictionListener;
import bitronix.tm.resource.jdbc.LruStatementCache;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import bitronix.tm.resource.jdbc.lrc.LrcXADataSource;
import bitronix.tm.resource.jdbc.proxy.JdbcProxyFactory;
import bitronix.tm.utils.ManagementRegistrar;
import bitronix.tm.utils.MonotonicClock;
import bitronix.tm.utils.Scheduler;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.sql.XAConnection;
import javax.transaction.SystemException;
import javax.transaction.xa.XAResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcPooledConnection
extends AbstractXAResourceHolder<JdbcPooledConnection>
implements StateChangeListener<JdbcPooledConnection>,
JdbcPooledConnectionMBean {
    private static final Logger log = LoggerFactory.getLogger(JdbcPooledConnection.class);
    private final XAConnection xaConnection;
    private final Connection connection;
    private final XAResource xaResource;
    private final PoolingDataSource poolingDataSource;
    private final LruStatementCache statementsCache;
    private final List<Statement> uncachedStatements;
    private volatile int usageCount;
    private final String jmxName;
    private volatile Date acquisitionDate;
    private volatile Date lastReleaseDate;
    private volatile int jdbcVersionDetected;

    public JdbcPooledConnection(PoolingDataSource poolingDataSource, XAConnection xaConnection) throws SQLException {
        this.poolingDataSource = poolingDataSource;
        this.xaConnection = xaConnection;
        this.xaResource = xaConnection.getXAResource();
        this.statementsCache = new LruStatementCache(poolingDataSource.getPreparedStatementCacheSize());
        this.uncachedStatements = Collections.synchronizedList(new ArrayList());
        this.lastReleaseDate = new Date(MonotonicClock.currentTimeMillis());
        this.statementsCache.addEvictionListener(new LruEvictionListener<PreparedStatement>(){

            @Override
            public void onEviction(PreparedStatement stmt) {
                try {
                    stmt.close();
                }
                catch (SQLException ex) {
                    log.warn("error closing evicted statement", (Throwable)ex);
                }
            }
        });
        this.connection = xaConnection.getConnection();
        this.jdbcVersionDetected = JdbcClassHelper.detectJdbcVersion(this.connection);
        this.addStateChangeEventListener(this);
        if (LrcXADataSource.class.getName().equals(poolingDataSource.getClassName())) {
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingDataSource.getUniqueName() + " - changing twoPcOrderingPosition to ALWAYS_LAST_POSITION");
            }
            poolingDataSource.setTwoPcOrderingPosition(Scheduler.ALWAYS_LAST_POSITION);
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingDataSource.getUniqueName() + " - changing deferConnectionRelease to true");
            }
            poolingDataSource.setDeferConnectionRelease(true);
            if (log.isDebugEnabled()) {
                log.debug("emulating XA for resource " + poolingDataSource.getUniqueName() + " - changing useTmJoin to true");
            }
            poolingDataSource.setUseTmJoin(true);
        }
        this.jmxName = "bitronix.tm:type=JDBC,UniqueName=" + ManagementRegistrar.makeValidName(poolingDataSource.getUniqueName()) + ",Id=" + poolingDataSource.incCreatedResourcesCounter();
        ManagementRegistrar.register(this.jmxName, this);
        poolingDataSource.fireOnAcquire(this.connection);
    }

    private void applyIsolationLevel() throws SQLException {
        String isolationLevel = this.getPoolingDataSource().getIsolationLevel();
        if (isolationLevel != null) {
            int level = JdbcPooledConnection.translateIsolationLevel(isolationLevel);
            if (level < 0) {
                log.warn("invalid transaction isolation level '" + isolationLevel + "' configured, keeping the default isolation level.");
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("setting connection's isolation level to " + isolationLevel);
                }
                this.connection.setTransactionIsolation(level);
            }
        }
    }

    private static int translateIsolationLevel(String isolationLevelGuarantee) {
        if ("READ_COMMITTED".equals(isolationLevelGuarantee)) {
            return 2;
        }
        if ("READ_UNCOMMITTED".equals(isolationLevelGuarantee)) {
            return 1;
        }
        if ("REPEATABLE_READ".equals(isolationLevelGuarantee)) {
            return 4;
        }
        if ("SERIALIZABLE".equals(isolationLevelGuarantee)) {
            return 8;
        }
        try {
            return Integer.parseInt(isolationLevelGuarantee);
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.usageCount > 0) {
            log.warn("close connection with usage count > 0, " + this);
        }
        this.setState(XAStatefulHolder.State.CLOSED);
        this.statementsCache.clear();
        ManagementRegistrar.unregister(this.jmxName);
        this.poolingDataSource.unregister(this);
        try {
            this.connection.close();
        }
        finally {
            try {
                this.xaConnection.close();
            }
            finally {
                this.poolingDataSource.fireOnDestroy(this.connection);
            }
        }
    }

    public RecoveryXAResourceHolder createRecoveryXAResourceHolder() {
        return new RecoveryXAResourceHolder(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testConnection(Connection connection) throws SQLException {
        String query;
        int connectionTestTimeout = this.poolingDataSource.getEffectiveConnectionTestTimeout();
        if (this.poolingDataSource.isEnableJdbc4ConnectionTest() && this.jdbcVersionDetected >= 4) {
            Boolean isValid = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug("testing with JDBC4 isValid() method, connection of " + this);
                }
                Method isValidMethod = JdbcClassHelper.getIsValidMethod(connection);
                isValid = (Boolean)isValidMethod.invoke((Object)connection, connectionTestTimeout);
            }
            catch (Exception e) {
                log.warn("dysfunctional JDBC4 Connection.isValid() method, or negative acquisition timeout, in call to test connection of " + this + ".  Falling back to test query.");
                this.jdbcVersionDetected = 3;
            }
            if (isValid != null) {
                if (isValid.booleanValue()) {
                    if (log.isDebugEnabled()) {
                        log.debug("isValid successfully tested connection of " + this);
                    }
                    return;
                }
                throw new SQLException("connection is no longer valid");
            }
        }
        if ((query = this.poolingDataSource.getTestQuery()) == null) {
            if (log.isDebugEnabled()) {
                log.debug("no query to test connection of " + this + ", skipping test");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("testing with query '" + query + "' connection of " + this);
        }
        PreparedStatement stmt = connection.prepareStatement(query);
        try {
            stmt.setQueryTimeout(connectionTestTimeout);
            ResultSet rs = stmt.executeQuery();
            rs.close();
        }
        finally {
            stmt.close();
        }
        if (log.isDebugEnabled()) {
            log.debug("testQuery successfully tested connection of " + this);
        }
    }

    public boolean release() throws SQLException {
        if (log.isDebugEnabled()) {
            log.debug("releasing to pool " + this);
        }
        --this.usageCount;
        try {
            TransactionContextHelper.delistFromCurrentTransaction(this);
        }
        catch (BitronixRollbackSystemException ex) {
            throw new SQLException("unilateral rollback of " + this, (Throwable)((Object)ex));
        }
        catch (SystemException ex) {
            throw new SQLException("error delisting " + this, ex);
        }
        finally {
            if (this.usageCount == 0) {
                this.poolingDataSource.fireOnRelease(this.connection);
                try {
                    TransactionContextHelper.requeue(this, this.poolingDataSource);
                }
                catch (BitronixSystemException ex) {
                    ++this.usageCount;
                    throw new SQLException("error requeuing " + this, (Throwable)((Object)ex));
                }
                if (log.isDebugEnabled()) {
                    log.debug("released to pool " + this);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("not releasing " + this + " to pool yet, connection is still shared");
            }
        }
        return this.usageCount == 0;
    }

    @Override
    public XAResource getXAResource() {
        return this.xaResource;
    }

    @Override
    public ResourceBean getResourceBean() {
        return this.getPoolingDataSource();
    }

    public PoolingDataSource getPoolingDataSource() {
        return this.poolingDataSource;
    }

    @Override
    public List<JdbcPooledConnection> getXAResourceHolders() {
        return Collections.singletonList(this);
    }

    public int getJdbcVersion() {
        return this.jdbcVersionDetected;
    }

    @Override
    public Object getConnectionHandle() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("getting connection handle from " + this);
        }
        XAStatefulHolder.State oldState = this.getState();
        ++this.usageCount;
        if (this.usageCount == 1 || oldState == XAStatefulHolder.State.NOT_ACCESSIBLE) {
            this.setState(XAStatefulHolder.State.ACCESSIBLE);
        }
        if (oldState == XAStatefulHolder.State.IN_POOL) {
            if (log.isDebugEnabled()) {
                log.debug("connection " + this.xaConnection + " was in state IN_POOL, testing it");
            }
            this.testConnection(this.connection);
            this.applyIsolationLevel();
            this.applyCursorHoldabilty();
            if (TransactionContextHelper.currentTransaction() == null) {
                this.applyLocalAutoCommit();
            }
        } else if (log.isDebugEnabled()) {
            log.debug("connection " + this.xaConnection + " was in state " + (Object)((Object)oldState) + ", no need to test it");
        }
        if (log.isDebugEnabled()) {
            log.debug("got connection handle from " + this);
        }
        this.poolingDataSource.fireOnLease(this.connection);
        return this.getConnectionHandle(this.connection);
    }

    @Override
    public void stateChanged(JdbcPooledConnection source, XAStatefulHolder.State oldState, XAStatefulHolder.State newState) {
        if (newState == XAStatefulHolder.State.IN_POOL) {
            this.lastReleaseDate = new Date(MonotonicClock.currentTimeMillis());
        } else if (oldState == XAStatefulHolder.State.IN_POOL && newState == XAStatefulHolder.State.ACCESSIBLE) {
            this.acquisitionDate = new Date(MonotonicClock.currentTimeMillis());
        } else if (oldState == XAStatefulHolder.State.NOT_ACCESSIBLE && newState == XAStatefulHolder.State.ACCESSIBLE) {
            TransactionContextHelper.recycle(this);
        }
    }

    @Override
    public void stateChanging(JdbcPooledConnection source, XAStatefulHolder.State currentState, XAStatefulHolder.State futureState) {
        block8: {
            if (futureState == XAStatefulHolder.State.IN_POOL && this.usageCount > 0) {
                log.warn("usage count too high (" + this.usageCount + ") on connection returned to pool " + source);
            }
            if (futureState == XAStatefulHolder.State.IN_POOL || futureState == XAStatefulHolder.State.NOT_ACCESSIBLE) {
                if (log.isDebugEnabled()) {
                    log.debug("closing " + this.uncachedStatements.size() + " dangling uncached statement(s)");
                }
                for (Statement statement : this.uncachedStatements) {
                    try {
                        statement.close();
                    }
                    catch (SQLException ex) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug("error trying to close uncached statement " + statement, (Throwable)ex);
                    }
                }
                this.uncachedStatements.clear();
                try {
                    this.connection.clearWarnings();
                }
                catch (SQLException ex) {
                    if (!log.isDebugEnabled()) break block8;
                    log.debug("error cleaning warnings of " + this.connection, (Throwable)ex);
                }
            }
        }
    }

    public PreparedStatement getCachedStatement(LruStatementCache.CacheKey key) {
        return this.statementsCache.get(key);
    }

    public PreparedStatement putCachedStatement(LruStatementCache.CacheKey key, PreparedStatement statement) {
        return this.statementsCache.put(key, statement);
    }

    public Statement registerUncachedStatement(Statement stmt) {
        this.uncachedStatements.add(stmt);
        return stmt;
    }

    public void unregisterUncachedStatement(Statement stmt) {
        this.uncachedStatements.remove(stmt);
    }

    public String toString() {
        return "a JdbcPooledConnection from datasource " + this.poolingDataSource.getUniqueName() + " in state " + (Object)((Object)this.getState()) + " with usage count " + this.usageCount + " wrapping " + this.xaConnection;
    }

    private void applyCursorHoldabilty() throws SQLException {
        String cursorHoldability = this.getPoolingDataSource().getCursorHoldability();
        if (cursorHoldability != null) {
            int holdability = JdbcPooledConnection.translateCursorHoldability(cursorHoldability);
            if (holdability < 0) {
                log.warn("invalid cursor holdability '" + cursorHoldability + "' configured, keeping the default cursor holdability.");
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("setting connection's cursor holdability to " + cursorHoldability);
                }
                this.connection.setHoldability(holdability);
            }
        }
    }

    private static int translateCursorHoldability(String cursorHoldability) {
        if ("CLOSE_CURSORS_AT_COMMIT".equals(cursorHoldability)) {
            return 2;
        }
        if ("HOLD_CURSORS_OVER_COMMIT".equals(cursorHoldability)) {
            return 1;
        }
        return -1;
    }

    private void applyLocalAutoCommit() throws SQLException {
        String localAutoCommit = this.getPoolingDataSource().getLocalAutoCommit();
        if (localAutoCommit != null) {
            if (localAutoCommit.equalsIgnoreCase("true")) {
                if (log.isDebugEnabled()) {
                    log.debug("setting connection's auto commit to true");
                }
                this.connection.setAutoCommit(true);
            } else if (localAutoCommit.equalsIgnoreCase("false")) {
                if (log.isDebugEnabled()) {
                    log.debug("setting connection's auto commit to false");
                }
                this.connection.setAutoCommit(false);
            } else {
                log.warn("invalid auto commit '" + localAutoCommit + "' configured, keeping default auto commit");
            }
        }
    }

    private Object getConnectionHandle(Connection connection) throws SQLException {
        return JdbcProxyFactory.INSTANCE.getProxyConnection(this, connection);
    }

    @Override
    public String getStateDescription() {
        return this.getState().toString();
    }

    @Override
    public Date getAcquisitionDate() {
        return this.acquisitionDate;
    }

    @Override
    public Date getLastReleaseDate() {
        return this.lastReleaseDate;
    }

    @Override
    public Collection<String> getTransactionGtridsCurrentlyHoldingThis() {
        return this.getXAResourceHolderStateGtrids();
    }
}

