/*
 * Decompiled with CFR 0.152.
 */
package omero.gateway.model;

import ome.model.units.BigResult;
import omero.RDouble;
import omero.RLong;
import omero.gateway.model.DataObject;
import omero.gateway.model.ObjectiveData;
import omero.model.IObject;
import omero.model.Image;
import omero.model.ImagingEnvironment;
import omero.model.ImagingEnvironmentI;
import omero.model.Length;
import omero.model.LengthI;
import omero.model.Medium;
import omero.model.ObjectiveSettings;
import omero.model.ObjectiveSettingsI;
import omero.model.Pressure;
import omero.model.PressureI;
import omero.model.StageLabel;
import omero.model.StageLabelI;
import omero.model.Temperature;
import omero.model.TemperatureI;
import omero.model.enums.UnitsLength;
import omero.model.enums.UnitsPressure;
import omero.model.enums.UnitsTemperature;
import omero.rtypes;

public class ImageAcquisitionData
extends DataObject {
    private StageLabel label;
    private ImagingEnvironment environment;
    private ObjectiveSettings objectiveSettings;
    private boolean labelDirty;
    private boolean imagingEnvironmentDirty;
    private boolean objectiveSettingsDirty;
    private Medium medium;
    private ObjectiveData objective;

    public ImageAcquisitionData(Image image) {
        if (image == null) {
            throw new IllegalArgumentException("Object cannot null.");
        }
        this.setValue((IObject)image);
        this.label = image.getStageLabel();
        this.environment = image.getImagingEnvironment();
        this.objectiveSettings = image.getObjectiveSettings();
        this.medium = null;
    }

    public ObjectiveData getObjective() {
        if (this.objectiveSettings == null) {
            return null;
        }
        if (this.objective == null) {
            this.objective = new ObjectiveData(this.objectiveSettings.getObjective());
        }
        return this.objective;
    }

    public String getLabelName() {
        if (this.label == null) {
            return "";
        }
        return this.label.getName().getValue();
    }

    public Length getPositionX(UnitsLength unit) throws BigResult {
        if (this.label == null) {
            return null;
        }
        Length l = this.label.getPositionX();
        if (l == null) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    public Length getPositionY(UnitsLength unit) throws BigResult {
        if (this.label == null) {
            return null;
        }
        Length l = this.label.getPositionY();
        if (l == null) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    public Length getPositionZ(UnitsLength unit) throws BigResult {
        if (this.label == null) {
            return null;
        }
        Length l = this.label.getPositionZ();
        if (l == null) {
            return null;
        }
        return unit == null ? l : new LengthI(l, unit);
    }

    public Temperature getTemperature(UnitsTemperature unit) throws BigResult {
        if (this.environment == null) {
            return null;
        }
        Temperature t = this.environment.getTemperature();
        if (t == null) {
            return null;
        }
        return unit == null ? t : new TemperatureI(t, unit);
    }

    public Pressure getAirPressure(UnitsPressure unit) throws BigResult {
        if (this.environment == null) {
            return null;
        }
        Pressure p = this.environment.getAirPressure();
        if (p == null) {
            return null;
        }
        return unit == null ? p : new PressureI(p, unit);
    }

    public double getHumidity() {
        if (this.environment == null) {
            return -1.0;
        }
        RDouble value = this.environment.getHumidity();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getCo2Percent() {
        if (this.environment == null) {
            return -1.0;
        }
        RDouble value = this.environment.getCo2percent();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getCorrectionCollar() {
        if (this.objectiveSettings == null) {
            return -1.0;
        }
        RDouble value = this.objectiveSettings.getCorrectionCollar();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public double getRefractiveIndex() {
        if (this.objectiveSettings == null) {
            return -1.0;
        }
        RDouble value = this.objectiveSettings.getRefractiveIndex();
        if (value == null) {
            return -1.0;
        }
        return value.getValue();
    }

    public String getMedium() {
        if (this.medium != null) {
            return this.medium.getValue().getValue();
        }
        if (this.objectiveSettings == null) {
            return "";
        }
        Medium value = this.objectiveSettings.getMedium();
        if (value == null) {
            return "";
        }
        return value.getValue().getValue();
    }

    public void setLabelName(String name) {
        this.labelDirty = true;
        if (this.label == null) {
            this.label = new StageLabelI();
        }
        this.label.setName(rtypes.rstring((String)name));
    }

    public void setPositionX(Length value) {
        this.labelDirty = true;
        if (this.label == null) {
            this.label = new StageLabelI();
        }
        this.label.setPositionX(value);
    }

    public void setPositionY(Length value) {
        this.labelDirty = true;
        if (this.label == null) {
            this.label = new StageLabelI();
        }
        this.label.setPositionY(value);
    }

    public void setPositionZ(Length value) {
        this.labelDirty = true;
        if (this.label == null) {
            this.label = new StageLabelI();
        }
        this.label.setPositionZ(value);
    }

    public void setTemperature(Temperature temperature) {
        this.imagingEnvironmentDirty = true;
        if (this.environment == null) {
            this.environment = new ImagingEnvironmentI();
        }
        this.environment.setTemperature(temperature);
    }

    public void setAirPressure(Pressure pressure) {
        this.imagingEnvironmentDirty = true;
        if (this.environment == null) {
            this.environment = new ImagingEnvironmentI();
        }
        this.environment.setAirPressure(pressure);
    }

    public void setHumidity(double humidity) {
        if (humidity < 0.0 || humidity > 1.0) {
            throw new IllegalArgumentException("Humidity must be a value in [0, 1]");
        }
        this.imagingEnvironmentDirty = true;
        if (this.environment == null) {
            this.environment = new ImagingEnvironmentI();
        }
        this.environment.setHumidity(rtypes.rdouble((double)humidity));
    }

    public void setCo2Percent(double co2) {
        if (co2 < 0.0 || co2 > 1.0) {
            throw new IllegalArgumentException("Co2 must be a value in [0, 1]");
        }
        this.imagingEnvironmentDirty = true;
        if (this.environment == null) {
            this.environment = new ImagingEnvironmentI();
        }
        this.environment.setCo2percent(rtypes.rdouble((double)co2));
    }

    public void setCorrectionCollar(double correction) {
        this.objectiveSettingsDirty = true;
        if (this.objectiveSettings == null) {
            this.objectiveSettings = new ObjectiveSettingsI();
        }
        this.objectiveSettings.setCorrectionCollar(rtypes.rdouble((double)correction));
    }

    public void setRefractiveIndex(double index) {
        this.objectiveSettingsDirty = true;
        if (this.objectiveSettings == null) {
            this.objectiveSettings = new ObjectiveSettingsI();
        }
        this.objectiveSettings.setRefractiveIndex(rtypes.rdouble((double)index));
    }

    public void setMedium(Medium medium) {
        this.medium = medium;
        this.objectiveSettingsDirty = true;
    }

    public boolean isStageLabelDirty() {
        return this.labelDirty;
    }

    public boolean isImagingEnvironmentDirty() {
        return this.imagingEnvironmentDirty;
    }

    public boolean isObjectiveSettingsDirty() {
        return this.objectiveSettingsDirty;
    }

    public long getStageLabelId() {
        if (this.label == null) {
            return -1L;
        }
        RLong id = this.label.getId();
        if (id == null) {
            return -1L;
        }
        return id.getValue();
    }

    public long getImagingEnvironmentId() {
        if (this.environment == null) {
            return -1L;
        }
        RLong id = this.environment.getId();
        if (id == null) {
            return -1L;
        }
        return id.getValue();
    }

    public long getObjectiveSettingsId() {
        if (this.objectiveSettings == null) {
            return -1L;
        }
        RLong id = this.objectiveSettings.getId();
        if (id == null) {
            return -1L;
        }
        return id.getValue();
    }

    public Medium getMediumAsEnum() {
        return this.medium;
    }
}

