/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;

public class MemTracker {
    private List<Mem> memList = new ArrayList<Mem>();
    private long fileSize;

    public MemTracker(long fileSize) {
        this.fileSize = fileSize;
    }

    public void add(String name, long start, long end) {
        this.memList.add(new Mem(name, start, end));
    }

    public void addByLen(String name, long start, long size) {
        this.memList.add(new Mem(name, start, start + size));
    }

    public void report(Formatter f) {
        f.format("Memory used file size= %d%n", this.fileSize);
        f.format("  start    end   size   name", new Object[0]);
        Collections.sort(this.memList);
        Mem prev = null;
        for (Mem m : this.memList) {
            if (prev != null && m.start > prev.end) {
                f.format(" + %6d %6d %6d %6s%n", prev.end, m.start, m.start - prev.end, "HOLE");
            }
            char c = prev != null && prev.end != m.start ? (char)'*' : ' ';
            f.format(" %s %6d %6d %6d %6s%n", Character.valueOf(c), m.start, m.end, m.end - m.start, m.name);
            prev = m;
        }
        f.format("%n", new Object[0]);
    }

    static class Mem
    implements Comparable<Mem> {
        public String name;
        public long start;
        public long end;

        Mem(String name, long start, long end) {
            this.name = name;
            this.start = start;
            this.end = end;
        }

        @Override
        public int compareTo(Mem m) {
            return Long.compare(this.start, m.start);
        }
    }
}

