/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import java.util.ArrayList;
import java.util.List;
import ome.xml.model.Annotation;
import ome.xml.model.AnnotationRef;
import ome.xml.model.FilterSet;
import ome.xml.model.Instrument;
import ome.xml.model.LightPath;
import ome.xml.model.ManufacturerSpec;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.ReferenceList;
import ome.xml.model.TransmittanceRange;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FilterType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Filter
extends ManufacturerSpec {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(Filter.class);
    private FilterType type;
    private String filterWheel;
    private String id;
    private TransmittanceRange transmittanceRange;
    private List<Annotation> annotationLinks = new ReferenceList<Annotation>();
    private Instrument instrument;
    private List<FilterSet> filterSetExcitationFilterLinks = new ReferenceList<FilterSet>();
    private List<FilterSet> filterSetEmissionFilterLinks = new ReferenceList<FilterSet>();
    private List<LightPath> lightPathExcitationFilterLinks = new ReferenceList<LightPath>();
    private List<LightPath> lightPathEmissionFilterLinks = new ReferenceList<LightPath>();

    public Filter() {
    }

    public Filter(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public Filter(Filter orig) {
        super(orig);
        this.type = orig.type;
        this.filterWheel = orig.filterWheel;
        this.id = orig.id;
        this.transmittanceRange = orig.transmittanceRange;
        this.annotationLinks = orig.annotationLinks;
        this.instrument = orig.instrument;
        this.filterSetExcitationFilterLinks = orig.filterSetExcitationFilterLinks;
        this.filterSetEmissionFilterLinks = orig.filterSetEmissionFilterLinks;
        this.lightPathExcitationFilterLinks = orig.lightPathExcitationFilterLinks;
        this.lightPathEmissionFilterLinks = orig.lightPathEmissionFilterLinks;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        List<Element> TransmittanceRange_nodeList;
        super.update(element, model);
        if (element.hasAttribute("Type")) {
            this.setType(FilterType.fromString(element.getAttribute("Type")));
        }
        if (element.hasAttribute("FilterWheel")) {
            this.setFilterWheel(String.valueOf(element.getAttribute("FilterWheel")));
        }
        if (!element.hasAttribute("ID") && this.getID() == null) {
            throw new RuntimeException("Filter missing required ID property.");
        }
        if (element.hasAttribute("ID")) {
            this.setID(String.valueOf(element.getAttribute("ID")));
            model.addModelObject(this.getID(), this);
        }
        if ((TransmittanceRange_nodeList = Filter.getChildrenByTagName(element, "TransmittanceRange")).size() > 1) {
            throw new RuntimeException(String.format("TransmittanceRange node list size %d != 1", TransmittanceRange_nodeList.size()));
        }
        if (TransmittanceRange_nodeList.size() != 0) {
            this.setTransmittanceRange(new TransmittanceRange(TransmittanceRange_nodeList.get(0), model));
        }
        List<Element> AnnotationRef_nodeList = Filter.getChildrenByTagName(element, "AnnotationRef");
        for (Element AnnotationRef_element : AnnotationRef_nodeList) {
            AnnotationRef annotationLinks_reference = new AnnotationRef();
            annotationLinks_reference.setID(AnnotationRef_element.getAttribute("ID"));
            model.addReference(this, annotationLinks_reference);
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        if (reference instanceof AnnotationRef) {
            Annotation o_casted = (Annotation)o;
            o_casted.linkFilter(this);
            this.annotationLinks.add(o_casted);
            return true;
        }
        return super.link(reference, o);
    }

    public FilterType getType() {
        return this.type;
    }

    public void setType(FilterType type) {
        this.type = type;
    }

    public String getFilterWheel() {
        return this.filterWheel;
    }

    public void setFilterWheel(String filterWheel) {
        this.filterWheel = filterWheel;
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public TransmittanceRange getTransmittanceRange() {
        return this.transmittanceRange;
    }

    public void setTransmittanceRange(TransmittanceRange transmittanceRange) {
        this.transmittanceRange = transmittanceRange;
    }

    public int sizeOfLinkedAnnotationList() {
        return this.annotationLinks.size();
    }

    public List<Annotation> copyLinkedAnnotationList() {
        return new ArrayList<Annotation>(this.annotationLinks);
    }

    public Annotation getLinkedAnnotation(int index) {
        return this.annotationLinks.get(index);
    }

    public Annotation setLinkedAnnotation(int index, Annotation o) {
        return this.annotationLinks.set(index, o);
    }

    public boolean linkAnnotation(Annotation o) {
        o.linkFilter(this);
        return this.annotationLinks.add(o);
    }

    public boolean unlinkAnnotation(Annotation o) {
        o.unlinkFilter(this);
        return this.annotationLinks.remove(o);
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(Instrument instrument_BackReference) {
        this.instrument = instrument_BackReference;
    }

    public int sizeOfLinkedFilterSetExcitationFilterList() {
        return this.filterSetExcitationFilterLinks.size();
    }

    public List<FilterSet> copyLinkedFilterSetExcitationFilterList() {
        return new ArrayList<FilterSet>(this.filterSetExcitationFilterLinks);
    }

    public FilterSet getLinkedFilterSetExcitationFilter(int index) {
        return this.filterSetExcitationFilterLinks.get(index);
    }

    public FilterSet setLinkedFilterSetExcitationFilter(int index, FilterSet o) {
        return this.filterSetExcitationFilterLinks.set(index, o);
    }

    public boolean linkFilterSetExcitationFilter(FilterSet o) {
        return this.filterSetExcitationFilterLinks.add(o);
    }

    public boolean unlinkFilterSetExcitationFilter(FilterSet o) {
        return this.filterSetExcitationFilterLinks.remove(o);
    }

    public int sizeOfLinkedFilterSetEmissionFilterList() {
        return this.filterSetEmissionFilterLinks.size();
    }

    public List<FilterSet> copyLinkedFilterSetEmissionFilterList() {
        return new ArrayList<FilterSet>(this.filterSetEmissionFilterLinks);
    }

    public FilterSet getLinkedFilterSetEmissionFilter(int index) {
        return this.filterSetEmissionFilterLinks.get(index);
    }

    public FilterSet setLinkedFilterSetEmissionFilter(int index, FilterSet o) {
        return this.filterSetEmissionFilterLinks.set(index, o);
    }

    public boolean linkFilterSetEmissionFilter(FilterSet o) {
        return this.filterSetEmissionFilterLinks.add(o);
    }

    public boolean unlinkFilterSetEmissionFilter(FilterSet o) {
        return this.filterSetEmissionFilterLinks.remove(o);
    }

    public int sizeOfLinkedLightPathExcitationFilterList() {
        return this.lightPathExcitationFilterLinks.size();
    }

    public List<LightPath> copyLinkedLightPathExcitationFilterList() {
        return new ArrayList<LightPath>(this.lightPathExcitationFilterLinks);
    }

    public LightPath getLinkedLightPathExcitationFilter(int index) {
        return this.lightPathExcitationFilterLinks.get(index);
    }

    public LightPath setLinkedLightPathExcitationFilter(int index, LightPath o) {
        return this.lightPathExcitationFilterLinks.set(index, o);
    }

    public boolean linkLightPathExcitationFilter(LightPath o) {
        return this.lightPathExcitationFilterLinks.add(o);
    }

    public boolean unlinkLightPathExcitationFilter(LightPath o) {
        return this.lightPathExcitationFilterLinks.remove(o);
    }

    public int sizeOfLinkedLightPathEmissionFilterList() {
        return this.lightPathEmissionFilterLinks.size();
    }

    public List<LightPath> copyLinkedLightPathEmissionFilterList() {
        return new ArrayList<LightPath>(this.lightPathEmissionFilterLinks);
    }

    public LightPath getLinkedLightPathEmissionFilter(int index) {
        return this.lightPathEmissionFilterLinks.get(index);
    }

    public LightPath setLinkedLightPathEmissionFilter(int index, LightPath o) {
        return this.lightPathEmissionFilterLinks.set(index, o);
    }

    public boolean linkLightPathEmissionFilter(LightPath o) {
        return this.lightPathEmissionFilterLinks.add(o);
    }

    public boolean unlinkLightPathEmissionFilter(LightPath o) {
        return this.lightPathEmissionFilterLinks.remove(o);
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element Filter_element) {
        if (Filter_element == null) {
            Filter_element = document.createElementNS(NAMESPACE, "Filter");
        }
        super.asXMLElement(document, Filter_element);
        if (this.type != null) {
            Filter_element.setAttribute("Type", this.type.toString());
        }
        if (this.filterWheel != null) {
            Filter_element.setAttribute("FilterWheel", this.filterWheel);
        }
        if (this.id != null) {
            Filter_element.setAttribute("ID", this.id);
        }
        if (this.transmittanceRange != null) {
            Element child = document.createElementNS(NAMESPACE, "TransmittanceRange");
            this.transmittanceRange.asXMLElement(document, child);
            Filter_element.appendChild(child);
        }
        if (this.annotationLinks != null) {
            for (Annotation annotationLinks_value : this.annotationLinks) {
                AnnotationRef o = new AnnotationRef();
                o.setID(annotationLinks_value.getID());
                Element child = document.createElementNS(NAMESPACE, "AnnotationRef");
                o.asXMLElement(document, child);
                Filter_element.appendChild(child);
            }
        }
        return Filter_element;
    }
}

