/*
 * Decompiled with CFR 0.152.
 */
package ome.xml.model;

import ome.xml.model.AbstractOMEModelObject;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Reference;
import ome.xml.model.enums.Compression;
import ome.xml.model.enums.EnumerationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class External
extends AbstractOMEModelObject {
    public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    private static final Logger LOGGER = LoggerFactory.getLogger(External.class);
    private String href;
    private String sha1;
    private Compression compression;

    public External() {
    }

    public External(Element element, OMEModel model) throws EnumerationException {
        this.update(element, model);
    }

    public External(External orig) {
        this.href = orig.href;
        this.sha1 = orig.sha1;
        this.compression = orig.compression;
    }

    @Override
    public void update(Element element, OMEModel model) throws EnumerationException {
        super.update(element, model);
        if (element.hasAttribute("href")) {
            this.sethref(String.valueOf(element.getAttribute("href")));
        }
        if (element.hasAttribute("SHA1")) {
            this.setSHA1(String.valueOf(element.getAttribute("SHA1")));
        }
        if (element.hasAttribute("Compression")) {
            this.setCompression(Compression.fromString(element.getAttribute("Compression")));
        }
    }

    @Override
    public boolean link(Reference reference, OMEModelObject o) {
        return super.link(reference, o);
    }

    public String gethref() {
        return this.href;
    }

    public void sethref(String href) {
        this.href = href;
    }

    public String getSHA1() {
        return this.sha1;
    }

    public void setSHA1(String sha1) {
        this.sha1 = sha1;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    @Override
    public Element asXMLElement(Document document) {
        return this.asXMLElement(document, null);
    }

    @Override
    public Element asXMLElement(Document document, Element External_element) {
        if (External_element == null) {
            External_element = document.createElementNS(NAMESPACE, "External");
        }
        super.asXMLElement(document, External_element);
        if (this.href != null) {
            External_element.setAttribute("href", this.href);
        }
        if (this.sha1 != null) {
            External_element.setAttribute("SHA1", this.sha1);
        }
        if (this.compression != null) {
            External_element.setAttribute("Compression", this.compression.toString());
        }
        return External_element;
    }
}

